/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferHolder;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.ssl.PemEncoded;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

public final class PemPrivateKey
extends BufferHolder<PemPrivateKey>
implements PrivateKey,
PemEncoded {
    private static final long serialVersionUID = 7978017465645018936L;
    private static final byte[] BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] END_PRIVATE_KEY = "\n-----END PRIVATE KEY-----\n".getBytes(StandardCharsets.US_ASCII);
    private static final String PKCS8_FORMAT = "PKCS#8";

    static PemEncoded toPEM(PrivateKey key) {
        if (key instanceof PemEncoded) {
            return ((PemEncoded)((Object)key)).copy();
        }
        byte[] bytes = key.getEncoded();
        if (bytes == null) {
            throw new IllegalArgumentException(key.getClass().getName() + " does not support encoding");
        }
        return PemPrivateKey.toPEM(bytes);
    }

    /*
     * Exception decompiling
     */
    static PemEncoded toPEM(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PemPrivateKey valueOf(byte[] key) {
        return PemPrivateKey.valueOf(DefaultBufferAllocators.offHeapAllocator().copyOf(key));
    }

    public static PemPrivateKey valueOf(Buffer key) {
        return new PemPrivateKey(key);
    }

    private PemPrivateKey(Buffer content) {
        super(content.makeReadOnly());
    }

    @Override
    public Buffer content() {
        if (!this.isAccessible()) {
            throw new IllegalStateException("PemPrivateKey is closed.");
        }
        return this.getBuffer();
    }

    @Override
    public PemPrivateKey copy() {
        Buffer buffer = this.getBuffer();
        return new PemPrivateKey(buffer.copy(true));
    }

    protected PemPrivateKey receive(Buffer buf) {
        return new PemPrivateKey(buf);
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFormat() {
        return PKCS8_FORMAT;
    }

    @Override
    public void destroy() {
        this.close();
    }

    @Override
    public boolean isDestroyed() {
        return !this.isAccessible();
    }
}

