/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty5.handler.ssl.OpenSsl;
import io.netty5.handler.ssl.SslUtils;
import java.security.Provider;

public enum SslProvider {
    JDK,
    OPENSSL,
    OPENSSL_REFCNT;


    public static boolean isAlpnSupported(SslProvider provider) {
        switch (provider) {
            case JDK: {
                return JdkAlpnApplicationProtocolNegotiator.isAlpnSupported();
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isAlpnSupported();
            }
        }
        throw new Error("Unknown SslProvider: " + provider);
    }

    public static boolean isTlsv13Supported(SslProvider sslProvider) {
        return SslProvider.isTlsv13Supported(sslProvider, null);
    }

    public static boolean isTlsv13Supported(SslProvider sslProvider, Provider provider) {
        switch (sslProvider) {
            case JDK: {
                return SslUtils.isTLSv13SupportedByJDK(provider);
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + sslProvider);
    }

    static boolean isTlsv13EnabledByDefault(SslProvider sslProvider, Provider provider) {
        switch (sslProvider) {
            case JDK: {
                return SslUtils.isTLSv13EnabledByJDK(provider);
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + sslProvider);
    }
}

