/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl.ocsp;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty5.handler.ssl.SslHandshakeCompletionEvent;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;
import javax.net.ssl.SSLHandshakeException;

@UnstableApi
public abstract class OcspClientHandler
implements ChannelHandler {
    private final ReferenceCountedOpenSslEngine engine;

    protected OcspClientHandler(ReferenceCountedOpenSslEngine engine) {
        this.engine = Objects.requireNonNull(engine, "engine");
    }

    protected abstract boolean verify(ChannelHandlerContext var1, ReferenceCountedOpenSslEngine var2) throws Exception;

    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireChannelInboundEvent(evt);
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess() && !this.verify(ctx, this.engine)) {
                throw new SSLHandshakeException("Bad OCSP response");
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

