/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl.util;

import io.netty5.buffer.BufferUtil;
import io.netty5.handler.ssl.util.FingerprintTrustManagerFactoryBuilder;
import io.netty5.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.StringUtil;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private final FastThreadLocal<MessageDigest> tlmd;
    private final TrustManager tm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s) throws CertificateException {
            this.checkTrusted("client", chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s) throws CertificateException {
            this.checkTrusted("server", chain);
        }

        private void checkTrusted(String type, X509Certificate[] chain) throws CertificateException {
            X509Certificate cert = chain[0];
            byte[] fingerprint = this.fingerprint(cert);
            boolean found = false;
            for (byte[] allowedFingerprint : FingerprintTrustManagerFactory.this.fingerprints) {
                if (!Arrays.equals(fingerprint, allowedFingerprint)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new CertificateException(type + " certificate with unknown fingerprint: " + cert.getSubjectDN());
            }
        }

        private byte[] fingerprint(X509Certificate cert) throws CertificateEncodingException {
            MessageDigest md = (MessageDigest)FingerprintTrustManagerFactory.this.tlmd.get();
            md.reset();
            return md.digest(cert.getEncoded());
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };
    private final byte[][] fingerprints;

    public static FingerprintTrustManagerFactoryBuilder builder(String algorithm) {
        return new FingerprintTrustManagerFactoryBuilder(algorithm);
    }

    FingerprintTrustManagerFactory(final String algorithm, byte[][] fingerprints) {
        MessageDigest md;
        Objects.requireNonNull(algorithm, "algorithm");
        Objects.requireNonNull(fingerprints, "fingerprints");
        if (fingerprints.length == 0) {
            throw new IllegalArgumentException("No fingerprints provided");
        }
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", algorithm), e);
        }
        int hashLength = md.getDigestLength();
        ArrayList<byte[]> list = new ArrayList<byte[]>(fingerprints.length);
        for (byte[] f : fingerprints) {
            if (f == null) break;
            if (f.length != hashLength) {
                throw new IllegalArgumentException(String.format("malformed fingerprint (length is %d but expected %d): %s", f.length, hashLength, BufferUtil.hexDump((byte[])f)));
            }
            list.add((byte[])f.clone());
        }
        this.tlmd = new FastThreadLocal<MessageDigest>(){

            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", algorithm), e);
                }
            }
        };
        this.fingerprints = (byte[][])list.toArray((T[])EmptyArrays.EMPTY_BYTES_BYTES);
    }

    static byte[][] toFingerprintArray(Iterable<String> fingerprints) {
        Objects.requireNonNull(fingerprints, "fingerprints");
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String f : fingerprints) {
            if (f == null) break;
            if (!FINGERPRINT_PATTERN.matcher(f).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + f);
            }
            f = FINGERPRINT_STRIP_PATTERN.matcher(f).replaceAll("");
            list.add(StringUtil.decodeHexDump((CharSequence)f));
        }
        return (byte[][])list.toArray((T[])EmptyArrays.EMPTY_BYTES_BYTES);
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }
}

