/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.EventLoop;
import io.netty5.resolver.dns.Cache;
import io.netty5.resolver.dns.DnsCnameCache;
import io.netty5.util.AsciiString;
import io.netty5.util.internal.ObjectUtil;
import java.util.List;
import java.util.Objects;

public final class DefaultDnsCnameCache
implements DnsCnameCache {
    private final int minTtl;
    private final int maxTtl;
    private final Cache<String> cache = new Cache<String>(){

        @Override
        protected boolean shouldReplaceAll(String entry) {
            return true;
        }

        @Override
        protected boolean equals(String entry, String otherEntry) {
            return AsciiString.contentEqualsIgnoreCase((CharSequence)entry, (CharSequence)otherEntry);
        }
    };

    public DefaultDnsCnameCache() {
        this(0, Cache.MAX_SUPPORTED_TTL_SECS);
    }

    public DefaultDnsCnameCache(int minTtl, int maxTtl) {
        this.minTtl = Math.min(Cache.MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositiveOrZero((int)minTtl, (String)"minTtl"));
        this.maxTtl = Math.min(Cache.MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositive((int)maxTtl, (String)"maxTtl"));
        if (minTtl > maxTtl) {
            throw new IllegalArgumentException("minTtl: " + minTtl + ", maxTtl: " + maxTtl + " (expected: 0 <= minTtl <= maxTtl)");
        }
    }

    @Override
    public String get(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        List<String> cached = this.cache.get(hostname);
        if (cached == null || cached.isEmpty()) {
            return null;
        }
        return cached.get(0);
    }

    @Override
    public void cache(String hostname, String cname, long originalTtl, EventLoop loop) {
        Objects.requireNonNull(hostname, "hostname");
        Objects.requireNonNull(cname, "cname");
        Objects.requireNonNull(loop, "loop");
        this.cache.cache(hostname, cname, Math.max(this.minTtl, (int)Math.min((long)this.maxTtl, originalTtl)), loop);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean clear(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        return this.cache.clear(hostname);
    }
}

