/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.dns.DnsRawRecord;
import io.netty5.handler.codec.dns.DnsRecord;
import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;

final class DnsAddressDecoder {
    private static final int INADDRSZ4 = 4;
    private static final int INADDRSZ6 = 16;

    static InetAddress decodeAddress(DnsRecord record, String name, boolean decodeIdn) {
        if (!(record instanceof DnsRawRecord)) {
            return null;
        }
        Buffer content = ((DnsRawRecord)record).content();
        int contentLen = content.readableBytes();
        if (contentLen != 4 && contentLen != 16) {
            return null;
        }
        byte[] addrBytes = new byte[contentLen];
        content.copyInto(content.readerOffset(), addrBytes, 0, addrBytes.length);
        try {
            return InetAddress.getByAddress(decodeIdn ? IDN.toUnicode(name) : name, addrBytes);
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    private DnsAddressDecoder() {
    }
}

