/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.logging.LogLevel;
import io.netty5.resolver.dns.DnsQueryLifecycleObserver;
import io.netty5.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty5.resolver.dns.LoggingDnsQueryLifecycleObserver;
import io.netty5.util.internal.logging.InternalLogLevel;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;

public final class LoggingDnsQueryLifeCycleObserverFactory
implements DnsQueryLifecycleObserverFactory {
    private static final InternalLogger DEFAULT_LOGGER = InternalLoggerFactory.getInstance(LoggingDnsQueryLifeCycleObserverFactory.class);
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public LoggingDnsQueryLifeCycleObserverFactory() {
        this(LogLevel.DEBUG);
    }

    public LoggingDnsQueryLifeCycleObserverFactory(LogLevel level) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level);
        this.logger = DEFAULT_LOGGER;
    }

    public LoggingDnsQueryLifeCycleObserverFactory(Class<?> classContext, LogLevel level) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level);
        this.logger = InternalLoggerFactory.getInstance(Objects.requireNonNull(classContext, "classContext"));
    }

    public LoggingDnsQueryLifeCycleObserverFactory(String name, LogLevel level) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level);
        this.logger = InternalLoggerFactory.getInstance((String)Objects.requireNonNull(name, "name"));
    }

    private static InternalLogLevel checkAndConvertLevel(LogLevel level) {
        return Objects.requireNonNull(level, "level").toInternalLevel();
    }

    @Override
    public DnsQueryLifecycleObserver newDnsQueryLifecycleObserver(DnsQuestion question) {
        return new LoggingDnsQueryLifecycleObserver(question, this.logger, this.level);
    }
}

