/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.codec.dns.DnsResponseCode;
import io.netty5.resolver.dns.DnsQueryLifecycleObserver;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.logging.InternalLogLevel;
import io.netty5.util.internal.logging.InternalLogger;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;

final class LoggingDnsQueryLifecycleObserver
implements DnsQueryLifecycleObserver {
    private final InternalLogger logger;
    private final InternalLogLevel level;
    private final DnsQuestion question;
    private InetSocketAddress dnsServerAddress;

    LoggingDnsQueryLifecycleObserver(DnsQuestion question, InternalLogger logger, InternalLogLevel level) {
        this.question = Objects.requireNonNull(question, "question");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.level = Objects.requireNonNull(level, "level");
    }

    @Override
    public void queryWritten(InetSocketAddress dnsServerAddress, Future<Void> future) {
        this.dnsServerAddress = dnsServerAddress;
    }

    @Override
    public void queryCancelled(int queriesRemaining) {
        if (this.dnsServerAddress != null) {
            this.logger.log(this.level, "from {} : {} cancelled with {} queries remaining", new Object[]{this.dnsServerAddress, this.question, queriesRemaining});
        } else {
            this.logger.log(this.level, "{} query never written and cancelled with {} queries remaining", (Object)this.question, (Object)queriesRemaining);
        }
    }

    @Override
    public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
        this.logger.log(this.level, "from {} : {} redirected", (Object)this.dnsServerAddress, (Object)this.question);
        return this;
    }

    @Override
    public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
        this.logger.log(this.level, "from {} : {} CNAME question {}", new Object[]{this.dnsServerAddress, this.question, cnameQuestion});
        return this;
    }

    @Override
    public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
        this.logger.log(this.level, "from {} : {} no answer {}", new Object[]{this.dnsServerAddress, this.question, code});
        return this;
    }

    @Override
    public void queryFailed(Throwable cause) {
        if (this.dnsServerAddress != null) {
            this.logger.log(this.level, "from {} : {} failure", new Object[]{this.dnsServerAddress, this.question, cause});
        } else {
            this.logger.log(this.level, "{} query never written and failed", (Object)this.question, (Object)cause);
        }
    }

    @Override
    public void querySucceed() {
    }
}

