/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.EventLoop;
import io.netty5.resolver.dns.AuthoritativeDnsServerCache;
import io.netty5.resolver.dns.Cache;
import io.netty5.resolver.dns.DnsServerAddressStream;
import io.netty5.resolver.dns.SequentialDnsServerAddressStream;
import io.netty5.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class DefaultAuthoritativeDnsServerCache
implements AuthoritativeDnsServerCache {
    private final int minTtl;
    private final int maxTtl;
    private final Comparator<InetSocketAddress> comparator;
    private final Cache<InetSocketAddress> resolveCache = new Cache<InetSocketAddress>(){

        @Override
        protected boolean shouldReplaceAll(InetSocketAddress entry) {
            return false;
        }

        @Override
        protected boolean equals(InetSocketAddress entry, InetSocketAddress otherEntry) {
            return entry.getHostString().equalsIgnoreCase(otherEntry.getHostString());
        }

        @Override
        protected void sortEntries(String hostname, List<InetSocketAddress> entries) {
            if (DefaultAuthoritativeDnsServerCache.this.comparator != null) {
                entries.sort(DefaultAuthoritativeDnsServerCache.this.comparator);
            }
        }
    };

    public DefaultAuthoritativeDnsServerCache() {
        this(0, Cache.MAX_SUPPORTED_TTL_SECS, null);
    }

    public DefaultAuthoritativeDnsServerCache(int minTtl, int maxTtl, Comparator<InetSocketAddress> comparator) {
        this.minTtl = Math.min(Cache.MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositiveOrZero((int)minTtl, (String)"minTtl"));
        this.maxTtl = Math.min(Cache.MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositive((int)maxTtl, (String)"maxTtl"));
        if (minTtl > maxTtl) {
            throw new IllegalArgumentException("minTtl: " + minTtl + ", maxTtl: " + maxTtl + " (expected: 0 <= minTtl <= maxTtl)");
        }
        this.comparator = comparator;
    }

    @Override
    public DnsServerAddressStream get(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        List<InetSocketAddress> addresses = this.resolveCache.get(hostname);
        if (addresses == null || addresses.isEmpty()) {
            return null;
        }
        return new SequentialDnsServerAddressStream(addresses, 0);
    }

    @Override
    public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
        Objects.requireNonNull(hostname, "hostname");
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(loop, "loop");
        if (address.getHostString() == null) {
            return;
        }
        this.resolveCache.cache(hostname, address, Math.max(this.minTtl, (int)Math.min((long)this.maxTtl, originalTtl)), loop);
    }

    @Override
    public void clear() {
        this.resolveCache.clear();
    }

    @Override
    public boolean clear(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        return this.resolveCache.clear(hostname);
    }

    public String toString() {
        return "DefaultAuthoritativeDnsServerCache(minTtl=" + this.minTtl + ", maxTtl=" + this.maxTtl + ", cached nameservers=" + this.resolveCache.size() + ")";
    }
}

