/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.buffer.Buffer;
import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.FixedReadHandleFactory;
import io.netty5.channel.socket.DatagramChannel;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.channel.socket.SocketChannel;
import io.netty5.handler.codec.CorruptedFrameException;
import io.netty5.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty5.handler.codec.dns.DatagramDnsResponse;
import io.netty5.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty5.handler.codec.dns.DefaultDnsRawRecord;
import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.codec.dns.DnsRawRecord;
import io.netty5.handler.codec.dns.DnsRecord;
import io.netty5.handler.codec.dns.DnsRecordType;
import io.netty5.handler.codec.dns.DnsResponse;
import io.netty5.handler.codec.dns.TcpDnsQueryEncoder;
import io.netty5.handler.codec.dns.TcpDnsResponseDecoder;
import io.netty5.resolver.DefaultHostsFileEntriesResolver;
import io.netty5.resolver.HostsFileEntriesResolver;
import io.netty5.resolver.InetNameResolver;
import io.netty5.resolver.ResolvedAddressTypes;
import io.netty5.resolver.dns.AuthoritativeDnsServerCache;
import io.netty5.resolver.dns.AuthoritativeDnsServerCacheAdapter;
import io.netty5.resolver.dns.DatagramDnsQueryContext;
import io.netty5.resolver.dns.DnsAddressResolveContext;
import io.netty5.resolver.dns.DnsCache;
import io.netty5.resolver.dns.DnsCacheEntry;
import io.netty5.resolver.dns.DnsCnameCache;
import io.netty5.resolver.dns.DnsNameResolverException;
import io.netty5.resolver.dns.DnsNameResolverTimeoutException;
import io.netty5.resolver.dns.DnsQueryContext;
import io.netty5.resolver.dns.DnsQueryContextManager;
import io.netty5.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty5.resolver.dns.DnsRecordResolveContext;
import io.netty5.resolver.dns.DnsServerAddressStream;
import io.netty5.resolver.dns.DnsServerAddressStreamProvider;
import io.netty5.resolver.dns.NameServerComparator;
import io.netty5.resolver.dns.NoopDnsCnameCache;
import io.netty5.resolver.dns.SequentialDnsServerAddressStream;
import io.netty5.resolver.dns.TcpDnsQueryContext;
import io.netty5.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import io.netty5.resolver.dns.UnixResolverOptions;
import io.netty5.util.NetUtil;
import io.netty5.util.ReferenceCounted;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DnsNameResolver
extends InetNameResolver {
    private static final InternalLogger logger;
    private static final String LOCALHOST = "localhost";
    private static final String WINDOWS_HOST_NAME;
    private static final InetAddress LOCALHOST_ADDRESS;
    private static final DnsRecord[] EMPTY_ADDITIONALS;
    private static final DnsRecordType[] IPV4_ONLY_RESOLVED_RECORD_TYPES;
    private static final ProtocolFamily[] IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final ProtocolFamily[] IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV6_ONLY_RESOLVED_RECORD_TYPES;
    private static final ProtocolFamily[] IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final ProtocolFamily[] IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    static final ResolvedAddressTypes DEFAULT_RESOLVE_ADDRESS_TYPES;
    static final String[] DEFAULT_SEARCH_DOMAINS;
    private static final UnixResolverOptions DEFAULT_OPTIONS;
    private static final DatagramDnsResponseDecoder DATAGRAM_DECODER;
    private static final DatagramDnsQueryEncoder DATAGRAM_ENCODER;
    private static final TcpDnsQueryEncoder TCP_ENCODER;
    final Promise<Channel> channelReadyPromise;
    final Channel ch;
    private final Comparator<InetSocketAddress> nameServerComparator;
    final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final AuthoritativeDnsServerCache authoritativeDnsServerCache;
    private final DnsCnameCache cnameCache;
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        protected DnsServerAddressStream initialValue() {
            return DnsNameResolver.this.dnsServerAddressStreamProvider.nameServerAddressStream("");
        }
    };
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final ResolvedAddressTypes resolvedAddressTypes;
    private final ProtocolFamily[] resolvedProtocolFamilies;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final boolean optResourceEnabled;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private final String[] searchDomains;
    private final int ndots;
    private final boolean supportsAAAARecords;
    private final boolean supportsARecords;
    private final ProtocolFamily preferredAddressType;
    private final DnsRecordType[] resolveRecordTypes;
    private final boolean decodeIdn;
    private final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory;
    private final boolean completeOncePreferredResolved;
    private final ChannelFactory<? extends SocketChannel> socketChannelFactory;

    private static boolean anyInterfaceSupportsIpV6() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    if (!(inetAddress instanceof Inet6Address) || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            logger.debug("Unable to detect if any interface supports IPv6, assuming IPv4-only", (Throwable)e);
        }
        return false;
    }

    @Deprecated
    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsCache resolveCache, DnsCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        this(eventLoop, channelFactory, resolveCache, new AuthoritativeDnsServerCacheAdapter(authoritativeDnsServerCache), dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, searchDomains, ndots, decodeIdn);
    }

    @Deprecated
    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsCache resolveCache, AuthoritativeDnsServerCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        this(eventLoop, channelFactory, null, resolveCache, NoopDnsCnameCache.INSTANCE, authoritativeDnsServerCache, dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, searchDomains, ndots, decodeIdn, false);
    }

    DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, ChannelFactory<? extends SocketChannel> socketChannelFactory, DnsCache resolveCache, DnsCnameCache cnameCache, AuthoritativeDnsServerCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn, boolean completeOncePreferredResolved) {
        this(eventLoop, channelFactory, socketChannelFactory, resolveCache, cnameCache, authoritativeDnsServerCache, null, dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, searchDomains, ndots, decodeIdn, completeOncePreferredResolved);
    }

    DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, ChannelFactory<? extends SocketChannel> socketChannelFactory, final DnsCache resolveCache, final DnsCnameCache cnameCache, final AuthoritativeDnsServerCache authoritativeDnsServerCache, SocketAddress localAddress, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn, boolean completeOncePreferredResolved) {
        super((EventExecutor)eventLoop);
        this.queryTimeoutMillis = queryTimeoutMillis > 0L ? queryTimeoutMillis : TimeUnit.SECONDS.toMillis(DEFAULT_OPTIONS.timeout());
        this.resolvedAddressTypes = resolvedAddressTypes != null ? resolvedAddressTypes : DEFAULT_RESOLVE_ADDRESS_TYPES;
        this.recursionDesired = recursionDesired;
        this.maxQueriesPerResolve = maxQueriesPerResolve > 0 ? maxQueriesPerResolve : DEFAULT_OPTIONS.attempts();
        this.maxPayloadSize = ObjectUtil.checkPositive((int)maxPayloadSize, (String)"maxPayloadSize");
        this.optResourceEnabled = optResourceEnabled;
        this.hostsFileEntriesResolver = Objects.requireNonNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        this.dnsServerAddressStreamProvider = Objects.requireNonNull(dnsServerAddressStreamProvider, "dnsServerAddressStreamProvider");
        this.resolveCache = Objects.requireNonNull(resolveCache, "resolveCache");
        this.cnameCache = Objects.requireNonNull(cnameCache, "cnameCache");
        this.dnsQueryLifecycleObserverFactory = Objects.requireNonNull(dnsQueryLifecycleObserverFactory, "dnsQueryLifecycleObserverFactory");
        this.searchDomains = searchDomains != null ? (String[])searchDomains.clone() : DEFAULT_SEARCH_DOMAINS;
        this.ndots = ndots >= 0 ? ndots : DEFAULT_OPTIONS.ndots();
        this.decodeIdn = decodeIdn;
        this.completeOncePreferredResolved = completeOncePreferredResolved;
        this.socketChannelFactory = socketChannelFactory;
        switch (this.resolvedAddressTypes) {
            case IPV4_ONLY: {
                this.supportsAAAARecords = false;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedProtocolFamilies = IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV4_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedProtocolFamilies = IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV6_ONLY: {
                this.supportsAAAARecords = true;
                this.supportsARecords = false;
                this.resolveRecordTypes = IPV6_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedProtocolFamilies = IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV6_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedProtocolFamilies = IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + resolvedAddressTypes);
            }
        }
        this.preferredAddressType = DnsNameResolver.preferredAddressType(this.resolvedAddressTypes);
        this.authoritativeDnsServerCache = Objects.requireNonNull(authoritativeDnsServerCache, "authoritativeDnsServerCache");
        Class addressType = NetUtil.addressType((ProtocolFamily)this.preferredAddressType);
        if (addressType == null) {
            throw new IllegalArgumentException(this.preferredAddressType + " not supported");
        }
        this.nameServerComparator = new NameServerComparator(addressType);
        Bootstrap b = new Bootstrap();
        b.group((EventLoopGroup)this.executor());
        b.channelFactory(channelFactory);
        this.channelReadyPromise = this.executor().newPromise();
        final DnsResponseHandler responseHandler = new DnsResponseHandler(this.channelReadyPromise);
        b.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{DATAGRAM_ENCODER, DATAGRAM_DECODER, responseHandler});
                ch.closeFuture().addListener(closeFuture -> {
                    resolveCache.clear();
                    cnameCache.clear();
                    authoritativeDnsServerCache.clear();
                });
            }
        });
        b.option(ChannelOption.READ_HANDLE_FACTORY, (Object)new FixedReadHandleFactory(maxPayloadSize));
        try {
            Future future;
            if (localAddress == null) {
                b.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
                this.ch = b.createUnregistered();
                future = this.ch.register();
            } else {
                this.ch = b.createUnregistered();
                future = this.ch.bind(localAddress);
            }
            if (future.isFailed()) {
                throw future.cause();
            }
            if (!future.isSuccess()) {
                future.addListener(f -> {
                    Throwable cause = f.cause();
                    if (cause != null) {
                        this.channelReadyPromise.tryFailure(cause);
                    }
                });
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new IllegalStateException("Unable to create / register Channel", cause);
        }
    }

    static ProtocolFamily preferredAddressType(ResolvedAddressTypes resolvedAddressTypes) {
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: 
            case IPV4_PREFERRED: {
                return StandardProtocolFamily.INET;
            }
            case IPV6_ONLY: 
            case IPV6_PREFERRED: {
                return StandardProtocolFamily.INET6;
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + resolvedAddressTypes);
    }

    InetSocketAddress newRedirectServerAddress(InetAddress server) {
        return new InetSocketAddress(server, 53);
    }

    final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory() {
        return this.dnsQueryLifecycleObserverFactory;
    }

    protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
        DnsServerAddressStream cached = this.authoritativeDnsServerCache().get(hostname);
        if (cached == null || cached.size() == 0) {
            nameservers.sort(this.nameServerComparator);
            return new SequentialDnsServerAddressStream(nameservers, 0);
        }
        return cached;
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    public DnsCnameCache cnameCache() {
        return this.cnameCache;
    }

    public AuthoritativeDnsServerCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public ResolvedAddressTypes resolvedAddressTypes() {
        return this.resolvedAddressTypes;
    }

    ProtocolFamily[] resolvedProtocolFamiliesUnsafe() {
        return this.resolvedProtocolFamilies;
    }

    final String[] searchDomains() {
        return this.searchDomains;
    }

    final int ndots() {
        return this.ndots;
    }

    final boolean supportsAAAARecords() {
        return this.supportsAAAARecords;
    }

    final boolean supportsARecords() {
        return this.supportsARecords;
    }

    final ProtocolFamily preferredAddressType() {
        return this.preferredAddressType;
    }

    final DnsRecordType[] resolveRecordTypes() {
        return this.resolveRecordTypes;
    }

    final boolean isDecodeIdn() {
        return this.decodeIdn;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    public void close() {
        if (this.ch.isOpen()) {
            this.ch.close();
        }
    }

    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    private InetAddress resolveHostsFileEntry(String hostname) {
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        InetAddress address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes);
        return address == null && DnsNameResolver.isLocalWindowsHost(hostname) ? LOCALHOST_ADDRESS : address;
    }

    private List<InetAddress> resolveHostsFileEntries(String hostname) {
        InetAddress address;
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        List<InetAddress> addresses = this.hostsFileEntriesResolver instanceof DefaultHostsFileEntriesResolver ? ((DefaultHostsFileEntriesResolver)this.hostsFileEntriesResolver).addresses(hostname, this.resolvedAddressTypes) : ((address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes)) != null ? Collections.singletonList(address) : null);
        return addresses == null && DnsNameResolver.isLocalWindowsHost(hostname) ? Collections.singletonList(LOCALHOST_ADDRESS) : addresses;
    }

    private static boolean isLocalWindowsHost(String hostname) {
        return PlatformDependent.isWindows() && (LOCALHOST.equalsIgnoreCase(hostname) || WINDOWS_HOST_NAME != null && WINDOWS_HOST_NAME.equalsIgnoreCase(hostname));
    }

    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolve(inetHost, additionals, (Promise<InetAddress>)this.executor().newPromise());
    }

    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals, Promise<InetAddress> promise) {
        Objects.requireNonNull(promise, "promise");
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolve(inetHost, additionalsArray, promise, this.resolveCache);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
        }
        return promise.asFuture();
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolveAll(inetHost, additionals, (Promise<List<InetAddress>>)this.executor().newPromise());
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals, Promise<List<InetAddress>> promise) {
        Objects.requireNonNull(promise, "promise");
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolveAll(inetHost, additionalsArray, promise, this.resolveCache);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
        }
        return promise.asFuture();
    }

    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        this.doResolve(inetHost, EMPTY_ADDITIONALS, promise, this.resolveCache);
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question) {
        return this.resolveAll(question, EMPTY_ADDITIONALS, (Promise<List<DnsRecord>>)this.executor().newPromise());
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.resolveAll(question, additionals, (Promise<List<DnsRecord>>)this.executor().newPromise());
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question, Iterable<DnsRecord> additionals, Promise<List<DnsRecord>> promise) {
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        return this.resolveAll(question, additionalsArray, promise);
    }

    private Future<List<DnsRecord>> resolveAll(DnsQuestion question, DnsRecord[] additionals, Promise<List<DnsRecord>> promise) {
        List<InetAddress> hostsFileEntries;
        Objects.requireNonNull(question, "question");
        Objects.requireNonNull(promise, "promise");
        DnsRecordType type = question.type();
        String hostname = question.name();
        if ((type == DnsRecordType.A || type == DnsRecordType.AAAA) && (hostsFileEntries = this.resolveHostsFileEntries(hostname)) != null) {
            ArrayList<DefaultDnsRawRecord> result = new ArrayList<DefaultDnsRawRecord>();
            for (InetAddress hostsFileEntry : hostsFileEntries) {
                Buffer content = null;
                if (hostsFileEntry instanceof Inet4Address) {
                    if (type == DnsRecordType.A) {
                        content = this.ch.bufferAllocator().copyOf(hostsFileEntry.getAddress());
                    }
                } else if (hostsFileEntry instanceof Inet6Address && type == DnsRecordType.AAAA) {
                    content = this.ch.bufferAllocator().copyOf(hostsFileEntry.getAddress());
                }
                if (content == null) continue;
                result.add(new DefaultDnsRawRecord(hostname, type, 86400L, content));
            }
            if (!result.isEmpty()) {
                DnsNameResolver.trySuccess(promise, result);
                return promise.asFuture();
            }
        }
        DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
        new DnsRecordResolveContext(this, promise, question, additionals, nameServerAddrs, this.maxQueriesPerResolve).resolve(promise);
        return promise.asFuture();
    }

    private static DnsRecord[] toArray(Iterable<DnsRecord> additionals, boolean validateType) {
        Objects.requireNonNull(additionals, "additionals");
        if (additionals instanceof Collection) {
            Collection records = (Collection)additionals;
            for (DnsRecord r : additionals) {
                DnsNameResolver.validateAdditional(r, validateType);
            }
            return records.toArray(new DnsRecord[0]);
        }
        Iterator<DnsRecord> additionalsIt = additionals.iterator();
        if (!additionalsIt.hasNext()) {
            return EMPTY_ADDITIONALS;
        }
        ArrayList<DnsRecord> records = new ArrayList<DnsRecord>();
        do {
            DnsRecord r = additionalsIt.next();
            DnsNameResolver.validateAdditional(r, validateType);
            records.add(r);
        } while (additionalsIt.hasNext());
        return records.toArray(new DnsRecord[0]);
    }

    private static void validateAdditional(DnsRecord record, boolean validateType) {
        Objects.requireNonNull(record, "record");
        if (validateType && record instanceof DnsRawRecord) {
            throw new IllegalArgumentException("DnsRawRecord implementations not allowed: " + record);
        }
    }

    private InetAddress loopbackAddress() {
        return NetUtil.localHost((ProtocolFamily)this.preferredAddressType());
    }

    protected void doResolve(String inetHost, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise.setSuccess((Object)this.loopbackAddress());
            return;
        }
        InetAddress address = NetUtil.createInetAddressFromIpAddressString((String)inetHost);
        if (address != null) {
            promise.setSuccess((Object)address);
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess((Object)hostsFileEntry);
            return;
        }
        if (!this.doResolveCached(hostname, additionals, promise, resolveCache)) {
            this.doResolveUncached(hostname, additionals, promise, resolveCache);
        }
    }

    private boolean doResolveCached(String hostname, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) {
        List<? extends DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        Throwable cause = cachedEntries.get(0).cause();
        if (cause == null) {
            int numEntries = cachedEntries.size();
            for (ProtocolFamily f : this.resolvedProtocolFamilies) {
                for (int i = 0; i < numEntries; ++i) {
                    DnsCacheEntry e = cachedEntries.get(i);
                    if (!NetUtil.isFamilySupported((InetAddress)e.address(), (ProtocolFamily)f)) continue;
                    DnsNameResolver.trySuccess(promise, e.address());
                    return true;
                }
            }
            return false;
        }
        DnsNameResolver.tryFailure(promise, cause);
        return true;
    }

    static <T> boolean trySuccess(Promise<T> promise, T result) {
        boolean notifiedRecords = promise.trySuccess(result);
        if (!notifiedRecords) {
            logger.trace("Failed to notify success ({}) to a promise: {}", result, promise);
        }
        return notifiedRecords;
    }

    private static void tryFailure(Promise<?> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            logger.trace("Failed to notify failure to a promise: {}", promise, (Object)cause);
        }
    }

    private void doResolveUncached(String hostname, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) {
        Promise allPromise = this.executor().newPromise();
        this.doResolveAllUncached(hostname, additionals, promise, (Promise<List<InetAddress>>)allPromise, resolveCache, true);
        allPromise.asFuture().addListener(future -> {
            if (future.isSuccess()) {
                DnsNameResolver.trySuccess(promise, (InetAddress)((List)future.getNow()).get(0));
            } else {
                DnsNameResolver.tryFailure(promise, future.cause());
            }
        });
    }

    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        this.doResolveAll(inetHost, EMPTY_ADDITIONALS, promise, this.resolveCache);
    }

    protected void doResolveAll(String inetHost, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise.setSuccess(Collections.singletonList(this.loopbackAddress()));
            return;
        }
        InetAddress address = NetUtil.createInetAddressFromIpAddressString((String)inetHost);
        if (address != null) {
            promise.setSuccess(Collections.singletonList(address));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        List<InetAddress> hostsFileEntries = this.resolveHostsFileEntries(hostname);
        if (hostsFileEntries != null) {
            promise.setSuccess(hostsFileEntries);
            return;
        }
        if (!DnsNameResolver.doResolveAllCached(hostname, additionals, promise, resolveCache, this.resolvedProtocolFamilies)) {
            this.doResolveAllUncached(hostname, additionals, promise, promise, resolveCache, this.completeOncePreferredResolved);
        }
    }

    static boolean doResolveAllCached(String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache, ProtocolFamily[] resolvedInternetProtocolFamilies) {
        List<? extends DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        Throwable cause = cachedEntries.get(0).cause();
        if (cause == null) {
            ArrayList<InetAddress> result = null;
            int numEntries = cachedEntries.size();
            for (ProtocolFamily f : resolvedInternetProtocolFamilies) {
                for (int i = 0; i < numEntries; ++i) {
                    DnsCacheEntry e = cachedEntries.get(i);
                    if (!NetUtil.isFamilySupported((InetAddress)e.address(), (ProtocolFamily)f)) continue;
                    if (result == null) {
                        result = new ArrayList<InetAddress>(numEntries);
                    }
                    result.add(e.address());
                }
            }
            if (result != null) {
                DnsNameResolver.trySuccess(promise, result);
                return true;
            }
            return false;
        }
        DnsNameResolver.tryFailure(promise, cause);
        return true;
    }

    private void doResolveAllUncached(String hostname, DnsRecord[] additionals, Promise<?> originalPromise, Promise<List<InetAddress>> promise, DnsCache resolveCache, boolean completeEarlyIfPossible) {
        EventLoop executor = this.executor();
        if (executor.inEventLoop()) {
            this.doResolveAllUncached0(hostname, additionals, originalPromise, promise, resolveCache, completeEarlyIfPossible);
        } else {
            executor.execute(() -> this.doResolveAllUncached0(hostname, additionals, originalPromise, promise, resolveCache, completeEarlyIfPossible));
        }
    }

    private void doResolveAllUncached0(String hostname, DnsRecord[] additionals, Promise<?> originalPromise, Promise<List<InetAddress>> promise, DnsCache resolveCache, boolean completeEarlyIfPossible) {
        assert (this.executor().inEventLoop());
        DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
        new DnsAddressResolveContext(this, originalPromise, hostname, additionals, nameServerAddrs, this.maxQueriesPerResolve, resolveCache, this.authoritativeDnsServerCache, completeEarlyIfPossible).resolve(promise);
    }

    private static String hostname(String inetHost) {
        Object hostname = IDN.toASCII(inetHost);
        if (StringUtil.endsWith((CharSequence)inetHost, (char)'.') && !StringUtil.endsWith((CharSequence)hostname, (char)'.')) {
            hostname = (String)hostname + ".";
        }
        return hostname;
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query(this.nextNameServerAddress(), question, additionals);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), question, Collections.emptyList(), promise);
    }

    private InetSocketAddress nextNameServerAddress() {
        return ((DnsServerAddressStream)this.nameServerAddrStream.get()).next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query0(nameServerAddr, question, EMPTY_ADDITIONALS, true, (Promise<Void>)this.ch.newPromise(), (Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>>)this.ch.executor().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query0(nameServerAddr, question, DnsNameResolver.toArray(additionals, false), true, (Promise<Void>)this.ch.newPromise(), (Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>>)this.ch.executor().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, EMPTY_ADDITIONALS, true, (Promise<Void>)this.ch.newPromise(), promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, DnsNameResolver.toArray(additionals, false), true, (Promise<Void>)this.ch.newPromise(), promise);
    }

    public static boolean isTransportOrTimeoutError(Throwable cause) {
        return cause != null && cause.getCause() instanceof DnsNameResolverException;
    }

    public static boolean isTimeoutError(Throwable cause) {
        return cause != null && cause.getCause() instanceof DnsNameResolverTimeoutException;
    }

    final void flushQueries() {
        this.ch.flush();
    }

    final Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, DnsRecord[] additionals, boolean flush, Promise<Void> writePromise, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(Objects.requireNonNull(promise, "promise"));
        try {
            new DatagramDnsQueryContext(this, nameServerAddr, question, additionals, castPromise).query(flush, writePromise);
        }
        catch (Exception e) {
            castPromise.setFailure((Throwable)e);
        }
        return castPromise.asFuture();
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    final DnsServerAddressStream newNameServerAddressStream(String hostname) {
        return this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
    }

    static {
        UnixResolverOptions options;
        String[] searchDomains;
        String hostName;
        logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
        EMPTY_ADDITIONALS = new DnsRecord[0];
        IPV4_ONLY_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.A};
        IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES = new ProtocolFamily[]{StandardProtocolFamily.INET};
        IPV4_PREFERRED_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.A, DnsRecordType.AAAA};
        IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new ProtocolFamily[]{StandardProtocolFamily.INET, StandardProtocolFamily.INET6};
        IPV6_ONLY_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.AAAA};
        IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES = new ProtocolFamily[]{StandardProtocolFamily.INET6};
        IPV6_PREFERRED_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.AAAA, DnsRecordType.A};
        IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new ProtocolFamily[]{StandardProtocolFamily.INET6, StandardProtocolFamily.INET};
        if (NetUtil.isIpV4StackPreferred() || !DnsNameResolver.anyInterfaceSupportsIpV6()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_ONLY;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        } else if (NetUtil.isIpV6AddressesPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV6_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST6;
        } else {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        }
        try {
            hostName = PlatformDependent.isWindows() ? InetAddress.getLocalHost().getHostName() : null;
        }
        catch (Exception ignore) {
            hostName = null;
        }
        WINDOWS_HOST_NAME = hostName;
        try {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
            if (!PlatformDependent.isWindows()) {
                List<String> list = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains();
                searchDomains = (String[])list.toArray(String[]::new);
            }
        }
        catch (Exception ignore) {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEARCH_DOMAINS = searchDomains;
        try {
            options = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions();
        }
        catch (Exception ignore) {
            options = UnixResolverOptions.newBuilder().build();
        }
        DEFAULT_OPTIONS = options;
        DATAGRAM_DECODER = new DatagramDnsResponseDecoder(){

            protected DnsResponse decodeResponse(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
                DnsResponse response = super.decodeResponse(ctx, packet);
                if (((Buffer)packet.content()).readableBytes() > 0) {
                    response.setTruncated(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} RECEIVED: UDP truncated packet received, consider adjusting maxPayloadSize for the {}.", (Object)ctx.channel(), (Object)StringUtil.simpleClassName(DnsNameResolver.class));
                    }
                }
                return response;
            }
        };
        DATAGRAM_ENCODER = new DatagramDnsQueryEncoder();
        TCP_ENCODER = new TcpDnsQueryEncoder();
    }

    private static final class AddressedEnvelopeAdapter
    implements AddressedEnvelope<DnsResponse, InetSocketAddress>,
    ReferenceCounted {
        private final InetSocketAddress sender;
        private final InetSocketAddress recipient;
        private final DnsResponse response;

        AddressedEnvelopeAdapter(InetSocketAddress sender, InetSocketAddress recipient, DnsResponse response) {
            this.sender = sender;
            this.recipient = recipient;
            this.response = response;
        }

        public DnsResponse content() {
            return this.response;
        }

        public InetSocketAddress sender() {
            return this.sender;
        }

        public InetSocketAddress recipient() {
            return this.recipient;
        }

        public AddressedEnvelopeAdapter retain() {
            this.response.retain();
            return this;
        }

        public AddressedEnvelopeAdapter retain(int increment) {
            this.response.retain(increment);
            return this;
        }

        public AddressedEnvelopeAdapter touch() {
            this.response.touch();
            return this;
        }

        public AddressedEnvelopeAdapter touch(Object hint) {
            this.response.touch(hint);
            return this;
        }

        public int refCnt() {
            return this.response.refCnt();
        }

        public boolean release() {
            return this.response.release();
        }

        public boolean release(int decrement) {
            return this.response.release(decrement);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AddressedEnvelope)) {
                return false;
            }
            AddressedEnvelope that = (AddressedEnvelope)obj;
            if (this.sender() == null ? that.sender() != null : !this.sender().equals(that.sender())) {
                return false;
            }
            if (this.recipient() == null ? that.recipient() != null : !this.recipient().equals(that.recipient())) {
                return false;
            }
            return this.response.equals(obj);
        }

        public int hashCode() {
            int hashCode = this.response.hashCode();
            if (this.sender() != null) {
                hashCode = hashCode * 31 + this.sender().hashCode();
            }
            if (this.recipient() != null) {
                hashCode = hashCode * 31 + this.recipient().hashCode();
            }
            return hashCode;
        }
    }

    private final class DnsResponseHandler
    implements ChannelHandler {
        private final Promise<Channel> channelActivePromise;

        DnsResponseHandler(Promise<Channel> channelActivePromise) {
            this.channelActivePromise = channelActivePromise;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            DnsQueryContext qCtx;
            final DatagramDnsResponse res = (DatagramDnsResponse)msg;
            final int queryId = res.id();
            if (logger.isDebugEnabled()) {
                logger.debug("{} RECEIVED: UDP [{}: {}], {}", new Object[]{DnsNameResolver.this.ch, queryId, res.sender(), res});
            }
            if ((qCtx = DnsNameResolver.this.queryContextManager.get(res.sender(), queryId)) == null) {
                logger.debug("Received a DNS response with an unknown ID: UDP [{}: {}]", (Object)DnsNameResolver.this.ch, (Object)queryId);
                res.release();
                return;
            }
            if (!res.isTruncated() || DnsNameResolver.this.socketChannelFactory == null) {
                qCtx.finish((AddressedEnvelope<? extends DnsResponse, InetSocketAddress>)res);
                return;
            }
            Bootstrap bs = new Bootstrap();
            ((Bootstrap)((Bootstrap)bs.option(ChannelOption.SO_REUSEADDR, (Object)true)).group((EventLoopGroup)DnsNameResolver.this.executor())).channelFactory(DnsNameResolver.this.socketChannelFactory).handler((ChannelHandler)TCP_ENCODER);
            bs.connect((SocketAddress)res.sender()).addListener(future -> {
                if (future.isFailed()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} Unable to fallback to TCP [{}]", (Object)queryId, (Object)future.cause());
                    }
                    qCtx.finish((AddressedEnvelope<? extends DnsResponse, InetSocketAddress>)res);
                    return;
                }
                Channel channel = (Channel)future.getNow();
                Promise promise = channel.executor().newPromise();
                final TcpDnsQueryContext tcpCtx = new TcpDnsQueryContext(DnsNameResolver.this, channel, (InetSocketAddress)channel.remoteAddress(), qCtx.question(), EMPTY_ADDITIONALS, (Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>>)promise);
                channel.pipeline().addLast(new ChannelHandler[]{new TcpDnsResponseDecoder()});
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void channelRead(ChannelHandlerContext ctx1, Object msg1) {
                        DnsQueryContext foundCtx;
                        Channel channel = ctx1.channel();
                        DnsResponse response = (DnsResponse)msg1;
                        int queryId1 = response.id();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} RECEIVED: TCP [{}: {}], {}", new Object[]{channel, queryId1, channel.remoteAddress(), response});
                        }
                        if ((foundCtx = DnsNameResolver.this.queryContextManager.get(res.sender(), queryId1)) == tcpCtx) {
                            tcpCtx.finish(new AddressedEnvelopeAdapter((InetSocketAddress)ctx1.channel().remoteAddress(), (InetSocketAddress)ctx1.channel().localAddress(), response));
                        } else {
                            response.release();
                            tcpCtx.tryFailure("Received TCP DNS response with unexpected ID", null, false);
                            logger.debug("Received a DNS response with an unexpected ID: TCP [{}: {}]", (Object)channel, (Object)queryId);
                        }
                    }

                    public void channelExceptionCaught(ChannelHandlerContext ctx1, Throwable cause) {
                        if (tcpCtx.tryFailure("TCP fallback error", cause, false) && logger.isDebugEnabled()) {
                            logger.debug("{} Error during processing response: TCP [{}: {}]", new Object[]{ctx1.channel(), queryId, ctx1.channel().remoteAddress(), cause});
                        }
                    }
                }});
                promise.asFuture().addListener(addressEnvelopeFuture -> {
                    channel.close();
                    if (addressEnvelopeFuture.isSuccess()) {
                        qCtx.finish((AddressedEnvelope<? extends DnsResponse, InetSocketAddress>)((AddressedEnvelope)addressEnvelopeFuture.getNow()));
                        res.release();
                    } else {
                        qCtx.finish((AddressedEnvelope<? extends DnsResponse, InetSocketAddress>)res);
                    }
                });
                tcpCtx.query(true, (Promise<Void>)channel.newPromise());
            });
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
            this.channelActivePromise.trySuccess((Object)ctx.channel());
        }

        public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof CorruptedFrameException) {
                logger.debug("Unable to decode DNS response: UDP [{}]", (Object)ctx.channel(), (Object)cause);
            } else {
                logger.warn("Unexpected exception: UDP [{}]", (Object)ctx.channel(), (Object)cause);
            }
        }
    }
}

