/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.handler.codec.dns.DnsQuestion;
import java.net.InetSocketAddress;
import java.util.Objects;

public class DnsNameResolverException
extends RuntimeException {
    private static final long serialVersionUID = -8826717909627131850L;
    private final InetSocketAddress remoteAddress;
    private final DnsQuestion question;

    public DnsNameResolverException(InetSocketAddress remoteAddress, DnsQuestion question, String message) {
        super(message, null, true, false);
        this.remoteAddress = DnsNameResolverException.validateRemoteAddress(remoteAddress);
        this.question = DnsNameResolverException.validateQuestion(question);
    }

    public DnsNameResolverException(InetSocketAddress remoteAddress, DnsQuestion question, String message, Throwable cause) {
        super(message, cause, true, false);
        this.remoteAddress = DnsNameResolverException.validateRemoteAddress(remoteAddress);
        this.question = DnsNameResolverException.validateQuestion(question);
    }

    private static InetSocketAddress validateRemoteAddress(InetSocketAddress remoteAddress) {
        return Objects.requireNonNull(remoteAddress, "remoteAddress");
    }

    private static DnsQuestion validateQuestion(DnsQuestion question) {
        return Objects.requireNonNull(question, "question");
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public DnsQuestion question() {
        return this.question;
    }
}

