/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.socket.SocketProtocolFamily;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ProtocolFamily;
import java.util.Comparator;

final class PreferredAddressTypeComparator
implements Comparator<InetAddress> {
    private static final PreferredAddressTypeComparator IPv4 = new PreferredAddressTypeComparator(Inet4Address.class);
    private static final PreferredAddressTypeComparator IPv6 = new PreferredAddressTypeComparator(Inet6Address.class);
    private final Class<? extends InetAddress> preferredAddressType;

    static PreferredAddressTypeComparator comparator(ProtocolFamily family) {
        SocketProtocolFamily protocolFamily = SocketProtocolFamily.of((ProtocolFamily)family);
        switch (protocolFamily) {
            case INET6: {
                return IPv6;
            }
            case INET: {
                return IPv4;
            }
        }
        throw new IllegalArgumentException("ProtocolFamily not supported: " + family);
    }

    private PreferredAddressTypeComparator(Class<? extends InetAddress> preferredAddressType) {
        this.preferredAddressType = preferredAddressType;
    }

    @Override
    public int compare(InetAddress o1, InetAddress o2) {
        if (o1.getClass() == o2.getClass()) {
            return 0;
        }
        return this.preferredAddressType.isAssignableFrom(o1.getClass()) ? -1 : 1;
    }
}

