/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver;

import io.netty5.resolver.NameResolver;
import io.netty5.resolver.SimpleNameResolver;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Promise;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    public CompositeNameResolver(EventExecutor executor, NameResolver<T> ... resolvers) {
        super(executor);
        Objects.requireNonNull(resolvers, "resolvers");
        for (int i = 0; i < resolvers.length; ++i) {
            Objects.requireNonNull(resolvers[i], "resolvers[" + i + "]");
        }
        if (resolvers.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(resolvers) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])resolvers.clone();
    }

    @Override
    protected void doResolve(String inetHost, Promise<T> promise) throws Exception {
        this.doResolveRec(inetHost, promise, 0, null);
    }

    private void doResolveRec(String inetHost, Promise<T> promise, int resolverIndex, Throwable lastFailure) throws Exception {
        if (resolverIndex >= this.resolvers.length) {
            promise.setFailure(lastFailure);
        } else {
            NameResolver<T> resolver = this.resolvers[resolverIndex];
            resolver.resolve(inetHost).addListener(future -> {
                if (future.isSuccess()) {
                    promise.setSuccess(future.getNow());
                } else {
                    this.doResolveRec(inetHost, promise, resolverIndex + 1, future.cause());
                }
            });
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<T>> promise) throws Exception {
        this.doResolveAllRec(inetHost, promise, 0, null);
    }

    private void doResolveAllRec(String inetHost, Promise<List<T>> promise, int resolverIndex, Throwable lastFailure) throws Exception {
        if (resolverIndex >= this.resolvers.length) {
            promise.setFailure(lastFailure);
        } else {
            NameResolver<T> resolver = this.resolvers[resolverIndex];
            resolver.resolveAll(inetHost).addListener(future -> {
                if (future.isSuccess()) {
                    promise.setSuccess((Object)((List)future.getNow()));
                } else {
                    this.doResolveAllRec(inetHost, promise, resolverIndex + 1, future.cause());
                }
            });
        }
    }
}

