/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver;

import io.netty5.resolver.AbstractAddressResolver;
import io.netty5.resolver.NameResolver;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class InetSocketAddressResolver
extends AbstractAddressResolver<InetSocketAddress> {
    final NameResolver<InetAddress> nameResolver;

    public InetSocketAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super(executor, InetSocketAddress.class);
        this.nameResolver = nameResolver;
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    @Override
    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        this.nameResolver.resolve(unresolvedAddress.getHostName()).addListener(future -> {
            if (future.isSuccess()) {
                promise.setSuccess((Object)new InetSocketAddress((InetAddress)future.getNow(), unresolvedAddress.getPort()));
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    @Override
    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
        this.nameResolver.resolveAll(unresolvedAddress.getHostName()).addListener(future -> {
            if (future.isSuccess()) {
                List inetAddresses = (List)future.getNow();
                ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(inetAddresses.size());
                for (InetAddress inetAddress : inetAddresses) {
                    socketAddresses.add(new InetSocketAddress(inetAddress, unresolvedAddress.getPort()));
                }
                promise.setSuccess(socketAddresses);
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

