/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver;

import io.netty5.resolver.InetNameResolver;
import io.netty5.resolver.NameResolver;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    public RoundRobinInetAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super(executor);
        this.nameResolver = nameResolver;
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        this.nameResolver.resolveAll(inetHost).addListener(future -> {
            if (future.isSuccess()) {
                List inetAddresses = (List)future.getNow();
                int numAddresses = inetAddresses.size();
                if (numAddresses > 0) {
                    promise.setSuccess((Object)((InetAddress)inetAddresses.get(RoundRobinInetAddressResolver.randomIndex(numAddresses))));
                } else {
                    promise.setFailure((Throwable)new UnknownHostException(inetHost));
                }
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        this.nameResolver.resolveAll(inetHost).addListener(future -> {
            if (future.isSuccess()) {
                List inetAddresses = (List)future.getNow();
                if (!inetAddresses.isEmpty()) {
                    ArrayList result = new ArrayList(inetAddresses);
                    Collections.rotate(result, RoundRobinInetAddressResolver.randomIndex(inetAddresses.size()));
                    promise.setSuccess(result);
                } else {
                    promise.setSuccess((Object)inetAddresses);
                }
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    private static int randomIndex(int numAddresses) {
        return numAddresses == 1 ? 0 : ThreadLocalRandom.current().nextInt(numAddresses);
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

