/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver;

import io.netty5.resolver.AddressResolver;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AddressResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AddressResolverGroup.class);
    private final Map<EventExecutor, AddressResolver<T>> resolvers = new IdentityHashMap<EventExecutor, AddressResolver<T>>();
    private final Map<EventExecutor, FutureListener<Object>> executorTerminationListeners = new IdentityHashMap<EventExecutor, FutureListener<Object>>();

    protected AddressResolverGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressResolver<T> getResolver(EventExecutor executor) {
        AddressResolver<T> r;
        Objects.requireNonNull(executor, "executor");
        if (executor.isShuttingDown()) {
            throw new IllegalStateException("executor not accepting a task");
        }
        Map<EventExecutor, AddressResolver<T>> map = this.resolvers;
        synchronized (map) {
            r = this.resolvers.get(executor);
            if (r == null) {
                AddressResolver<T> newResolver;
                try {
                    newResolver = this.newResolver(executor);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to create a new resolver", e);
                }
                this.resolvers.put(executor, newResolver);
                FutureListener terminationListener = future -> {
                    Map<EventExecutor, AddressResolver<T>> map = this.resolvers;
                    synchronized (map) {
                        this.resolvers.remove(executor);
                        this.executorTerminationListeners.remove(executor);
                    }
                    newResolver.close();
                };
                this.executorTerminationListeners.put(executor, (FutureListener<Object>)terminationListener);
                executor.terminationFuture().addListener(terminationListener);
                r = newResolver;
            }
        }
        return r;
    }

    protected abstract AddressResolver<T> newResolver(EventExecutor var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AddressResolver[] addressResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            AddressResolver[] rArray = this.resolvers.values().toArray(new AddressResolver[0]);
            this.resolvers.clear();
            this.executorTerminationListeners.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (AddressResolver r : rArray) {
                try {
                    r.close();
                }
                catch (Throwable t) {
                    logger.warn("Failed to close a resolver:", t);
                }
            }
            return;
        }
    }
}

