/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.DefaultBufferAllocators;
import io.netty5.buffer.api.ReadableComponentProcessor;
import io.netty5.buffer.api.Resource;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.ConnectTimeoutException;
import io.netty5.channel.EventLoop;
import io.netty5.channel.RecvBufferAllocator;
import io.netty5.channel.epoll.EpollChannelConfig;
import io.netty5.channel.epoll.EpollDomainSocketChannelConfig;
import io.netty5.channel.epoll.EpollRecvBufferAllocatorHandle;
import io.netty5.channel.epoll.EpollRegistration;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.socket.ChannelInputShutdownEvent;
import io.netty5.channel.socket.ChannelInputShutdownReadComplete;
import io.netty5.channel.socket.SocketChannelConfig;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.Socket;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    final LinuxSocket socket;
    private Promise<Void> connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    protected EpollRegistration registration;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;
    protected int flags = Native.EPOLLET;
    boolean inputClosedSeenErrorOnRead;
    boolean epollInReadyRunnablePending;
    protected volatile boolean active;

    AbstractEpollChannel(EventLoop eventLoop, LinuxSocket fd) {
        this(null, eventLoop, fd, false);
    }

    AbstractEpollChannel(Channel parent, EventLoop eventLoop, LinuxSocket fd, boolean active) {
        super(parent, eventLoop);
        this.socket = Objects.requireNonNull(fd, "fd");
        this.active = active;
        if (active) {
            this.local = fd.localAddress();
            this.remote = fd.remoteAddress();
        }
    }

    AbstractEpollChannel(Channel parent, EventLoop eventLoop, LinuxSocket fd, SocketAddress remote) {
        super(parent, eventLoop);
        this.socket = Objects.requireNonNull(fd, "fd");
        this.active = true;
        this.remote = remote;
        this.local = fd.localAddress();
    }

    static boolean isSoErrorZero(Socket fd) {
        try {
            return fd.getSoError() == 0;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    void setFlag(int flag) throws IOException {
        if (!this.isFlagSet(flag)) {
            this.flags |= flag;
            this.modifyEvents();
        }
    }

    void clearFlag(int flag) throws IOException {
        if (this.isFlagSet(flag)) {
            this.flags &= ~flag;
            this.modifyEvents();
        }
    }

    EpollRegistration registration() {
        assert (this.registration != null);
        return this.registration;
    }

    boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public abstract EpollChannelConfig config();

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws Exception {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        try {
            Future<?> future;
            Promise<Void> promise = this.connectPromise;
            if (promise != null) {
                promise.tryFailure((Throwable)new ClosedChannelException());
                this.connectPromise = null;
            }
            if ((future = this.connectTimeoutFuture) != null) {
                future.cancel();
                this.connectTimeoutFuture = null;
            }
            if (this.isRegistered()) {
                EventLoop loop = this.executor();
                if (loop.inEventLoop()) {
                    this.doDeregister();
                } else {
                    loop.execute(() -> {
                        try {
                            this.doDeregister();
                        }
                        catch (Throwable cause) {
                            this.pipeline().fireExceptionCaught(cause);
                        }
                    });
                }
            }
        }
        finally {
            this.socket.close();
        }
    }

    void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    public boolean isOpen() {
        return this.socket.isOpen();
    }

    void register0(EpollRegistration registration) throws Exception {
        this.epollInReadyRunnablePending = false;
        this.registration = registration;
    }

    void deregister0() throws Exception {
        if (this.registration != null) {
            this.registration.remove();
        }
    }

    protected final void doBeginRead() throws Exception {
        AbstractEpollUnsafe unsafe = (AbstractEpollUnsafe)this.unsafe();
        unsafe.readPending = true;
        this.setFlag(Native.EPOLLIN);
        if (unsafe.maybeMoreDataToRead) {
            unsafe.executeEpollInReadyRunnable((ChannelConfig)this.config());
        }
    }

    final boolean shouldBreakEpollInReady(ChannelConfig config) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractEpollChannel.isAllowHalfClosure(config));
    }

    private static boolean isAllowHalfClosure(ChannelConfig config) {
        if (config instanceof EpollDomainSocketChannelConfig) {
            return ((EpollDomainSocketChannelConfig)config).isAllowHalfClosure();
        }
        return config instanceof SocketChannelConfig && ((SocketChannelConfig)config).isAllowHalfClosure();
    }

    final void clearEpollIn() {
        if (this.isRegistered()) {
            EventLoop loop = this.executor();
            AbstractEpollUnsafe unsafe = (AbstractEpollUnsafe)this.unsafe();
            if (loop.inEventLoop()) {
                unsafe.clearEpollIn0();
            } else {
                loop.execute(() -> {
                    if (!unsafe.readPending && !this.config().isAutoRead()) {
                        unsafe.clearEpollIn0();
                    }
                });
            }
        } else {
            this.flags &= ~Native.EPOLLIN;
        }
    }

    private void modifyEvents() throws IOException {
        if (this.isOpen() && this.isRegistered() && this.registration != null) {
            this.registration.update();
        }
    }

    protected abstract AbstractEpollUnsafe newUnsafe();

    protected final Buffer newDirectBuffer(Buffer buf) {
        return this.newDirectBuffer((Resource<?>)buf, buf);
    }

    protected final Buffer newDirectBuffer(Resource<?> holder, Buffer buf) {
        BufferAllocator allocator = this.bufferAllocator();
        if (!allocator.getAllocationType().isDirect()) {
            allocator = DefaultBufferAllocators.offHeapAllocator();
        }
        try (Resource<?> resource = holder;){
            int readableBytes = buf.readableBytes();
            Buffer directCopy = allocator.allocate(readableBytes);
            if (readableBytes > 0) {
                directCopy.writeBytes(buf);
            }
            Buffer buffer = directCopy;
            return buffer;
        }
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final void doReadBytes(Buffer buffer) throws Exception {
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(buffer.writableBytes());
        buffer.forEachWritable(0, (index, component) -> {
            long address = component.writableNativeAddress();
            assert (address != 0L);
            int localReadAmount = this.socket.readAddress(address, 0, component.writableBytes());
            this.unsafe().recvBufAllocHandle().lastBytesRead(localReadAmount);
            if (localReadAmount > 0) {
                component.skipWritable(localReadAmount);
            }
            return false;
        });
    }

    protected final int doWriteBytes(ChannelOutboundBuffer in, Buffer buf) throws Exception {
        int initialReaderOffset = buf.readerOffset();
        buf.forEachReadable(0, (index, component) -> {
            long address = component.readableNativeAddress();
            assert (address != 0L);
            int written = this.socket.writeAddress(address, 0, component.readableBytes());
            if (written > 0) {
                component.skipReadable(written);
            }
            return false;
        });
        int readerOffset = buf.readerOffset();
        if (initialReaderOffset < readerOffset) {
            buf.readerOffset(initialReaderOffset);
            int bytesWritten = readerOffset - initialReaderOffset;
            in.removeBytes((long)bytesWritten);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    final long doWriteOrSendBytes(Buffer data, InetSocketAddress remoteAddress, boolean fastOpen) throws IOException {
        assert (!fastOpen || remoteAddress != null) : "fastOpen requires a remote address";
        IovArray array = this.registration().cleanIovArray();
        data.forEachReadable(0, (ReadableComponentProcessor)array);
        int count = array.count();
        assert (count != 0);
        if (remoteAddress == null) {
            return this.socket.writevAddresses(array.memoryAddress(0), count);
        }
        return this.socket.sendToAddresses(array.memoryAddress(0), count, remoteAddress.getAddress(), remoteAddress.getPort(), fastOpen);
    }

    protected void doBind(SocketAddress local) throws Exception {
        if (local instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind(local);
        this.local = this.socket.localAddress();
    }

    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        boolean connected;
        InetSocketAddress remoteSocketAddr;
        if (localAddress instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)localAddress);
        }
        InetSocketAddress inetSocketAddress = remoteSocketAddr = remoteAddress instanceof InetSocketAddress ? (InetSocketAddress)remoteAddress : null;
        if (remoteSocketAddr != null) {
            AbstractEpollChannel.checkResolvable(remoteSocketAddr);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (localAddress != null) {
            this.socket.bind(localAddress);
        }
        if (connected = this.doConnect0(remoteAddress)) {
            this.remote = remoteSocketAddr == null ? remoteAddress : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)remoteSocketAddr, (InetSocketAddress)this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doConnect0(SocketAddress remote) throws Exception {
        boolean success = false;
        try {
            boolean connected = this.socket.connect(remote);
            if (!connected) {
                this.setFlag(Native.EPOLLOUT);
            }
            success = true;
            boolean bl = connected;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    protected SocketAddress localAddress0() {
        return this.local;
    }

    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    protected abstract class AbstractEpollUnsafe
    extends AbstractChannel.AbstractUnsafe {
        boolean readPending;
        boolean maybeMoreDataToRead;
        private EpollRecvBufferAllocatorHandle allocHandle;
        private final Runnable epollInReadyRunnable;

        protected AbstractEpollUnsafe() {
            super((AbstractChannel)AbstractEpollChannel.this);
            this.epollInReadyRunnable = new Runnable(){

                @Override
                public void run() {
                    AbstractEpollChannel.this.epollInReadyRunnablePending = false;
                    AbstractEpollUnsafe.this.epollInReady();
                }
            };
        }

        abstract void epollInReady();

        final void epollInBefore() {
            this.maybeMoreDataToRead = false;
        }

        final void epollInFinally(ChannelConfig config) {
            this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
            if (this.allocHandle.isReceivedRdHup() || this.readPending && this.maybeMoreDataToRead) {
                this.executeEpollInReadyRunnable(config);
            } else if (!this.readPending && !config.isAutoRead()) {
                AbstractEpollChannel.this.clearEpollIn();
            }
        }

        final void executeEpollInReadyRunnable(ChannelConfig config) {
            if (AbstractEpollChannel.this.epollInReadyRunnablePending || !AbstractEpollChannel.this.isActive() || AbstractEpollChannel.this.shouldBreakEpollInReady(config)) {
                return;
            }
            AbstractEpollChannel.this.epollInReadyRunnablePending = true;
            AbstractEpollChannel.this.executor().execute(this.epollInReadyRunnable);
        }

        final void epollRdHupReady() {
            this.recvBufAllocHandle().receivedRdHup();
            if (AbstractEpollChannel.this.isActive()) {
                this.epollInReady();
            } else {
                this.shutdownInput(true);
            }
            this.clearEpollRdHup();
        }

        private void clearEpollRdHup() {
            try {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLRDHUP);
            }
            catch (IOException e) {
                AbstractEpollChannel.this.pipeline().fireExceptionCaught((Throwable)e);
                this.close(AbstractEpollChannel.this.newPromise());
            }
        }

        void shutdownInput(boolean rdHup) {
            if (!AbstractEpollChannel.this.socket.isInputShutdown()) {
                if (AbstractEpollChannel.isAllowHalfClosure((ChannelConfig)AbstractEpollChannel.this.config())) {
                    try {
                        AbstractEpollChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException ignored) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {
                        // empty catch block
                    }
                    AbstractEpollChannel.this.clearEpollIn();
                    AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.close(AbstractEpollChannel.this.newPromise());
                }
            } else if (!rdHup) {
                AbstractEpollChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        private void fireEventAndClose(Object evt) {
            AbstractEpollChannel.this.pipeline().fireUserEventTriggered(evt);
            this.close(AbstractEpollChannel.this.newPromise());
        }

        public EpollRecvBufferAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = this.newEpollHandle(super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        EpollRecvBufferAllocatorHandle newEpollHandle(RecvBufferAllocator.Handle handle) {
            return new EpollRecvBufferAllocatorHandle(handle);
        }

        protected final void flush0() {
            if (!AbstractEpollChannel.this.isFlagSet(Native.EPOLLOUT)) {
                super.flush0();
            }
        }

        final void epollOutReady() {
            if (AbstractEpollChannel.this.connectPromise != null) {
                this.finishConnect();
            } else if (!AbstractEpollChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        protected final void clearEpollIn0() {
            assert (AbstractEpollChannel.this.executor().inEventLoop());
            try {
                this.readPending = false;
                AbstractEpollChannel.this.clearFlag(Native.EPOLLIN);
            }
            catch (IOException e) {
                AbstractEpollChannel.this.pipeline().fireExceptionCaught((Throwable)e);
                AbstractEpollChannel.this.unsafe().close(AbstractEpollChannel.this.newPromise());
            }
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                if (AbstractEpollChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean wasActive = AbstractEpollChannel.this.isActive();
                if (AbstractEpollChannel.this.doConnect(remoteAddress, localAddress)) {
                    this.fulfillConnectPromise(promise, wasActive);
                } else {
                    AbstractEpollChannel.this.connectPromise = promise;
                    AbstractEpollChannel.this.requestedRemoteAddress = remoteAddress;
                    int connectTimeoutMillis = AbstractEpollChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        AbstractEpollChannel.this.connectTimeoutFuture = AbstractEpollChannel.this.executor().schedule(() -> {
                            Promise<Void> connectPromise = AbstractEpollChannel.this.connectPromise;
                            if (connectPromise != null && !connectPromise.isDone() && connectPromise.tryFailure((Throwable)new ConnectTimeoutException("connection timed out: " + remoteAddress))) {
                                this.close(AbstractEpollChannel.this.newPromise());
                            }
                        }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    promise.asFuture().addListener(future -> {
                        if (future.isCancelled()) {
                            if (AbstractEpollChannel.this.connectTimeoutFuture != null) {
                                AbstractEpollChannel.this.connectTimeoutFuture.cancel();
                            }
                            AbstractEpollChannel.this.connectPromise = null;
                            this.close(AbstractEpollChannel.this.newPromise());
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.closeIfClosed();
                promise.tryFailure(this.annotateConnectException(t, remoteAddress));
            }
        }

        private void fulfillConnectPromise(Promise<Void> promise, boolean wasActive) {
            if (promise == null) {
                return;
            }
            AbstractEpollChannel.this.active = true;
            boolean active = AbstractEpollChannel.this.isActive();
            boolean promiseSet = promise.trySuccess(null);
            if (!wasActive && active) {
                AbstractEpollChannel.this.pipeline().fireChannelActive();
                AbstractEpollChannel.this.readIfIsAutoRead();
            }
            if (!promiseSet) {
                this.close(AbstractEpollChannel.this.newPromise());
            }
        }

        private void fulfillConnectPromise(Promise<Void> promise, Throwable cause) {
            if (promise == null) {
                return;
            }
            promise.tryFailure(cause);
            this.closeIfClosed();
        }

        private void finishConnect() {
            assert (AbstractEpollChannel.this.executor().inEventLoop());
            boolean connectStillInProgress = false;
            try {
                boolean wasActive = AbstractEpollChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    connectStillInProgress = true;
                    return;
                }
                this.fulfillConnectPromise(AbstractEpollChannel.this.connectPromise, wasActive);
            }
            catch (Throwable t) {
                this.fulfillConnectPromise(AbstractEpollChannel.this.connectPromise, this.annotateConnectException(t, AbstractEpollChannel.this.requestedRemoteAddress));
            }
            finally {
                if (!connectStillInProgress) {
                    if (AbstractEpollChannel.this.connectTimeoutFuture != null) {
                        AbstractEpollChannel.this.connectTimeoutFuture.cancel();
                    }
                    AbstractEpollChannel.this.connectPromise = null;
                }
            }
        }

        private boolean doFinishConnect() throws Exception {
            if (AbstractEpollChannel.this.socket.finishConnect()) {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLOUT);
                if (AbstractEpollChannel.this.requestedRemoteAddress instanceof InetSocketAddress) {
                    AbstractEpollChannel.this.remote = UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)AbstractEpollChannel.this.requestedRemoteAddress), (InetSocketAddress)AbstractEpollChannel.this.socket.remoteAddress());
                }
                AbstractEpollChannel.this.requestedRemoteAddress = null;
                return true;
            }
            AbstractEpollChannel.this.setFlag(Native.EPOLLOUT);
            return false;
        }
    }
}

