/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.Resource;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.DefaultFileRegion;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FileRegion;
import io.netty5.channel.RecvBufferAllocator;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.EpollDuplexChannelConfig;
import io.netty5.channel.epoll.EpollRecvBufferAllocatorHandle;
import io.netty5.channel.epoll.EpollRecvBufferAllocatorStreamingHandle;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.socket.DuplexChannel;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.SocketWritableByteChannel;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;

public abstract class AbstractEpollStreamChannel
extends AbstractEpollChannel
implements DuplexChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ")";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEpollStreamChannel.class);
    private final Runnable flushTask = () -> ((AbstractEpollChannel.AbstractEpollUnsafe)this.unsafe()).flush0();
    private WritableByteChannel byteChannel;

    protected AbstractEpollStreamChannel(Channel parent, EventLoop eventLoop, int fd) {
        this(parent, eventLoop, new LinuxSocket(fd));
    }

    protected AbstractEpollStreamChannel(EventLoop eventLoop, int fd) {
        this(eventLoop, new LinuxSocket(fd));
    }

    AbstractEpollStreamChannel(EventLoop eventLoop, LinuxSocket fd) {
        this(eventLoop, fd, AbstractEpollStreamChannel.isSoErrorZero(fd));
    }

    AbstractEpollStreamChannel(Channel parent, EventLoop eventLoop, LinuxSocket fd) {
        super(parent, eventLoop, fd, true);
        this.flags |= Native.EPOLLRDHUP;
    }

    AbstractEpollStreamChannel(Channel parent, EventLoop eventLoop, LinuxSocket fd, SocketAddress remote) {
        super(parent, eventLoop, fd, remote);
        this.flags |= Native.EPOLLRDHUP;
    }

    protected AbstractEpollStreamChannel(EventLoop eventLoop, LinuxSocket fd, boolean active) {
        super(null, eventLoop, fd, active);
        this.flags |= Native.EPOLLRDHUP;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollStreamUnsafe();
    }

    @Override
    public abstract EpollDuplexChannelConfig config();

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    private int writeBytes(ChannelOutboundBuffer in, Buffer buf) throws Exception {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            in.remove();
            return 0;
        }
        int readableComponents = buf.countReadableComponents();
        if (readableComponents == 1) {
            return this.doWriteBytes(in, buf);
        }
        ByteBuffer[] nioBuffers = new ByteBuffer[readableComponents];
        buf.forEachReadable(0, (index, component) -> {
            nioBuffers[index] = component.readableBuffer();
            return true;
        });
        return this.writeBytesMultiple(in, nioBuffers, nioBuffers.length, readableBytes, this.config().getMaxBytesPerGatheringWrite());
    }

    private void adjustMaxBytesPerGatheringWrite(long attempted, long written, long oldMaxBytesPerGatheringWrite) {
        if (attempted == written) {
            if (attempted << 1 > oldMaxBytesPerGatheringWrite) {
                this.config().setMaxBytesPerGatheringWrite(attempted << 1);
            }
        } else if (attempted > 4096L && written < attempted >>> 1) {
            this.config().setMaxBytesPerGatheringWrite(attempted >>> 1);
        }
    }

    private int writeBytesMultiple(ChannelOutboundBuffer in, IovArray array) throws IOException {
        long expectedWrittenBytes = array.size();
        assert (expectedWrittenBytes != 0L);
        int cnt = array.count();
        assert (cnt != 0);
        long localWrittenBytes = this.socket.writevAddresses(array.memoryAddress(0), cnt);
        if (localWrittenBytes > 0L) {
            this.adjustMaxBytesPerGatheringWrite(expectedWrittenBytes, localWrittenBytes, array.maxBytes());
            in.removeBytes(localWrittenBytes);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeBytesMultiple(ChannelOutboundBuffer in, ByteBuffer[] nioBuffers, int nioBufferCnt, long expectedWrittenBytes, long maxBytesPerGatheringWrite) throws IOException {
        long localWrittenBytes;
        assert (expectedWrittenBytes != 0L);
        if (expectedWrittenBytes > maxBytesPerGatheringWrite) {
            expectedWrittenBytes = maxBytesPerGatheringWrite;
        }
        if ((localWrittenBytes = this.socket.writev(nioBuffers, 0, nioBufferCnt, expectedWrittenBytes)) > 0L) {
            this.adjustMaxBytesPerGatheringWrite(expectedWrittenBytes, localWrittenBytes, maxBytesPerGatheringWrite);
            in.removeBytes(localWrittenBytes);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeDefaultFileRegion(ChannelOutboundBuffer in, DefaultFileRegion region) throws Exception {
        long regionCount;
        long offset = region.transferred();
        if (offset >= (regionCount = region.count())) {
            in.remove();
            return 0;
        }
        long flushedAmount = this.socket.sendFile(region, region.position(), offset, regionCount - offset);
        if (flushedAmount > 0L) {
            in.progress(flushedAmount);
            if (region.transferred() >= regionCount) {
                in.remove();
            }
            return 1;
        }
        if (flushedAmount == 0L) {
            this.validateFileRegion(region, offset);
        }
        return Integer.MAX_VALUE;
    }

    private int writeFileRegion(ChannelOutboundBuffer in, FileRegion region) throws Exception {
        long flushedAmount;
        if (region.transferred() >= region.count()) {
            in.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new EpollSocketWritableByteChannel();
        }
        if ((flushedAmount = region.transferTo(this.byteChannel, region.transferred())) > 0L) {
            in.progress(flushedAmount);
            if (region.transferred() >= region.count()) {
                in.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            int msgCount;
            if ((msgCount = in.size()) > 1 && in.current() instanceof Buffer) {
                writeSpinCount -= this.doWriteMultiple(in);
                continue;
            }
            if (msgCount == 0) {
                this.clearFlag(Native.EPOLLOUT);
                return;
            }
            writeSpinCount -= this.doWriteSingle(in);
        } while (writeSpinCount > 0);
        if (writeSpinCount == 0) {
            this.clearFlag(Native.EPOLLOUT);
            this.executor().execute(this.flushTask);
        } else {
            this.setFlag(Native.EPOLLOUT);
        }
    }

    protected int doWriteSingle(ChannelOutboundBuffer in) throws Exception {
        Object msg = in.current();
        if (msg instanceof Buffer) {
            return this.writeBytes(in, (Buffer)msg);
        }
        if (msg instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(in, (DefaultFileRegion)msg);
        }
        if (msg instanceof FileRegion) {
            return this.writeFileRegion(in, (FileRegion)msg);
        }
        throw new Error();
    }

    private int doWriteMultiple(ChannelOutboundBuffer in) throws Exception {
        long maxBytesPerGatheringWrite = this.config().getMaxBytesPerGatheringWrite();
        IovArray array = this.registration().cleanIovArray();
        array.maxBytes(maxBytesPerGatheringWrite);
        in.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)array);
        if (array.count() >= 1) {
            return this.writeBytesMultiple(in, array);
        }
        in.removeBytes(0L);
        return 0;
    }

    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)buf) ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    @UnstableApi
    protected final void doShutdownOutput() throws Exception {
        this.socket.shutdown(false, true);
    }

    private void shutdownInput0(Promise<Void> promise) {
        try {
            this.socket.shutdown(true, false);
            promise.setSuccess(null);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public Future<Void> shutdownOutput() {
        return this.shutdownOutput((Promise<Void>)this.newPromise());
    }

    public Future<Void> shutdownOutput(Promise<Void> promise) {
        EventLoop loop = this.executor();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise);
        } else {
            loop.execute(() -> ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise));
        }
        return promise.asFuture();
    }

    public Future<Void> shutdownInput() {
        return this.shutdownInput((Promise<Void>)this.newPromise());
    }

    public Future<Void> shutdownInput(Promise<Void> promise) {
        Executor closeExecutor = ((EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (closeExecutor != null) {
            closeExecutor.execute(() -> this.shutdownInput0(promise));
        } else {
            EventLoop loop = this.executor();
            if (loop.inEventLoop()) {
                this.shutdownInput0(promise);
            } else {
                loop.execute(() -> this.shutdownInput0(promise));
            }
        }
        return promise.asFuture();
    }

    public Future<Void> shutdown() {
        return this.shutdown((Promise<Void>)this.newPromise());
    }

    public Future<Void> shutdown(Promise<Void> promise) {
        Future<Void> shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(promise, shutdownOutputFuture);
        } else {
            shutdownOutputFuture.addListener(promise, this::shutdownOutputDone);
        }
        return promise.asFuture();
    }

    private void shutdownOutputDone(Promise<Void> promise, Future<?> shutdownOutputFuture) {
        Future<Void> shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            AbstractEpollStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
        } else {
            shutdownInputFuture.addListener(shutdownInputFuture1 -> AbstractEpollStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture1, promise));
        }
    }

    private static void shutdownDone(Future<?> shutdownOutputFuture, Future<?> shutdownInputFuture, Promise<Void> promise) {
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            if (shutdownInputCause != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(shutdownOutputCause);
        } else if (shutdownInputCause != null) {
            promise.setFailure(shutdownInputCause);
        } else {
            promise.setSuccess(null);
        }
    }

    private final class EpollSocketWritableByteChannel
    extends SocketWritableByteChannel {
        EpollSocketWritableByteChannel() {
            super((FileDescriptor)AbstractEpollStreamChannel.this.socket);
        }

        protected BufferAllocator alloc() {
            return AbstractEpollStreamChannel.this.bufferAllocator();
        }
    }

    class EpollStreamUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollStreamUnsafe() {
            super(AbstractEpollStreamChannel.this);
        }

        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        private void handleReadException(ChannelPipeline pipeline, Buffer buffer, Throwable cause, boolean close, EpollRecvBufferAllocatorHandle allocHandle) {
            if (buffer.readableBytes() > 0) {
                this.readPending = false;
                pipeline.fireChannelRead((Object)buffer);
            } else {
                buffer.close();
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof OutOfMemoryError || cause instanceof IOException) {
                this.shutdownInput(false);
            } else {
                AbstractEpollStreamChannel.this.readIfIsAutoRead();
            }
        }

        @Override
        EpollRecvBufferAllocatorHandle newEpollHandle(RecvBufferAllocator.Handle handle) {
            return new EpollRecvBufferAllocatorStreamingHandle(handle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            EpollDuplexChannelConfig config = AbstractEpollStreamChannel.this.config();
            if (AbstractEpollStreamChannel.this.shouldBreakEpollInReady((ChannelConfig)config)) {
                this.clearEpollIn0();
                return;
            }
            EpollRecvBufferAllocatorHandle recvAlloc = this.recvBufAllocHandle();
            ChannelPipeline pipeline = AbstractEpollStreamChannel.this.pipeline();
            BufferAllocator bufferAllocator = config.getBufferAllocator();
            recvAlloc.reset((ChannelConfig)config);
            this.epollInBefore();
            Buffer buffer = null;
            boolean close = false;
            try {
                do {
                    buffer = recvAlloc.allocate(bufferAllocator);
                    AbstractEpollStreamChannel.this.doReadBytes(buffer);
                    if (recvAlloc.lastBytesRead() <= 0) {
                        Resource.dispose((Object)buffer);
                        buffer = null;
                        boolean bl = close = recvAlloc.lastBytesRead() < 0;
                        if (!close) break;
                        this.readPending = false;
                        break;
                    }
                    recvAlloc.incMessagesRead(1);
                    this.readPending = false;
                    pipeline.fireChannelRead((Object)buffer);
                    buffer = null;
                } while (!AbstractEpollStreamChannel.this.shouldBreakEpollInReady((ChannelConfig)config) && recvAlloc.continueReading());
                recvAlloc.readComplete();
                pipeline.fireChannelReadComplete();
                if (close) {
                    this.shutdownInput(false);
                } else {
                    AbstractEpollStreamChannel.this.readIfIsAutoRead();
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, buffer, t, close, recvAlloc);
            }
            finally {
                this.epollInFinally((ChannelConfig)config);
            }
        }
    }
}

