/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty.buffer.Unpooled;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.Resource;
import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.DefaultBufferAddressedEnvelope;
import io.netty5.channel.EventLoop;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.Epoll;
import io.netty5.channel.epoll.EpollDatagramChannelConfig;
import io.netty5.channel.epoll.EpollRecvBufferAllocatorHandle;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.epoll.NativeDatagramPacketArray;
import io.netty5.channel.socket.DatagramChannel;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.channel.socket.InternetProtocolFamily;
import io.netty5.channel.unix.Errors;
import io.netty5.channel.unix.SegmentedDatagramPacket;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.UncheckedBooleanSupplier;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.RecyclableArrayList;
import io.netty5.util.internal.StringUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.util.Objects;

public final class EpollDatagramChannel
extends AbstractEpollChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private final EpollDatagramChannelConfig config = new EpollDatagramChannelConfig(this);
    private volatile boolean connected;

    public static boolean isSegmentedDatagramPacketSupported() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_SENDMMSG && Native.IS_SUPPORTING_UDP_SEGMENT;
    }

    public EpollDatagramChannel(EventLoop eventLoop) {
        this(eventLoop, (InternetProtocolFamily)null);
    }

    public EpollDatagramChannel(EventLoop eventLoop, InternetProtocolFamily family) {
        this(eventLoop, LinuxSocket.newSocketDgram(family), false);
    }

    public EpollDatagramChannel(EventLoop eventLoop, int fd) {
        this(eventLoop, new LinuxSocket(fd), true);
    }

    private EpollDatagramChannel(EventLoop eventLoop, LinuxSocket fd, boolean active) {
        super(null, eventLoop, fd, active);
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Future<Void> joinGroup(InetAddress multicastAddress) {
        return this.joinGroup(multicastAddress, (Promise<Void>)this.newPromise());
    }

    public Future<Void> joinGroup(InetAddress multicastAddress, Promise<Void> promise) {
        try {
            NetworkInterface iface = this.config().getNetworkInterface();
            if (iface == null) {
                iface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup(multicastAddress, iface, null, promise);
        }
        catch (IOException e) {
            return promise.setFailure((Throwable)e).asFuture();
        }
    }

    public Future<Void> joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.joinGroup(multicastAddress, networkInterface, (Promise<Void>)this.newPromise());
    }

    public Future<Void> joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, Promise<Void> promise) {
        return this.joinGroup(multicastAddress.getAddress(), networkInterface, null, promise);
    }

    public Future<Void> joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.joinGroup(multicastAddress, networkInterface, source, (Promise<Void>)this.newPromise());
    }

    public Future<Void> joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, Promise<Void> promise) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        try {
            this.socket.joinGroup(multicastAddress, networkInterface, source);
            promise.setSuccess(null);
        }
        catch (IOException e) {
            promise.setFailure((Throwable)e);
        }
        return promise.asFuture();
    }

    public Future<Void> leaveGroup(InetAddress multicastAddress) {
        return this.leaveGroup(multicastAddress, (Promise<Void>)this.newPromise());
    }

    public Future<Void> leaveGroup(InetAddress multicastAddress, Promise<Void> promise) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (IOException e) {
            return promise.setFailure((Throwable)e).asFuture();
        }
    }

    public Future<Void> leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(multicastAddress, networkInterface, (Promise<Void>)this.newPromise());
    }

    public Future<Void> leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, Promise<Void> promise) {
        return this.leaveGroup(multicastAddress.getAddress(), networkInterface, null, promise);
    }

    public Future<Void> leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.leaveGroup(multicastAddress, networkInterface, source, (Promise<Void>)this.newPromise());
    }

    public Future<Void> leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, Promise<Void> promise) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface, source);
            promise.setSuccess(null);
        }
        catch (IOException e) {
            promise.setFailure((Throwable)e);
        }
        return promise.asFuture();
    }

    public Future<Void> block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        return this.block(multicastAddress, networkInterface, sourceToBlock, (Promise<Void>)this.newPromise());
    }

    public Future<Void> block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, Promise<Void> promise) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(sourceToBlock, "sourceToBlock");
        Objects.requireNonNull(networkInterface, "networkInterface");
        promise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return promise.asFuture();
    }

    public Future<Void> block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        return this.block(multicastAddress, sourceToBlock, (Promise<Void>)this.newPromise());
    }

    public Future<Void> block(InetAddress multicastAddress, InetAddress sourceToBlock, Promise<Void> promise) {
        try {
            return this.block(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), sourceToBlock, promise);
        }
        catch (Throwable e) {
            promise.setFailure(e);
            return promise.asFuture();
        }
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDatagramChannelUnsafe();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        InetSocketAddress socketAddress;
        if (localAddress instanceof InetSocketAddress && (socketAddress = (InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && socketAddress.getAddress() instanceof Inet4Address && this.socket.family() == InternetProtocolFamily.IPv6) {
            localAddress = new InetSocketAddress(LinuxSocket.INET6_ANY, socketAddress.getPort());
        }
        super.doBind(localAddress);
        this.active = true;
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        int maxMessagesPerWrite = this.maxMessagesPerWrite();
        while (maxMessagesPerWrite > 0 && (msg = in.current()) != null) {
            try {
                if (Native.IS_SUPPORTING_SENDMMSG && in.size() > 1 || in.current() instanceof SegmentedDatagramPacket) {
                    NativeDatagramPacketArray array = this.cleanDatagramPacketArray();
                    array.add(in, this.isConnected(), maxMessagesPerWrite);
                    int cnt = array.count();
                    if (cnt >= 1) {
                        int offset = 0;
                        NativeDatagramPacketArray.NativeDatagramPacket[] packets = array.packets();
                        int send = this.socket.sendmmsg(packets, offset, cnt);
                        if (send == 0) break;
                        for (int i = 0; i < send; ++i) {
                            in.remove();
                        }
                        maxMessagesPerWrite -= send;
                        continue;
                    }
                }
                boolean done = false;
                for (int i = this.config().getWriteSpinCount(); i > 0; --i) {
                    if (!this.doWriteMessage(msg)) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                in.remove();
                --maxMessagesPerWrite;
            }
            catch (IOException e) {
                --maxMessagesPerWrite;
                in.remove((Throwable)e);
            }
        }
        if (in.isEmpty()) {
            this.clearFlag(Native.EPOLLOUT);
        } else {
            this.setFlag(Native.EPOLLOUT);
        }
    }

    private boolean doWriteMessage(Object msg) throws Exception {
        InetSocketAddress remoteAddress;
        Buffer data;
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = (Buffer)envelope.content();
            remoteAddress = (InetSocketAddress)envelope.recipient();
        } else {
            data = (Buffer)msg;
            remoteAddress = null;
        }
        if (data.readableBytes() == 0) {
            return true;
        }
        return this.doWriteOrSendBytes(data, remoteAddress, false) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object filterOutboundMessage(Object msg) {
        AddressedEnvelope e;
        if (msg instanceof SegmentedDatagramPacket) {
            if (!Native.IS_SUPPORTING_UDP_SEGMENT) {
                throw new UnsupportedOperationException("Unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
            }
            SegmentedDatagramPacket packet = (SegmentedDatagramPacket)msg;
            Buffer content = (Buffer)packet.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)content) ? packet.replace(this.newDirectBuffer((Resource<?>)packet, content)) : msg;
        }
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            Buffer content = (Buffer)packet.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)content) ? new DatagramPacket(this.newDirectBuffer((Resource<?>)packet, content), (InetSocketAddress)packet.recipient()) : msg;
        }
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)buf) ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof AddressedEnvelope && ((e = (AddressedEnvelope)msg).recipient() == null || e.recipient() instanceof InetSocketAddress)) {
            InetSocketAddress recipient = (InetSocketAddress)e.recipient();
            Object content = e.content();
            if (content instanceof Buffer) {
                Buffer buf = (Buffer)content;
                if (UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)buf)) {
                    try {
                        DefaultBufferAddressedEnvelope defaultBufferAddressedEnvelope = new DefaultBufferAddressedEnvelope(this.newDirectBuffer(buf), (SocketAddress)recipient);
                        return defaultBufferAddressedEnvelope;
                    }
                    finally {
                        ReferenceCountUtil.release((Object)e);
                    }
                }
                return e;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    @Override
    public EpollDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (super.doConnect(remoteAddress, localAddress)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectedRead(EpollRecvBufferAllocatorHandle allocHandle, Buffer buf, int maxDatagramPacketSize) throws Exception {
        try {
            int writable = maxDatagramPacketSize != 0 ? Math.min(buf.writableBytes(), maxDatagramPacketSize) : buf.writableBytes();
            allocHandle.attemptedBytesRead(writable);
            int initialWritableBytes = buf.writableBytes();
            buf.forEachWritable(0, (index, component) -> {
                long address = component.writableNativeAddress();
                assert (address != 0L);
                int bytesRead = this.socket.readAddress(address, 0, component.writableBytes());
                allocHandle.lastBytesRead(bytesRead);
                if (bytesRead <= 0) {
                    return false;
                }
                component.skipWritable(bytesRead);
                return true;
            });
            int totalBytesRead = initialWritableBytes - buf.writableBytes();
            if (totalBytesRead == 0) {
                boolean bl = false;
                return bl;
            }
            if (maxDatagramPacketSize > 0) {
                allocHandle.lastBytesRead(totalBytesRead);
            }
            DatagramPacket packet = new DatagramPacket(buf, this.localAddress(), this.remoteAddress());
            allocHandle.incMessagesRead(1);
            this.pipeline().fireChannelRead((Object)packet);
            buf = null;
            boolean bl = true;
            return bl;
        }
        finally {
            if (buf != null) {
                buf.close();
            }
        }
    }

    private IOException translateForConnected(Errors.NativeIoException e) {
        if (e.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            PortUnreachableException error = new PortUnreachableException(e.getMessage());
            error.initCause(e);
            return error;
        }
        return e;
    }

    private static void addDatagramPacketToOut(AddressedEnvelope<?, ?> packet, RecyclableArrayList out) {
        if (packet instanceof SegmentedDatagramPacket) {
            try (SegmentedDatagramPacket segmentedDatagramPacket = (SegmentedDatagramPacket)packet;){
                Buffer content = (Buffer)segmentedDatagramPacket.content();
                InetSocketAddress recipient = (InetSocketAddress)segmentedDatagramPacket.recipient();
                InetSocketAddress sender = (InetSocketAddress)segmentedDatagramPacket.sender();
                int segmentSize = segmentedDatagramPacket.segmentSize();
                do {
                    out.add((Object)new DatagramPacket(content.readSplit(segmentSize), recipient, sender));
                } while (content.readableBytes() > 0);
            }
        } else {
            out.add(packet);
        }
    }

    private static void releaseAndRecycle(Object buffer, RecyclableArrayList packetList) {
        if (ReferenceCountUtil.isReferenceCounted((Object)buffer)) {
            ReferenceCountUtil.release((Object)buffer);
        } else if (buffer instanceof Resource) {
            ((Resource)buffer).close();
        }
        if (packetList != null) {
            for (int i = 0; i < packetList.size(); ++i) {
                ReferenceCountUtil.release((Object)packetList.get(i));
            }
            packetList.recycle();
        }
    }

    private static void processPacket(ChannelPipeline pipeline, EpollRecvBufferAllocatorHandle handle, int bytesRead, AddressedEnvelope<?, ?> packet) {
        handle.lastBytesRead(bytesRead);
        handle.incMessagesRead(1);
        pipeline.fireChannelRead(packet);
    }

    private static void processPacketList(ChannelPipeline pipeline, EpollRecvBufferAllocatorHandle handle, int bytesRead, RecyclableArrayList packetList) {
        int messagesRead = packetList.size();
        handle.lastBytesRead(bytesRead);
        handle.incMessagesRead(messagesRead);
        for (int i = 0; i < messagesRead; ++i) {
            pipeline.fireChannelRead(packetList.set(i, (Object)Unpooled.EMPTY_BUFFER));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recvmsg(EpollRecvBufferAllocatorHandle allocHandle, NativeDatagramPacketArray array, Buffer buf) throws IOException {
        int bytesReceived;
        NativeDatagramPacketArray.NativeDatagramPacket msg;
        int initialWriterOffset;
        RecyclableArrayList datagramPackets;
        block6: {
            boolean bl;
            datagramPackets = null;
            try {
                initialWriterOffset = buf.writerOffset();
                boolean added = array.addWritable(buf, 0, null);
                assert (added);
                allocHandle.attemptedBytesRead(buf.writerOffset() - initialWriterOffset);
                msg = array.packets()[0];
                bytesReceived = this.socket.recvmsg(msg);
                if (bytesReceived != 0) break block6;
                allocHandle.lastBytesRead(-1);
                bl = false;
            }
            catch (Throwable throwable) {
                EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
                throw throwable;
            }
            EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
            return bl;
        }
        buf.writerOffset(initialWriterOffset + bytesReceived);
        InetSocketAddress local = this.localAddress();
        DatagramPacket packet = msg.newDatagramPacket(buf, local);
        if (!(packet instanceof SegmentedDatagramPacket)) {
            EpollDatagramChannel.processPacket(this.pipeline(), allocHandle, bytesReceived, packet);
            buf = null;
        } else {
            datagramPackets = RecyclableArrayList.newInstance();
            EpollDatagramChannel.addDatagramPacketToOut(packet, datagramPackets);
            buf = null;
            EpollDatagramChannel.processPacketList(this.pipeline(), allocHandle, bytesReceived, datagramPackets);
            datagramPackets.recycle();
            datagramPackets = null;
        }
        boolean bl = true;
        EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scatteringRead(EpollRecvBufferAllocatorHandle allocHandle, NativeDatagramPacketArray array, Buffer buf, int datagramSize, int numDatagram) throws IOException {
        boolean bl;
        InetSocketAddress local;
        int bytesReceived;
        int received;
        NativeDatagramPacketArray.NativeDatagramPacket[] packets;
        RecyclableArrayList datagramPackets;
        block7: {
            DatagramPacket packet;
            int initialWriterOffset;
            block6: {
                datagramPackets = null;
                initialWriterOffset = buf.writerOffset();
                for (int i = 0; i < numDatagram && array.addWritable(buf, datagramSize, null); ++i) {
                }
                allocHandle.attemptedBytesRead(buf.writerOffset() - initialWriterOffset);
                packets = array.packets();
                received = this.socket.recvmmsg(packets, 0, array.count());
                if (received != 0) break block6;
                allocHandle.lastBytesRead(-1);
                boolean bl2 = false;
                EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
                return bl2;
            }
            bytesReceived = received * datagramSize;
            buf.writerOffset(initialWriterOffset + bytesReceived);
            local = this.localAddress();
            if (received != 1 || (packet = packets[0].newDatagramPacket(buf, local)) instanceof SegmentedDatagramPacket) break block7;
            EpollDatagramChannel.processPacket(this.pipeline(), allocHandle, datagramSize, packet);
            buf = null;
            boolean bl3 = true;
            EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
            return bl3;
        }
        try {
            datagramPackets = RecyclableArrayList.newInstance();
            for (int i = 0; i < received; ++i) {
                DatagramPacket packet = packets[i].newDatagramPacket(buf.readSplit(datagramSize), local);
                EpollDatagramChannel.addDatagramPacketToOut(packet, datagramPackets);
            }
            buf.close();
            buf = null;
            EpollDatagramChannel.processPacketList(this.pipeline(), allocHandle, bytesReceived, datagramPackets);
            datagramPackets.recycle();
            datagramPackets = null;
            bl = true;
        }
        catch (Throwable throwable) {
            EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
            throw throwable;
        }
        EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
        return bl;
    }

    private NativeDatagramPacketArray cleanDatagramPacketArray() {
        return this.registration().cleanDatagramPacketArray();
    }

    final class EpollDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (EpollDatagramChannel.this.executor().inEventLoop());
            EpollDatagramChannelConfig config = EpollDatagramChannel.this.config();
            if (EpollDatagramChannel.this.shouldBreakEpollInReady((ChannelConfig)config)) {
                this.clearEpollIn0();
                return;
            }
            EpollRecvBufferAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = EpollDatagramChannel.this.pipeline();
            allocHandle.reset((ChannelConfig)config);
            this.epollInBefore();
            try {
                Throwable exception = this.doReadBuffer(allocHandle);
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    pipeline.fireExceptionCaught(exception);
                }
                EpollDatagramChannel.this.readIfIsAutoRead();
            }
            finally {
                this.epollInFinally((ChannelConfig)config);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Throwable doReadBuffer(EpollRecvBufferAllocatorHandle allocHandle) {
            BufferAllocator allocator = EpollDatagramChannel.this.config().getBufferAllocator();
            try {
                boolean connected = EpollDatagramChannel.this.isConnected();
                do {
                    boolean read;
                    int datagramSize = EpollDatagramChannel.this.config().getMaxDatagramPayloadSize();
                    Buffer buf = allocHandle.allocate(allocator);
                    int numDatagram = Native.IS_SUPPORTING_RECVMMSG ? (datagramSize == 0 ? 1 : buf.writableBytes() / datagramSize) : 0;
                    try {
                        read = numDatagram <= 1 ? (!connected || EpollDatagramChannel.this.config().isUdpGro() ? EpollDatagramChannel.this.recvmsg(allocHandle, EpollDatagramChannel.this.cleanDatagramPacketArray(), buf) : EpollDatagramChannel.this.connectedRead(allocHandle, buf, datagramSize)) : EpollDatagramChannel.this.scatteringRead(allocHandle, EpollDatagramChannel.this.cleanDatagramPacketArray(), buf, datagramSize, numDatagram);
                    }
                    catch (Errors.NativeIoException e) {
                        if (!connected) throw e;
                        throw EpollDatagramChannel.this.translateForConnected(e);
                    }
                    if (!read) return null;
                    this.readPending = false;
                } while (allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                return null;
            }
            catch (Throwable t) {
                return t;
            }
        }
    }
}

