/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.DefaultBufferAllocators;
import io.netty5.buffer.api.ReadableComponentProcessor;
import io.netty5.buffer.api.Resource;
import io.netty5.buffer.api.WritableComponentProcessor;
import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.DefaultBufferAddressedEnvelope;
import io.netty5.channel.EventLoop;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.EpollDomainDatagramChannelConfig;
import io.netty5.channel.epoll.EpollRecvBufferAllocatorHandle;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.unix.DomainDatagramChannel;
import io.netty5.channel.unix.DomainDatagramPacket;
import io.netty5.channel.unix.DomainDatagramSocketAddress;
import io.netty5.channel.unix.DomainSocketAddress;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.PeerCredentials;
import io.netty5.channel.unix.RecvFromAddressDomainSocket;
import io.netty5.channel.unix.Socket;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.CharsetUtil;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.UncheckedBooleanSupplier;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.io.IOException;
import java.net.SocketAddress;

@UnstableApi
public final class EpollDomainDatagramChannel
extends AbstractEpollChannel
implements DomainDatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DomainDatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private volatile boolean connected;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;
    private final EpollDomainDatagramChannelConfig config = new EpollDomainDatagramChannelConfig(this);

    public EpollDomainDatagramChannel(EventLoop eventLoop) {
        this(eventLoop, LinuxSocket.newSocketDomainDgram(), false);
    }

    public EpollDomainDatagramChannel(EventLoop eventLoop, int fd) {
        this(eventLoop, new LinuxSocket(fd), true);
    }

    private EpollDomainDatagramChannel(EventLoop eventLoop, LinuxSocket socket, boolean active) {
        super(null, eventLoop, socket, active);
    }

    @Override
    public EpollDomainDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        this.local = (DomainSocketAddress)localAddress;
        this.active = true;
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.active = false;
        this.connected = false;
        this.local = null;
        this.remote = null;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (super.doConnect(remoteAddress, localAddress)) {
            if (localAddress != null) {
                this.local = (DomainSocketAddress)localAddress;
            }
            this.remote = (DomainSocketAddress)remoteAddress;
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        int maxMessagesPerWrite = this.maxMessagesPerWrite();
        while (maxMessagesPerWrite > 0 && (msg = in.current()) != null) {
            try {
                boolean done = false;
                for (int i = this.config().getWriteSpinCount(); i > 0; --i) {
                    if (!this.doWriteMessage(msg)) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                in.remove();
                --maxMessagesPerWrite;
            }
            catch (IOException e) {
                --maxMessagesPerWrite;
                in.remove((Throwable)e);
            }
        }
        if (in.isEmpty()) {
            this.clearFlag(Native.EPOLLOUT);
        } else {
            this.setFlag(Native.EPOLLOUT);
        }
    }

    private boolean doWriteMessage(Object msg) throws Exception {
        DomainSocketAddress remoteAddress;
        Object data;
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = envelope.content();
            remoteAddress = (DomainSocketAddress)envelope.recipient();
        } else {
            data = msg;
            remoteAddress = null;
        }
        return this.doWriteBufferMessage((Buffer)data, remoteAddress);
    }

    private boolean doWriteBufferMessage(Buffer data, DomainSocketAddress remoteAddress) throws IOException {
        int initialReadableBytes = data.readableBytes();
        if (initialReadableBytes == 0) {
            return true;
        }
        if (data.countReadableComponents() > 1) {
            IovArray array = this.registration().cleanIovArray();
            data.forEachReadable(0, (ReadableComponentProcessor)array);
            int count = array.count();
            assert (count != 0);
            long writtenBytes = remoteAddress == null ? this.socket.writevAddresses(array.memoryAddress(0), count) : (long)this.socket.sendToAddressesDomainSocket(array.memoryAddress(0), count, remoteAddress.path().getBytes(CharsetUtil.UTF_8));
            return writtenBytes > 0L;
        }
        if (remoteAddress == null) {
            data.forEachReadable(0, (index, component) -> {
                int written = this.socket.writeAddress(component.readableNativeAddress(), 0, component.readableBytes());
                component.skipReadable(written);
                return false;
            });
        } else {
            data.forEachReadable(0, (index, component) -> {
                int written = this.socket.sendToAddressDomainSocket(component.readableNativeAddress(), 0, component.readableBytes(), remoteAddress.path().getBytes(CharsetUtil.UTF_8));
                component.skipReadable(written);
                return false;
            });
        }
        return data.readableBytes() < initialReadableBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object filterOutboundMessage(Object msg) {
        AddressedEnvelope e;
        SocketAddress recipient;
        if (msg instanceof DomainDatagramPacket) {
            DomainDatagramPacket packet = (DomainDatagramPacket)msg;
            Buffer content = (Buffer)packet.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)content) ? new DomainDatagramPacket(this.newDirectBuffer((Resource<?>)packet, content), (DomainSocketAddress)packet.recipient()) : msg;
        }
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)buf) ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof AddressedEnvelope && ((recipient = (e = (AddressedEnvelope)msg).recipient()) == null || recipient instanceof DomainSocketAddress)) {
            DomainSocketAddress domainRecipient = (DomainSocketAddress)recipient;
            if (e.content() instanceof Buffer) {
                Buffer buf = (Buffer)e.content();
                if (UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)buf)) {
                    try {
                        DefaultBufferAddressedEnvelope defaultBufferAddressedEnvelope = new DefaultBufferAddressedEnvelope(this.newDirectBuffer(buf), (SocketAddress)domainRecipient);
                        return defaultBufferAddressedEnvelope;
                    }
                    finally {
                        ReferenceCountUtil.release((Object)e);
                    }
                }
                return e;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainDatagramChannelUnsafe();
    }

    public PeerCredentials peerCredentials() throws IOException {
        return this.socket.getPeerCredentials();
    }

    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    final class EpollDomainDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollDomainDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (EpollDomainDatagramChannel.this.executor().inEventLoop());
            EpollDomainDatagramChannelConfig config = EpollDomainDatagramChannel.this.config();
            if (EpollDomainDatagramChannel.this.shouldBreakEpollInReady((ChannelConfig)config)) {
                this.clearEpollIn0();
                return;
            }
            EpollRecvBufferAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = EpollDomainDatagramChannel.this.pipeline();
            allocHandle.reset((ChannelConfig)config);
            this.epollInBefore();
            try {
                Throwable exception = this.doReadBuffer(allocHandle, pipeline);
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    pipeline.fireExceptionCaught(exception);
                }
                EpollDomainDatagramChannel.this.readIfIsAutoRead();
            }
            finally {
                this.epollInFinally((ChannelConfig)config);
            }
        }

        private Throwable doReadBuffer(EpollRecvBufferAllocatorHandle allocHandle, ChannelPipeline pipeline) {
            BufferAllocator allocator = EpollDomainDatagramChannel.this.config().getBufferAllocator();
            if (!allocator.getAllocationType().isDirect()) {
                allocator = DefaultBufferAllocators.offHeapAllocator();
            }
            Buffer buf = null;
            try {
                boolean connected = EpollDomainDatagramChannel.this.isConnected();
                do {
                    DomainDatagramPacket packet;
                    buf = allocHandle.allocate(allocator);
                    allocHandle.attemptedBytesRead(buf.writableBytes());
                    if (connected) {
                        EpollDomainDatagramChannel.this.doReadBytes(buf);
                        if (allocHandle.lastBytesRead() <= 0) {
                            buf.close();
                            break;
                        }
                        packet = new DomainDatagramPacket(buf, (DomainSocketAddress)this.localAddress(), (DomainSocketAddress)this.remoteAddress());
                    } else {
                        RecvFromAddressDomainSocket recvFrom = new RecvFromAddressDomainSocket((Socket)EpollDomainDatagramChannel.this.socket);
                        buf.forEachWritable(0, (WritableComponentProcessor)recvFrom);
                        DomainDatagramSocketAddress remoteAddress = recvFrom.remoteAddress();
                        if (remoteAddress == null) {
                            allocHandle.lastBytesRead(-1);
                            buf.close();
                            break;
                        }
                        DomainDatagramSocketAddress localAddress = remoteAddress.localAddress();
                        if (localAddress == null) {
                            localAddress = (DomainSocketAddress)this.localAddress();
                        }
                        allocHandle.lastBytesRead(remoteAddress.receivedAmount());
                        buf.skipWritable(allocHandle.lastBytesRead());
                        packet = new DomainDatagramPacket(buf, (DomainSocketAddress)localAddress, (DomainSocketAddress)remoteAddress);
                    }
                    allocHandle.incMessagesRead(1);
                    this.readPending = false;
                    pipeline.fireChannelRead((Object)packet);
                    buf = null;
                } while (allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
            }
            catch (Throwable t) {
                if (buf != null) {
                    buf.close();
                }
                return t;
            }
            return null;
        }
    }
}

