/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.AbstractEpollStreamChannel;
import io.netty5.channel.epoll.EpollDomainSocketChannelConfig;
import io.netty5.channel.epoll.EpollRecvBufferAllocatorHandle;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.unix.DomainSocketAddress;
import io.netty5.channel.unix.DomainSocketChannel;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.PeerCredentials;
import io.netty5.util.internal.UnstableApi;
import java.io.IOException;
import java.net.SocketAddress;

public final class EpollDomainSocketChannel
extends AbstractEpollStreamChannel
implements DomainSocketChannel {
    private final EpollDomainSocketChannelConfig config = new EpollDomainSocketChannelConfig(this);
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public EpollDomainSocketChannel(EventLoop eventLoop) {
        super(eventLoop, LinuxSocket.newSocketDomain(), false);
    }

    EpollDomainSocketChannel(Channel parent, EventLoop eventLoop, FileDescriptor fd) {
        super(parent, eventLoop, new LinuxSocket(fd.intValue()));
    }

    public EpollDomainSocketChannel(EventLoop eventLoop, int fd) {
        super(eventLoop, fd);
    }

    public EpollDomainSocketChannel(Channel parent, EventLoop eventLoop, LinuxSocket fd) {
        super(parent, eventLoop, fd);
    }

    public EpollDomainSocketChannel(int fd, EventLoop eventLoop, boolean active) {
        super(eventLoop, new LinuxSocket(fd), active);
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainUnsafe();
    }

    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.socket.bind(localAddress);
        this.local = (DomainSocketAddress)localAddress;
    }

    @Override
    public EpollDomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (super.doConnect(remoteAddress, localAddress)) {
            this.local = (DomainSocketAddress)localAddress;
            this.remote = (DomainSocketAddress)remoteAddress;
            return true;
        }
        return false;
    }

    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected int doWriteSingle(ChannelOutboundBuffer in) throws Exception {
        Object msg = in.current();
        if (msg instanceof FileDescriptor && this.socket.sendFd(((FileDescriptor)msg).intValue()) > 0) {
            in.remove();
            return 1;
        }
        return super.doWriteSingle(in);
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof FileDescriptor) {
            return msg;
        }
        return super.filterOutboundMessage(msg);
    }

    @UnstableApi
    public PeerCredentials peerCredentials() throws IOException {
        return this.socket.getPeerCredentials();
    }

    private final class EpollDomainUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollDomainUnsafe() {
        }

        @Override
        void epollInReady() {
            switch (EpollDomainSocketChannel.this.config().getReadMode()) {
                case BYTES: {
                    super.epollInReady();
                    break;
                }
                case FILE_DESCRIPTORS: {
                    this.epollInReadFd();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void epollInReadFd() {
            if (EpollDomainSocketChannel.this.socket.isInputShutdown()) {
                this.clearEpollIn0();
                return;
            }
            EpollDomainSocketChannelConfig config = EpollDomainSocketChannel.this.config();
            EpollRecvBufferAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = EpollDomainSocketChannel.this.pipeline();
            allocHandle.reset((ChannelConfig)config);
            this.epollInBefore();
            try {
                block10: while (true) {
                    allocHandle.lastBytesRead(EpollDomainSocketChannel.this.socket.recvFd());
                    switch (allocHandle.lastBytesRead()) {
                        case 0: {
                            break block10;
                        }
                        case -1: {
                            this.close(EpollDomainSocketChannel.this.newPromise());
                            return;
                        }
                        default: {
                            allocHandle.incMessagesRead(1);
                            this.readPending = false;
                            pipeline.fireChannelRead((Object)new FileDescriptor(allocHandle.lastBytesRead()));
                            if (allocHandle.continueReading()) continue block10;
                        }
                    }
                    break;
                }
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
            }
            catch (Throwable t) {
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                pipeline.fireExceptionCaught(t);
            }
            finally {
                EpollDomainSocketChannel.this.readIfIsAutoRead();
                this.epollInFinally((ChannelConfig)config);
            }
        }
    }
}

