/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.epoll.AbstractEpollServerChannel;
import io.netty5.channel.epoll.EpollDomainSocketChannel;
import io.netty5.channel.epoll.EpollServerChannelConfig;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.unix.DomainSocketAddress;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.ServerDomainSocketChannel;
import io.netty5.channel.unix.Socket;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;

public final class EpollServerDomainSocketChannel
extends AbstractEpollServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollServerDomainSocketChannel.class);
    private final EpollServerChannelConfig config = new EpollServerChannelConfig(this);
    private volatile DomainSocketAddress local;

    public EpollServerDomainSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        super(eventLoop, childEventLoopGroup, LinuxSocket.newSocketDomain(), false);
    }

    public EpollServerDomainSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, int fd) {
        super(eventLoop, childEventLoopGroup, fd);
    }

    EpollServerDomainSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, LinuxSocket fd) {
        super(eventLoop, childEventLoopGroup, fd);
    }

    EpollServerDomainSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, LinuxSocket fd, boolean active) {
        super(eventLoop, childEventLoopGroup, fd, active);
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] addr, int offset, int len) throws Exception {
        return new EpollDomainSocketChannel((Channel)this, this.childEventLoopGroup().next(), (FileDescriptor)new Socket(fd));
    }

    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.socket.bind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)localAddress;
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        try {
            super.doClose();
        }
        finally {
            File socketFile;
            boolean success;
            DomainSocketAddress local = this.local;
            if (local != null && !(success = (socketFile = new File(local.path())).delete()) && logger.isDebugEnabled()) {
                logger.debug("Failed to delete a domain socket file: {}", (Object)local.path());
            }
        }
    }

    @Override
    public EpollServerChannelConfig config() {
        return this.config;
    }

    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }
}

