/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.epoll.AbstractEpollServerChannel;
import io.netty5.channel.epoll.EpollServerSocketChannelConfig;
import io.netty5.channel.epoll.EpollSocketChannel;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.epoll.TcpMd5Util;
import io.netty5.channel.socket.InternetProtocolFamily;
import io.netty5.channel.socket.ServerSocketChannel;
import io.netty5.channel.unix.NativeInetAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        this(eventLoop, childEventLoopGroup, (InternetProtocolFamily)null);
    }

    public EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, InternetProtocolFamily protocolFamily) {
        super(eventLoop, childEventLoopGroup, LinuxSocket.newSocketStream(protocolFamily), false);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    public EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, int fd) {
        this(eventLoop, childEventLoopGroup, new LinuxSocket(fd));
    }

    EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, LinuxSocket fd) {
        super(eventLoop, childEventLoopGroup, fd);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, LinuxSocket fd, boolean active) {
        super(eventLoop, childEventLoopGroup, fd, active);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        int tcpFastopen;
        super.doBind(localAddress);
        if (Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER && (tcpFastopen = this.config.getTcpFastopen()) > 0) {
            this.socket.setTcpFastOpen(tcpFastopen);
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public EpollServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        return new EpollSocketChannel((Channel)this, this.childEventLoopGroup().next(), new LinuxSocket(fd), NativeInetAddress.address((byte[])address, (int)offset, (int)len));
    }

    Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    void setTcpMd5Sig(Map<InetAddress, byte[]> keys) throws IOException {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys);
    }
}

