/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.Limits;
import io.netty5.channel.unix.NativeInetAddress;
import io.netty5.channel.unix.SegmentedDatagramPacket;
import io.netty5.util.internal.UnstableApi;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

final class NativeDatagramPacketArray {
    private final NativeDatagramPacket[] packets = new NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private final IovArray iovArray = new IovArray();
    private final byte[] ipv4Bytes = new byte[4];
    private final MyMessageProcessor processor = new MyMessageProcessor();
    private int count;

    NativeDatagramPacketArray() {
        for (int i = 0; i < this.packets.length; ++i) {
            this.packets[i] = new NativeDatagramPacket();
        }
    }

    boolean addWritable(Buffer buf, int segmentLen, InetSocketAddress recipient) {
        if (this.count == this.packets.length) {
            return false;
        }
        if (buf.writableBytes() == 0) {
            return true;
        }
        int iovArrayStart = this.iovArray.count();
        if (iovArrayStart == Limits.IOV_MAX) {
            return false;
        }
        return 0 != buf.forEachWritable(0, (index, component) -> {
            int byteCount;
            int writableBytes = component.writableBytes();
            int n = byteCount = segmentLen == 0 ? writableBytes : Math.min(writableBytes, segmentLen);
            if (this.iovArray.process(component, byteCount)) {
                NativeDatagramPacket p = this.packets[this.count];
                p.init(this.iovArray.memoryAddress(iovArrayStart), this.iovArray.count() - iovArrayStart, segmentLen, recipient);
                ++this.count;
                component.skipWritable(byteCount);
                return true;
            }
            return false;
        });
    }

    boolean addReadable(Buffer buf, int segmentLen, InetSocketAddress recipient) {
        if (this.count == this.packets.length) {
            return false;
        }
        if (buf.readableBytes() == 0) {
            return true;
        }
        int iovArrayStart = this.iovArray.count();
        if (iovArrayStart == Limits.IOV_MAX) {
            return false;
        }
        return 0 != buf.forEachReadable(0, (index, component) -> {
            int byteCount;
            int writableBytes = component.readableBytes();
            int n = byteCount = segmentLen == 0 ? writableBytes : Math.min(writableBytes, segmentLen);
            if (this.iovArray.process(component, byteCount)) {
                NativeDatagramPacket p = this.packets[this.count];
                long packetAddr = this.iovArray.memoryAddress(iovArrayStart);
                p.init(packetAddr, this.iovArray.count() - iovArrayStart, segmentLen, recipient);
                ++this.count;
                component.skipReadable(byteCount);
                return true;
            }
            return false;
        });
    }

    void add(ChannelOutboundBuffer buffer, boolean connected, int maxMessagesPerWrite) throws Exception {
        this.processor.connected = connected;
        this.processor.maxMessagesPerWrite = maxMessagesPerWrite;
        buffer.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)this.processor);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacket[] packets() {
        return this.packets;
    }

    void clear() {
        this.count = 0;
        this.iovArray.clear();
    }

    void release() {
        this.iovArray.release();
    }

    private static InetSocketAddress newAddress(byte[] addr, int addrLen, int port, int scopeId, byte[] ipv4Bytes) throws UnknownHostException {
        InetAddress address;
        if (addrLen == ipv4Bytes.length) {
            System.arraycopy(addr, 0, ipv4Bytes, 0, addrLen);
            address = InetAddress.getByAddress(ipv4Bytes);
        } else {
            address = Inet6Address.getByAddress(null, addr, scopeId);
        }
        return new InetSocketAddress(address, port);
    }

    @UnstableApi
    public final class NativeDatagramPacket {
        private long memoryAddress;
        private int count;
        private final byte[] senderAddr = new byte[16];
        private int senderAddrLen;
        private int senderScopeId;
        private int senderPort;
        private final byte[] recipientAddr = new byte[16];
        private int recipientAddrLen;
        private int recipientScopeId;
        private int recipientPort;
        private int segmentSize;

        private void init(long memoryAddress, int count, int segmentSize, InetSocketAddress recipient) {
            this.memoryAddress = memoryAddress;
            this.count = count;
            this.segmentSize = segmentSize;
            this.senderScopeId = 0;
            this.senderPort = 0;
            this.senderAddrLen = 0;
            if (recipient == null) {
                this.recipientScopeId = 0;
                this.recipientPort = 0;
                this.recipientAddrLen = 0;
            } else {
                InetAddress address = recipient.getAddress();
                if (address instanceof Inet6Address) {
                    System.arraycopy(address.getAddress(), 0, this.recipientAddr, 0, this.recipientAddr.length);
                    this.recipientScopeId = ((Inet6Address)address).getScopeId();
                } else {
                    NativeInetAddress.copyIpv4MappedIpv6Address((byte[])address.getAddress(), (byte[])this.recipientAddr);
                    this.recipientScopeId = 0;
                }
                this.recipientAddrLen = this.recipientAddr.length;
                this.recipientPort = recipient.getPort();
            }
        }

        DatagramPacket newDatagramPacket(Buffer buffer, InetSocketAddress recipient) throws UnknownHostException {
            InetSocketAddress sender = NativeDatagramPacketArray.newAddress(this.senderAddr, this.senderAddrLen, this.senderPort, this.senderScopeId, NativeDatagramPacketArray.this.ipv4Bytes);
            if (this.recipientAddrLen != 0) {
                recipient = NativeDatagramPacketArray.newAddress(this.recipientAddr, this.recipientAddrLen, this.recipientPort, this.recipientScopeId, NativeDatagramPacketArray.this.ipv4Bytes);
            }
            if (this.segmentSize > 0) {
                return new SegmentedDatagramPacket(buffer, this.segmentSize, recipient, sender);
            }
            return new DatagramPacket(buffer, recipient, sender);
        }
    }

    private final class MyMessageProcessor
    implements ChannelOutboundBuffer.MessageProcessor {
        private boolean connected;
        private int maxMessagesPerWrite;

        private MyMessageProcessor() {
        }

        public boolean processMessage(Object msg) {
            boolean added;
            if (msg instanceof DatagramPacket) {
                DatagramPacket packet = (DatagramPacket)msg;
                Buffer buf = (Buffer)packet.content();
                int segmentSize = 0;
                if (packet instanceof SegmentedDatagramPacket) {
                    int seg = ((SegmentedDatagramPacket)packet).segmentSize();
                    if (buf.readableBytes() > seg) {
                        segmentSize = seg;
                    }
                }
                boolean addedAny = false;
                while (buf.readableBytes() > 0 && NativeDatagramPacketArray.this.addReadable(buf, segmentSize, (InetSocketAddress)packet.recipient())) {
                    addedAny = true;
                }
                added = addedAny;
            } else if (msg instanceof Buffer && this.connected) {
                Buffer buf = (Buffer)msg;
                boolean addedAny = false;
                while (buf.readableBytes() > 0 && NativeDatagramPacketArray.this.addReadable(buf, 0, null)) {
                    addedAny = true;
                }
                added = addedAny;
            } else {
                added = false;
            }
            if (added) {
                --this.maxMessagesPerWrite;
                return this.maxMessagesPerWrite > 0;
            }
            return false;
        }
    }
}

