/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.epoll.EpollRegistration;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.socket.DomainSocketAddress;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IntegerUnixChannelOption;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.RawUnixChannelOption;
import io.netty5.channel.unix.Socket;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.Resource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

abstract class AbstractEpollChannel<P extends UnixChannel>
extends AbstractChannel<P, SocketAddress, SocketAddress>
implements UnixChannel {
    protected final LinuxSocket socket;
    private final Runnable readNowRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractEpollChannel.this.readNowRunnablePending = false;
            AbstractEpollChannel.this.readNow();
        }
    };
    protected volatile boolean active;
    private EpollRegistration registration;
    private int flags = Native.EPOLLET;
    private boolean readNowRunnablePending;
    private boolean maybeMoreDataToRead;
    private boolean receivedRdHup;
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;

    AbstractEpollChannel(EventLoop eventLoop, boolean supportingDisconnect, int initialFlag, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, LinuxSocket fd) {
        this(null, eventLoop, supportingDisconnect, initialFlag, defaultReadHandleFactory, defaultWriteHandleFactory, fd, false);
    }

    AbstractEpollChannel(P parent, EventLoop eventLoop, boolean supportingDisconnect, int initialFlag, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, LinuxSocket fd, boolean active) {
        super(parent, eventLoop, supportingDisconnect, defaultReadHandleFactory, defaultWriteHandleFactory);
        this.flags |= initialFlag;
        this.socket = Objects.requireNonNull(fd, "fd");
        this.active = active;
        if (active) {
            this.localAddress = fd.localAddress();
            this.remoteAddress = fd.remoteAddress();
        }
    }

    AbstractEpollChannel(P parent, EventLoop eventLoop, boolean supportingDisconnect, int initialFlag, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, LinuxSocket fd, SocketAddress remote) {
        super(parent, eventLoop, supportingDisconnect, defaultReadHandleFactory, defaultWriteHandleFactory);
        this.flags |= initialFlag;
        this.socket = Objects.requireNonNull(fd, "fd");
        this.active = true;
        this.remoteAddress = remote;
        this.localAddress = fd.localAddress();
    }

    protected final boolean fetchLocalAddress() {
        return this.socket.protocolFamily() != SocketProtocolFamily.UNIX;
    }

    protected static boolean isSoErrorZero(Socket fd) {
        try {
            return fd.getSoError() == 0;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    protected final void setFlag(int flag) throws IOException {
        if (!this.isFlagSet(flag)) {
            this.flags |= flag;
            this.modifyEvents();
        }
    }

    protected final void clearFlag(int flag) throws IOException {
        if (this.isFlagSet(flag)) {
            this.flags &= ~flag;
            this.modifyEvents();
        }
    }

    protected final EpollRegistration registration() {
        assert (this.registration != null);
        return this.registration;
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    final int flags() {
        return this.flags;
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void doClose() throws Exception {
        this.active = false;
        this.socket.close();
    }

    final void resetCachedAddresses() {
        this.cacheAddresses(this.localAddress, null);
        this.remoteAddress = null;
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    public final boolean isOpen() {
        return this.socket.isOpen();
    }

    final void register0(EpollRegistration registration) {
        this.readNowRunnablePending = false;
        this.registration = registration;
    }

    final void deregister0() throws Exception {
        if (this.registration != null) {
            this.registration.remove();
        }
    }

    protected final void doRead(boolean wasReadPendingAlready) throws Exception {
        if (!wasReadPendingAlready) {
            this.setFlag(Native.EPOLLIN);
        }
        if (this.maybeMoreDataToRead || this.receivedRdHup) {
            this.executeReadNowRunnable();
        }
    }

    private void modifyEvents() throws IOException {
        if (this.isOpen() && this.isRegistered() && this.registration != null) {
            this.registration.update();
        }
    }

    protected final Buffer newDirectBuffer(Buffer buf) {
        return this.newDirectBuffer((Resource<?>)buf, buf);
    }

    protected final Buffer newDirectBuffer(Resource<?> holder, Buffer buf) {
        BufferAllocator allocator = this.ioBufferAllocator();
        try (Resource<?> resource = holder;){
            int readableBytes = buf.readableBytes();
            Buffer directCopy = allocator.allocate(readableBytes);
            if (readableBytes > 0) {
                directCopy.writeBytes(buf);
            }
            Buffer buffer = directCopy;
            return buffer;
        }
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(Buffer buffer) throws Exception {
        try (ComponentIterator iterator = buffer.forEachComponent();){
            BufferComponent component = (BufferComponent)iterator.firstWritable();
            if (component == null) {
                int n = 0;
                return n;
            }
            long address = component.writableNativeAddress();
            assert (address != 0L);
            int n = this.socket.recvAddress(address, 0, component.writableBytes());
            return n;
        }
    }

    protected final int doWriteBytes(Buffer buf) throws Exception {
        int written = 0;
        try (ComponentIterator iterator = buf.forEachComponent();){
            BufferComponent component = (BufferComponent)iterator.firstReadable();
            if (component != null) {
                long address = component.readableNativeAddress();
                assert (address != 0L);
                written = this.socket.sendAddress(address, 0, component.readableBytes());
            }
        }
        return written;
    }

    protected final long doWriteOrSendBytes(Buffer data, SocketAddress remoteAddress, boolean fastOpen) throws IOException {
        assert (!fastOpen || remoteAddress != null) : "fastOpen requires a remote address";
        IovArray array = this.registration().cleanIovArray();
        array.addReadable(data);
        int count = array.count();
        assert (count != 0);
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
            return this.socket.sendToAddressesDomainSocket(array.memoryAddress(0), count, ((DomainSocketAddress)remoteAddress).path().getBytes(StandardCharsets.UTF_8));
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
        return this.socket.sendToAddresses(array.memoryAddress(0), count, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), fastOpen);
    }

    final void epollInReady() {
        this.readNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doReadNow(AbstractChannel.ReadSink readSink) throws Exception {
        boolean bl;
        this.maybeMoreDataToRead = false;
        ReadState readState = null;
        try {
            readState = this.epollInReady(readSink);
            bl = readState == ReadState.Closed;
            this.maybeMoreDataToRead = readState == ReadState.Partial || this.receivedRdHup;
        }
        catch (Throwable throwable) {
            this.maybeMoreDataToRead = readState == ReadState.Partial || this.receivedRdHup;
            throw throwable;
        }
        return bl;
    }

    protected void readLoopComplete() {
        super.readLoopComplete();
        if (this.receivedRdHup || this.isReadPending() && this.maybeMoreDataToRead) {
            this.executeReadNowRunnable();
        }
    }

    protected abstract ReadState epollInReady(AbstractChannel.ReadSink var1) throws Exception;

    private void executeReadNowRunnable() {
        if (this.readNowRunnablePending || !this.isActive()) {
            return;
        }
        this.readNowRunnablePending = true;
        this.executor().execute(this.readNowRunnable);
    }

    final void epollRdHupReady() {
        this.receivedRdHup = true;
        this.clearEpollRdHup();
        if (this.isActive()) {
            this.read();
        } else {
            this.shutdownReadSide();
        }
    }

    private void clearEpollRdHup() {
        try {
            this.clearFlag(Native.EPOLLRDHUP);
        }
        catch (IOException e) {
            this.pipeline().fireChannelExceptionCaught((Throwable)e);
            this.closeTransport(this.newPromise());
        }
    }

    protected boolean isWriteFlushedScheduled() {
        return this.isFlagSet(Native.EPOLLOUT);
    }

    final void epollOutReady() {
        if (this.isConnectPending()) {
            this.finishConnect();
        } else if (!this.socket.isOutputShutdown()) {
            this.writeFlushedNow();
        }
    }

    protected boolean doFinishConnect(SocketAddress requestedRemoteAddress) throws Exception {
        if (this.socket.finishConnect()) {
            this.active = true;
            this.clearFlag(Native.EPOLLOUT);
            this.remoteAddress = requestedRemoteAddress instanceof InetSocketAddress ? UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)requestedRemoteAddress), (InetSocketAddress)this.socket.remoteAddress()) : requestedRemoteAddress;
            return true;
        }
        this.setFlag(Native.EPOLLOUT);
        return false;
    }

    protected void doBind(SocketAddress local) throws Exception {
        if (local instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind(local);
        this.localAddress = this.fetchLocalAddress() ? this.socket.localAddress() : local;
    }

    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        boolean connected;
        InetSocketAddress remoteSocketAddr;
        if (localAddress instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)localAddress);
        }
        InetSocketAddress inetSocketAddress = remoteSocketAddr = remoteAddress instanceof InetSocketAddress ? (InetSocketAddress)remoteAddress : null;
        if (remoteSocketAddr != null) {
            AbstractEpollChannel.checkResolvable(remoteSocketAddr);
        }
        if (localAddress != null) {
            this.socket.bind(localAddress);
        }
        if (connected = this.doConnect0(remoteAddress, initialData)) {
            this.remoteAddress = remoteSocketAddr == null ? remoteAddress : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)remoteSocketAddr, (InetSocketAddress)this.socket.remoteAddress());
            this.active = true;
        }
        if (this.fetchLocalAddress()) {
            this.localAddress = this.socket.localAddress();
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doConnect0(SocketAddress remote, Buffer initialData) throws Exception {
        boolean success = false;
        try {
            boolean connected = this.socket.connect(remote);
            if (!connected) {
                this.setFlag(Native.EPOLLOUT);
            }
            success = true;
            boolean bl = connected;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    protected final SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected final SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    final void closeTransportNow() {
        this.closeTransport(this.newPromise());
    }

    protected <T> T getExtendedOption(ChannelOption<T> option) {
        try {
            if (option instanceof IntegerUnixChannelOption) {
                IntegerUnixChannelOption opt = (IntegerUnixChannelOption)option;
                return (T)Integer.valueOf(this.socket.getIntOpt(opt.level(), opt.optname()));
            }
            if (option instanceof RawUnixChannelOption) {
                RawUnixChannelOption opt = (RawUnixChannelOption)option;
                ByteBuffer out = ByteBuffer.allocate(opt.length());
                this.socket.getRawOpt(opt.level(), opt.optname(), out);
                return (T)out.flip();
            }
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
        return (T)super.getExtendedOption(option);
    }

    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        try {
            if (option instanceof IntegerUnixChannelOption) {
                IntegerUnixChannelOption opt = (IntegerUnixChannelOption)option;
                this.socket.setIntOpt(opt.level(), opt.optname(), (Integer)value);
                return;
            }
            if (option instanceof RawUnixChannelOption) {
                RawUnixChannelOption opt = (RawUnixChannelOption)option;
                this.socket.setRawOpt(opt.level(), opt.optname(), (ByteBuffer)value);
                return;
            }
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
        super.setExtendedOption(option, value);
    }

    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        if (option instanceof IntegerUnixChannelOption || option instanceof RawUnixChannelOption) {
            return true;
        }
        return super.isExtendedOptionSupported(option);
    }

    protected final void doClearScheduledRead() {
        assert (this.executor().inEventLoop());
        try {
            this.clearFlag(Native.EPOLLIN);
        }
        catch (IOException e) {
            this.pipeline().fireChannelExceptionCaught((Throwable)e);
            this.closeTransport(this.newPromise());
        }
    }

    protected void writeLoopComplete(boolean allWritten) {
        try {
            if (allWritten) {
                this.clearFlag(Native.EPOLLOUT);
            } else {
                this.setFlag(Native.EPOLLOUT);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while trying to update flags", e);
        }
        super.writeLoopComplete(allWritten);
    }

    protected BufferAllocator readBufferAllocator() {
        return AbstractEpollChannel.ioBufferAllocator(super.readBufferAllocator());
    }

    private BufferAllocator ioBufferAllocator() {
        return AbstractEpollChannel.ioBufferAllocator(this.bufferAllocator());
    }

    private static BufferAllocator ioBufferAllocator(BufferAllocator alloc) {
        if (!alloc.getAllocationType().isDirect()) {
            return DefaultBufferAllocators.offHeapAllocator();
        }
        return alloc;
    }

    static enum ReadState {
        All,
        Partial,
        Closed;

    }
}

