/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AdaptiveReadHandleFactory;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultFileRegion;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FileRegion;
import io.netty5.channel.IoHandle;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.EpollChannelOption;
import io.netty5.channel.epoll.EpollServerSocketChannel;
import io.netty5.channel.epoll.EpollTcpInfo;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.epoll.TcpMd5Util;
import io.netty5.channel.socket.SocketChannel;
import io.netty5.channel.socket.SocketChannelWriteHandleFactory;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.DomainSocketReadMode;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.Limits;
import io.netty5.channel.unix.PeerCredentials;
import io.netty5.channel.unix.SocketWritableByteChannel;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.GlobalEventExecutor;
import io.netty5.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;

public final class EpollSocketChannel
extends AbstractEpollChannel<EpollServerSocketChannel>
implements SocketChannel {
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS = EpollSocketChannel.supportedOptions();
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS_DOMAIN_SOCKET = EpollSocketChannel.supportedOptionsDomainSocket();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ")";
    private WritableByteChannel byteChannel;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();
    private volatile DomainSocketReadMode mode = DomainSocketReadMode.BYTES;
    private volatile boolean tcpFastopen;

    public EpollSocketChannel(EventLoop eventLoop) {
        this(eventLoop, (ProtocolFamily)null);
    }

    public EpollSocketChannel(EventLoop eventLoop, ProtocolFamily protocolFamily) {
        super(null, eventLoop, false, Native.EPOLLRDHUP, (ReadHandleFactory)new AdaptiveReadHandleFactory(), EpollSocketChannel.newWriteHandleFactory(), LinuxSocket.newSocket(protocolFamily), false);
    }

    public EpollSocketChannel(EventLoop eventLoop, int fd, ProtocolFamily family) {
        this(eventLoop, new LinuxSocket(fd, SocketProtocolFamily.of((ProtocolFamily)family)));
    }

    private EpollSocketChannel(EventLoop eventLoop, LinuxSocket socket) {
        super(null, eventLoop, false, Native.EPOLLRDHUP, (ReadHandleFactory)new AdaptiveReadHandleFactory(), EpollSocketChannel.newWriteHandleFactory(), socket, EpollSocketChannel.isSoErrorZero(socket));
    }

    EpollSocketChannel(EpollServerSocketChannel parent, EventLoop eventLoop, LinuxSocket fd, SocketAddress remoteAddress) {
        super(parent, eventLoop, false, Native.EPOLLRDHUP, (ReadHandleFactory)new AdaptiveReadHandleFactory(), EpollSocketChannel.newWriteHandleFactory(), fd, remoteAddress);
        if (fd.protocolFamily() != SocketProtocolFamily.UNIX && parent != null) {
            this.tcpMd5SigAddresses = parent.tcpMd5SigAddresses();
        }
    }

    private static WriteHandleFactory newWriteHandleFactory() {
        return new SocketChannelWriteHandleFactory(Integer.MAX_VALUE, Limits.SSIZE_MAX);
    }

    private void writeBytes(AbstractChannel.WriteSink writeSink) throws Exception {
        int written;
        long attempted;
        Buffer buf = (Buffer)writeSink.currentFlushedMessage();
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            writeSink.complete(0L, 0L, 1, true);
            return;
        }
        int readableComponents = buf.countReadableComponents();
        if (readableComponents == 1) {
            attempted = buf.readableBytes();
            written = this.doWriteBytes(buf);
        } else {
            attempted = Math.min(writeSink.estimatedMaxBytesPerGatheringWrite(), (long)buf.readableBytes());
            ByteBuffer[] nioBuffers = new ByteBuffer[readableComponents];
            try (ComponentIterator iteration = buf.forEachComponent();){
                int index = 0;
                BufferComponent c = (BufferComponent)iteration.first();
                while (c != null) {
                    nioBuffers[index++] = c.readableBuffer();
                    c = (BufferComponent)((ComponentIterator.Next)c).next();
                }
                written = (int)this.writeBytesMultiple(nioBuffers, nioBuffers.length, readableBytes, attempted);
            }
        }
        if (written > 0) {
            buf.skipReadableBytes(written);
        }
        writeSink.complete(attempted, (long)written, readableBytes == written ? 1 : 0, written > 0);
    }

    private long writeBytesMultiple(IovArray array) throws IOException {
        long expectedWrittenBytes = array.size();
        assert (expectedWrittenBytes != 0L);
        int cnt = array.count();
        assert (cnt != 0);
        return this.socket.writevAddresses(array.memoryAddress(0), cnt);
    }

    private long writeBytesMultiple(ByteBuffer[] nioBuffers, int nioBufferCnt, long expectedWrittenBytes, long maxBytesPerGatheringWrite) throws IOException {
        assert (expectedWrittenBytes != 0L);
        if (expectedWrittenBytes > maxBytesPerGatheringWrite) {
            expectedWrittenBytes = maxBytesPerGatheringWrite;
        }
        return this.socket.writev(nioBuffers, 0, nioBufferCnt, expectedWrittenBytes);
    }

    private void writeDefaultFileRegion(AbstractChannel.WriteSink writeSink) throws Exception {
        DefaultFileRegion region = (DefaultFileRegion)writeSink.currentFlushedMessage();
        long regionCount = region.count();
        long transferred = region.transferred();
        if (transferred >= regionCount) {
            writeSink.complete(0L, 0L, 1, true);
        } else {
            long flushedAmount = this.socket.sendFile(region, region.position(), transferred, regionCount - transferred);
            if (flushedAmount == 0L) {
                EpollSocketChannel.validateFileRegion((DefaultFileRegion)region, (long)transferred);
            }
            writeSink.complete(regionCount, flushedAmount, region.transferred() >= regionCount ? 1 : 0, flushedAmount > 0L);
        }
    }

    private void writeFileRegion(AbstractChannel.WriteSink writeSink) throws Exception {
        FileRegion region = (FileRegion)writeSink.currentFlushedMessage();
        long regionCount = region.count();
        long transferred = region.transferred();
        if (transferred >= regionCount) {
            writeSink.complete(0L, 0L, 1, true);
        } else {
            if (this.byteChannel == null) {
                this.byteChannel = new EpollSocketWritableByteChannel();
            }
            long flushedAmount = region.transferTo(this.byteChannel, region.transferred());
            writeSink.complete(regionCount, flushedAmount, region.transferred() >= regionCount ? 1 : 0, flushedAmount > 0L);
        }
    }

    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        int msgCount = writeSink.numFlushedMessages();
        if (msgCount > 1 && writeSink.currentFlushedMessage() instanceof Buffer) {
            this.doWriteMultiple(writeSink);
        } else {
            this.doWriteSingle(writeSink);
        }
    }

    private void doWriteSingle(AbstractChannel.WriteSink writeSink) throws Exception {
        Object msg = writeSink.currentFlushedMessage();
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && msg instanceof FileDescriptor) {
            if (this.socket.sendFd(((FileDescriptor)msg).intValue()) > 0) {
                writeSink.complete(0L, 0L, 1, true);
            } else {
                writeSink.complete(0L, 0L, 0, false);
            }
            return;
        }
        if (msg instanceof Buffer) {
            this.writeBytes(writeSink);
        } else if (msg instanceof DefaultFileRegion) {
            this.writeDefaultFileRegion(writeSink);
        } else if (msg instanceof FileRegion) {
            this.writeFileRegion(writeSink);
        } else {
            throw new Error();
        }
    }

    private void doWriteMultiple(AbstractChannel.WriteSink writeSink) throws Exception {
        IovArray array = this.registration().cleanIovArray();
        array.maxBytes(writeSink.estimatedMaxBytesPerGatheringWrite());
        writeSink.forEachFlushedMessage((Predicate)array);
        if (array.count() >= 1) {
            long result = this.writeBytesMultiple(array);
            int messages = writeSink.updateBufferReaderOffsets(result);
            writeSink.complete(array.size(), result, messages, result > 0L);
        } else {
            writeSink.complete(0L, 0L, writeSink.numFlushedMessages(), true);
        }
    }

    protected Object filterOutboundMessage(Object msg) {
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && msg instanceof FileDescriptor) {
            return msg;
        }
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite((Buffer)buf) ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    protected void doShutdown(ChannelShutdownDirection direction) throws Exception {
        switch (direction) {
            case Outbound: {
                this.socket.shutdown(false, true);
                break;
            }
            case Inbound: {
                try {
                    this.socket.shutdown(true, false);
                }
                catch (NotYetConnectedException notYetConnectedException) {}
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Outbound: {
                return this.socket.isOutputShutdown();
            }
            case Inbound: {
                return this.socket.isInputShutdown();
            }
        }
        throw new AssertionError();
    }

    @Override
    protected AbstractEpollChannel.ReadState epollInReady(AbstractChannel.ReadSink readSink) throws Exception {
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && this.getReadMode() == DomainSocketReadMode.FILE_DESCRIPTORS) {
            return this.epollInReadFd(readSink);
        }
        return this.epollInReadyBytes(readSink);
    }

    private AbstractEpollChannel.ReadState epollInReadyBytes(AbstractChannel.ReadSink readSink) throws Exception {
        Buffer buffer = null;
        try {
            int actualBytesRead;
            boolean readMore;
            buffer = readSink.allocateBuffer();
            if (buffer == null) {
                readSink.processRead(0, 0, null);
                return AbstractEpollChannel.ReadState.Partial;
            }
            assert (buffer.isDirect());
            int attemptedBytesRead = buffer.writableBytes();
            boolean bl = readMore = attemptedBytesRead == (actualBytesRead = this.doReadBytes(buffer));
            if (actualBytesRead <= 0) {
                Resource.dispose((Object)buffer);
                buffer = null;
                readSink.processRead(attemptedBytesRead, actualBytesRead, null);
                if (actualBytesRead < 0) {
                    return AbstractEpollChannel.ReadState.Closed;
                }
                return AbstractEpollChannel.ReadState.All;
            }
            buffer.skipWritableBytes(actualBytesRead);
            readSink.processRead(attemptedBytesRead, actualBytesRead, (Object)buffer);
            buffer = null;
            if (readMore) {
                return AbstractEpollChannel.ReadState.Partial;
            }
            return AbstractEpollChannel.ReadState.All;
        }
        catch (Throwable t) {
            if (buffer != null) {
                buffer.close();
            }
            throw t;
        }
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (EpollSocketChannel.isOptionSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_SNDBUF) {
                return (T)Integer.valueOf(this.getSendBufferSize());
            }
            if (option == ChannelOption.TCP_NODELAY) {
                return (T)Boolean.valueOf(this.isTcpNoDelay());
            }
            if (option == ChannelOption.SO_KEEPALIVE) {
                return (T)Boolean.valueOf(this.isKeepAlive());
            }
            if (option == ChannelOption.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.isReuseAddress());
            }
            if (option == ChannelOption.SO_LINGER) {
                return (T)Integer.valueOf(this.getSoLinger());
            }
            if (option == ChannelOption.IP_TOS) {
                return (T)Integer.valueOf(this.getTrafficClass());
            }
            if (option == EpollChannelOption.TCP_CORK) {
                return (T)Boolean.valueOf(this.isTcpCork());
            }
            if (option == EpollChannelOption.TCP_NOTSENT_LOWAT) {
                return (T)Long.valueOf(this.getTcpNotSentLowAt());
            }
            if (option == EpollChannelOption.TCP_KEEPIDLE) {
                return (T)Integer.valueOf(this.getTcpKeepIdle());
            }
            if (option == EpollChannelOption.TCP_KEEPINTVL) {
                return (T)Integer.valueOf(this.getTcpKeepIntvl());
            }
            if (option == EpollChannelOption.TCP_KEEPCNT) {
                return (T)Integer.valueOf(this.getTcpKeepCnt());
            }
            if (option == EpollChannelOption.TCP_USER_TIMEOUT) {
                return (T)Integer.valueOf(this.getTcpUserTimeout());
            }
            if (option == EpollChannelOption.TCP_QUICKACK) {
                return (T)Boolean.valueOf(this.isTcpQuickAck());
            }
            if (option == EpollChannelOption.IP_TRANSPARENT) {
                return (T)Boolean.valueOf(this.isIpTransparent());
            }
            if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
                return (T)Boolean.valueOf(this.isTcpFastOpenConnect());
            }
            if (option == EpollChannelOption.SO_BUSY_POLL) {
                return (T)Integer.valueOf(this.getSoBusyPoll());
            }
            if (option == UnixChannelOption.DOMAIN_SOCKET_READ_MODE) {
                return (T)this.getReadMode();
            }
            if (option == EpollChannelOption.TCP_INFO) {
                return (T)this.getTcpInfo();
            }
            if (option == UnixChannelOption.SO_PEERCRED) {
                return (T)this.getPeerCredentials();
            }
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (EpollSocketChannel.isOptionSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_SNDBUF) {
                this.setSendBufferSize((Integer)value);
            } else if (option == ChannelOption.TCP_NODELAY) {
                this.setTcpNoDelay((Boolean)value);
            } else if (option == ChannelOption.SO_KEEPALIVE) {
                this.setKeepAlive((Boolean)value);
            } else if (option == ChannelOption.SO_REUSEADDR) {
                this.setReuseAddress((Boolean)value);
            } else if (option == ChannelOption.SO_LINGER) {
                this.setSoLinger((Integer)value);
            } else if (option == ChannelOption.IP_TOS) {
                this.setTrafficClass((Integer)value);
            } else if (option == EpollChannelOption.TCP_CORK) {
                this.setTcpCork((Boolean)value);
            } else if (option == EpollChannelOption.TCP_NOTSENT_LOWAT) {
                this.setTcpNotSentLowAt((Long)value);
            } else if (option == EpollChannelOption.TCP_KEEPIDLE) {
                this.setTcpKeepIdle((Integer)value);
            } else if (option == EpollChannelOption.TCP_KEEPCNT) {
                this.setTcpKeepCnt((Integer)value);
            } else if (option == EpollChannelOption.TCP_KEEPINTVL) {
                this.setTcpKeepIntvl((Integer)value);
            } else if (option == EpollChannelOption.TCP_USER_TIMEOUT) {
                this.setTcpUserTimeout((Integer)value);
            } else if (option == EpollChannelOption.IP_TRANSPARENT) {
                this.setIpTransparent((Boolean)value);
            } else if (option == EpollChannelOption.TCP_MD5SIG) {
                Map m = (Map)value;
                this.setTcpMd5Sig(m);
            } else if (option == EpollChannelOption.TCP_QUICKACK) {
                this.setTcpQuickAck((Boolean)value);
            } else if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
                this.setTcpFastOpenConnect((Boolean)value);
            } else if (option == EpollChannelOption.SO_BUSY_POLL) {
                this.setSoBusyPoll((Integer)value);
            } else if (option == UnixChannelOption.DOMAIN_SOCKET_READ_MODE) {
                this.setReadMode((DomainSocketReadMode)value);
            } else {
                if (option == EpollChannelOption.TCP_INFO) {
                    throw new UnsupportedOperationException("read-only option: " + option);
                }
                if (option == UnixChannelOption.SO_PEERCRED) {
                    throw new UnsupportedOperationException("read-only option: " + option);
                }
            }
        } else {
            super.setExtendedOption(option, value);
        }
    }

    private static boolean isOptionSupported(SocketProtocolFamily family, ChannelOption<?> option) {
        if (family == SocketProtocolFamily.UNIX) {
            return SUPPORTED_OPTIONS_DOMAIN_SOCKET.contains(option);
        }
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return EpollSocketChannel.isOptionSupported(this.socket.protocolFamily(), option) || super.isExtendedOptionSupported(option);
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return EpollSocketChannel.newSupportedIdentityOptionsSet((ChannelOption[])new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, EpollChannelOption.TCP_CORK, EpollChannelOption.TCP_KEEPIDLE, EpollChannelOption.TCP_KEEPCNT, EpollChannelOption.TCP_KEEPINTVL, EpollChannelOption.TCP_USER_TIMEOUT, EpollChannelOption.IP_TRANSPARENT, EpollChannelOption.TCP_MD5SIG, EpollChannelOption.TCP_QUICKACK, ChannelOption.TCP_FASTOPEN_CONNECT, EpollChannelOption.SO_BUSY_POLL, EpollChannelOption.TCP_NOTSENT_LOWAT, EpollChannelOption.TCP_INFO});
    }

    private static Set<ChannelOption<?>> supportedOptionsDomainSocket() {
        return EpollSocketChannel.newSupportedIdentityOptionsSet((ChannelOption[])new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, UnixChannelOption.DOMAIN_SOCKET_READ_MODE, UnixChannelOption.SO_PEERCRED});
    }

    private int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getSoLinger() {
        try {
            return this.socket.getSoLinger();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private boolean isKeepAlive() {
        try {
            return this.socket.isKeepAlive();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private boolean isReuseAddress() {
        try {
            return this.socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private boolean isTcpNoDelay() {
        try {
            return this.socket.isTcpNoDelay();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private boolean isTcpCork() {
        try {
            return this.socket.isTcpCork();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getSoBusyPoll() {
        try {
            return this.socket.getSoBusyPoll();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private long getTcpNotSentLowAt() {
        try {
            return this.socket.getTcpNotSentLowAt();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getTcpKeepIdle() {
        try {
            return this.socket.getTcpKeepIdle();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getTcpKeepIntvl() {
        try {
            return this.socket.getTcpKeepIntvl();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getTcpKeepCnt() {
        try {
            return this.socket.getTcpKeepCnt();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private int getTcpUserTimeout() {
        try {
            return this.socket.getTcpUserTimeout();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setKeepAlive(boolean keepAlive) {
        try {
            this.socket.setKeepAlive(keepAlive);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setSendBufferSize(int sendBufferSize) {
        try {
            this.socket.setSendBufferSize(sendBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setSoLinger(int soLinger) {
        try {
            this.socket.setSoLinger(soLinger);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpNoDelay(boolean tcpNoDelay) {
        try {
            this.socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpCork(boolean tcpCork) {
        try {
            this.socket.setTcpCork(tcpCork);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setSoBusyPoll(int loopMicros) {
        try {
            this.socket.setSoBusyPoll(loopMicros);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpNotSentLowAt(long tcpNotSentLowAt) {
        try {
            this.socket.setTcpNotSentLowAt(tcpNotSentLowAt);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTrafficClass(int trafficClass) {
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpKeepIdle(int seconds) {
        try {
            this.socket.setTcpKeepIdle(seconds);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpKeepIntvl(int seconds) {
        try {
            this.socket.setTcpKeepIntvl(seconds);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpKeepCnt(int probes) {
        try {
            this.socket.setTcpKeepCnt(probes);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpUserTimeout(int milliseconds) {
        try {
            this.socket.setTcpUserTimeout(milliseconds);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isIpTransparent() {
        try {
            return this.socket.isIpTransparent();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setIpTransparent(boolean transparent) {
        try {
            this.socket.setIpTransparent(transparent);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setTcpQuickAck(boolean quickAck) {
        try {
            this.socket.setTcpQuickAck(quickAck);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private boolean isTcpQuickAck() {
        try {
            return this.socket.isTcpQuickAck();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private void setReadMode(DomainSocketReadMode mode) {
        Objects.requireNonNull(mode, "mode");
        this.mode = mode;
    }

    private DomainSocketReadMode getReadMode() {
        return this.mode;
    }

    private void setTcpFastOpenConnect(boolean fastOpenConnect) {
        this.tcpFastopen = fastOpenConnect;
    }

    private boolean isTcpFastOpenConnect() {
        return this.tcpFastopen;
    }

    private EpollTcpInfo getTcpInfo() {
        try {
            EpollTcpInfo info = new EpollTcpInfo();
            this.socket.getTcpInfo(info);
            return info;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @Override
    protected boolean doConnect0(SocketAddress remote, Buffer initialData) throws Exception {
        long localFlushedAmount;
        if (Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT && this.socket.protocolFamily() != SocketProtocolFamily.UNIX && this.isTcpFastOpenConnect() && initialData != null && (localFlushedAmount = this.doWriteOrSendBytes(initialData, remote, true)) > 0L) {
            initialData.skipReadableBytes((int)localFlushedAmount);
            return true;
        }
        return super.doConnect0(remote, initialData);
    }

    protected Future<Executor> prepareToClose() {
        if (this.socket.protocolFamily() != SocketProtocolFamily.UNIX) {
            try {
                if (this.isOpen() && this.getSoLinger() > 0) {
                    this.executor().deregisterForIo((IoHandle)this).map(v -> GlobalEventExecutor.INSTANCE);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTcpMd5Sig(Map<InetAddress, byte[]> keys) {
        EpollSocketChannel epollSocketChannel = this;
        synchronized (epollSocketChannel) {
            try {
                this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys);
            }
            catch (IOException e) {
                throw new ChannelException((Throwable)e);
            }
        }
    }

    private PeerCredentials getPeerCredentials() {
        try {
            return this.socket.getPeerCredentials();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private AbstractEpollChannel.ReadState epollInReadFd(AbstractChannel.ReadSink readSink) throws Exception {
        int readFd = this.socket.recvFd();
        switch (readFd) {
            case 0: {
                readSink.processRead(0, 0, null);
                return AbstractEpollChannel.ReadState.All;
            }
            case -1: {
                readSink.processRead(0, 0, null);
                this.closeTransport(this.newPromise());
                return AbstractEpollChannel.ReadState.Closed;
            }
        }
        readSink.processRead(0, 0, (Object)new FileDescriptor(readFd));
        return AbstractEpollChannel.ReadState.Partial;
    }

    private final class EpollSocketWritableByteChannel
    extends SocketWritableByteChannel {
        EpollSocketWritableByteChannel() {
            super((FileDescriptor)EpollSocketChannel.this.socket);
        }

        protected int write(ByteBuffer buf, int pos, int limit) throws IOException {
            return EpollSocketChannel.this.socket.send(buf, pos, limit);
        }

        protected BufferAllocator alloc() {
            return EpollSocketChannel.this.bufferAllocator();
        }
    }
}

