/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.kqueue;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.kqueue.BsdSocket;
import io.netty5.channel.kqueue.KQueueReadHandleFactory;
import io.netty5.channel.kqueue.KQueueRegistration;
import io.netty5.channel.kqueue.Native;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IntegerUnixChannelOption;
import io.netty5.channel.unix.RawUnixChannelOption;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.Resource;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;
import java.util.Objects;

abstract class AbstractKQueueChannel<P extends UnixChannel>
extends AbstractChannel<P, SocketAddress, SocketAddress>
implements UnixChannel {
    final BsdSocket socket;
    protected volatile boolean active;
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private final Runnable readNowRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractKQueueChannel.this.readNowRunnablePending = false;
            AbstractKQueueChannel.this.readNow();
        }
    };
    private long numberBytesPending;
    private KQueueRegistration registration;
    private boolean readFilterEnabled;
    private boolean writeFilterEnabled;
    private boolean readNowRunnablePending;
    private boolean maybeMoreDataToRead;
    private boolean eof;

    AbstractKQueueChannel(P parent, EventLoop eventLoop, boolean supportsDisconnect, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, BsdSocket fd, boolean active) {
        super(parent, eventLoop, supportsDisconnect, defaultReadHandleFactory, defaultWriteHandleFactory);
        this.socket = Objects.requireNonNull(fd, "fd");
        this.active = active;
        if (active) {
            this.localAddress = fd.localAddress();
            this.remoteAddress = fd.remoteAddress();
        }
    }

    AbstractKQueueChannel(P parent, EventLoop eventLoop, boolean supportsDisconnect, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, BsdSocket fd, SocketAddress remote) {
        super(parent, eventLoop, supportsDisconnect, defaultReadHandleFactory, defaultWriteHandleFactory);
        this.socket = Objects.requireNonNull(fd, "fd");
        this.active = true;
        this.localAddress = fd.localAddress();
        this.remoteAddress = remote;
    }

    protected <T> T getExtendedOption(ChannelOption<T> option) {
        try {
            if (option instanceof IntegerUnixChannelOption) {
                IntegerUnixChannelOption opt = (IntegerUnixChannelOption)option;
                return (T)Integer.valueOf(this.socket.getIntOpt(opt.level(), opt.optname()));
            }
            if (option instanceof RawUnixChannelOption) {
                RawUnixChannelOption opt = (RawUnixChannelOption)option;
                ByteBuffer out = ByteBuffer.allocate(opt.length());
                this.socket.getRawOpt(opt.level(), opt.optname(), out);
                return (T)out.flip();
            }
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
        return (T)super.getExtendedOption(option);
    }

    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        try {
            if (option instanceof IntegerUnixChannelOption) {
                IntegerUnixChannelOption opt = (IntegerUnixChannelOption)option;
                this.socket.setIntOpt(opt.level(), opt.optname(), (Integer)value);
                return;
            }
            if (option instanceof RawUnixChannelOption) {
                RawUnixChannelOption opt = (RawUnixChannelOption)option;
                this.socket.setRawOpt(opt.level(), opt.optname(), (ByteBuffer)value);
                return;
            }
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
        super.setExtendedOption(option, value);
    }

    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        if (option instanceof IntegerUnixChannelOption || option instanceof RawUnixChannelOption) {
            return true;
        }
        return super.isExtendedOptionSupported(option);
    }

    static boolean isSoErrorZero(BsdSocket fd) {
        try {
            return fd.getSoError() == 0;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    protected final KQueueRegistration registration() {
        assert (this.registration != null);
        return this.registration;
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void doClose() throws Exception {
        this.active = false;
        this.socket.close();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    final void resetCachedAddresses() {
        this.cacheAddresses(this.localAddress, null);
        this.remoteAddress = null;
    }

    public final boolean isOpen() {
        return this.socket.isOpen();
    }

    protected final void doRead(boolean wasReadPendingAlready) {
        if (!wasReadPendingAlready) {
            this.readFilter(true);
        }
        if (this.maybeMoreDataToRead || this.eof) {
            this.executeReadNowRunnable();
        }
    }

    final void register0(KQueueRegistration registration) {
        this.registration = registration;
        this.readNowRunnablePending = false;
        if (this.writeFilterEnabled) {
            this.evSet0(registration, Native.EVFILT_WRITE, Native.EV_ADD_CLEAR_ENABLE);
        }
        if (this.readFilterEnabled) {
            this.evSet0(registration, Native.EVFILT_READ, Native.EV_ADD_CLEAR_ENABLE);
        }
        this.evSet0(registration, Native.EVFILT_SOCK, Native.EV_ADD, Native.NOTE_RDHUP);
    }

    final void deregister0() {
        this.readFilterEnabled = false;
        this.writeFilterEnabled = false;
    }

    final void unregisterFilters() {
        this.readFilter(false);
        this.writeFilter(false);
        if (this.registration != null) {
            this.evSet0(this.registration, Native.EVFILT_SOCK, Native.EV_DELETE, 0);
            this.registration = null;
        }
    }

    protected final Buffer newDirectBuffer(Buffer buf) {
        return this.newDirectBuffer((Resource<?>)buf, buf);
    }

    protected final Buffer newDirectBuffer(Resource<?> holder, Buffer buf) {
        BufferAllocator allocator = this.ioBufferAllocator();
        try (Resource<?> resource = holder;){
            int readableBytes = buf.readableBytes();
            Buffer directCopy = allocator.allocate(readableBytes);
            if (readableBytes > 0) {
                directCopy.writeBytes(buf);
            }
            Buffer buffer = directCopy;
            return buffer;
        }
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(Buffer buffer) throws Exception {
        try (ComponentIterator iterator = buffer.forEachComponent();){
            ComponentIterator.Next component = iterator.firstWritable();
            if (component == null) {
                int n = 0;
                return n;
            }
            long address = ((BufferComponent)component).writableNativeAddress();
            assert (address != 0L);
            int n = this.socket.readAddress(address, 0, ((BufferComponent)component).writableBytes());
            return n;
        }
    }

    protected final int doWriteBytes(Buffer buf) throws Exception {
        int written = 0;
        try (ComponentIterator iteration = buf.forEachComponent();){
            ComponentIterator.Next component = iteration.firstReadable();
            if (component != null) {
                long address = ((BufferComponent)component).readableNativeAddress();
                assert (address != 0L);
                written = this.socket.writeAddress(address, 0, ((BufferComponent)component).readableBytes());
            }
        }
        return written;
    }

    final void readFilter(boolean readFilterEnabled) {
        if (this.readFilterEnabled != readFilterEnabled) {
            this.readFilterEnabled = readFilterEnabled;
            this.evSet(Native.EVFILT_READ, readFilterEnabled ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    final void writeFilter(boolean writeFilterEnabled) {
        if (this.writeFilterEnabled != writeFilterEnabled) {
            this.writeFilterEnabled = writeFilterEnabled;
            this.evSet(Native.EVFILT_WRITE, writeFilterEnabled ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    private void evSet(short filter, short flags) {
        if (this.isRegistered()) {
            this.evSet0(this.registration, filter, flags);
        }
    }

    private void evSet0(KQueueRegistration registration, short filter, short flags) {
        this.evSet0(registration, filter, flags, 0);
    }

    private void evSet0(KQueueRegistration registration, short filter, short flags, int fflags) {
        if (this.isOpen()) {
            registration.evSet(filter, flags, fflags);
        }
    }

    final void readReady(long numberBytesPending) {
        ReadHandleFactory.ReadHandle readHandle = this.readHandle();
        if (readHandle instanceof KQueueReadHandleFactory.KQueueReadHandle) {
            ((KQueueReadHandleFactory.KQueueReadHandle)readHandle).bufferCapacity(Math.min(128, (int)Math.min(numberBytesPending, 0x800000L)));
        }
        this.numberBytesPending = numberBytesPending;
        this.readNow();
    }

    protected boolean doReadNow(AbstractChannel.ReadSink readSink) throws Exception {
        this.maybeMoreDataToRead = false;
        int readBytes = this.readReady(readSink);
        if (readBytes > 0) {
            this.numberBytesPending -= (long)readBytes;
        } else if (readBytes == -1) {
            this.numberBytesPending = 0L;
            return true;
        }
        return false;
    }

    protected void readLoopComplete() {
        super.readLoopComplete();
        boolean bl = this.maybeMoreDataToRead = this.numberBytesPending != 0L;
        if (this.eof || this.isReadPending() && this.maybeMoreDataToRead) {
            this.executeReadNowRunnable();
        }
    }

    abstract int readReady(AbstractChannel.ReadSink var1) throws Exception;

    final void writeReady() {
        if (this.isConnectPending()) {
            this.finishConnect();
        } else if (!this.socket.isOutputShutdown()) {
            this.writeFlushedNow();
        }
    }

    final void readEOF() {
        this.eof = true;
        if (this.isActive()) {
            this.read();
        } else {
            if (this.isConnectPending()) {
                this.finishConnect();
            }
            this.shutdownReadSide();
        }
    }

    protected boolean isWriteFlushedScheduled() {
        return this.writeFilterEnabled;
    }

    private void executeReadNowRunnable() {
        if (this.readNowRunnablePending || !this.isActive()) {
            return;
        }
        this.readNowRunnablePending = true;
        this.executor().execute(this.readNowRunnable);
    }

    protected final boolean doFinishConnect(SocketAddress requestedRemoteAddress) throws Exception {
        if (this.socket.finishConnect()) {
            this.active = true;
            this.writeFilter(false);
            this.remoteAddress = requestedRemoteAddress instanceof InetSocketAddress ? UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)requestedRemoteAddress), (InetSocketAddress)this.socket.remoteAddress()) : requestedRemoteAddress;
            return true;
        }
        this.writeFilter(true);
        return false;
    }

    protected void doBind(SocketAddress local) throws Exception {
        if (local instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind(local);
        this.localAddress = this.fetchLocalAddress() ? this.socket.localAddress() : local;
    }

    protected boolean fetchLocalAddress() {
        return this.socket.protocolFamily() != SocketProtocolFamily.UNIX;
    }

    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        boolean connected;
        InetSocketAddress remoteSocketAddr;
        if (localAddress instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)localAddress);
        }
        InetSocketAddress inetSocketAddress = remoteSocketAddr = remoteAddress instanceof InetSocketAddress ? (InetSocketAddress)remoteAddress : null;
        if (remoteSocketAddr != null) {
            AbstractKQueueChannel.checkResolvable(remoteSocketAddr);
        }
        if (localAddress != null) {
            this.doBind(localAddress);
        }
        if (connected = this.doConnect0(remoteAddress, localAddress, initialData)) {
            this.active = true;
            SocketAddress socketAddress = this.remoteAddress = remoteSocketAddr == null ? remoteAddress : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)remoteSocketAddr, (InetSocketAddress)this.socket.remoteAddress());
        }
        if (this.fetchLocalAddress()) {
            this.localAddress = this.socket.localAddress();
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doConnect0(SocketAddress remoteAddress, SocketAddress localAddress, Buffer data) throws Exception {
        boolean success = false;
        try {
            boolean connected = this.socket.connect(remoteAddress);
            if (!connected) {
                this.writeFilter(true);
            }
            success = true;
            boolean bl = connected;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    protected final void doClearScheduledRead() {
        this.readFilter(false);
    }

    protected final void writeLoopComplete(boolean allWritten) {
        this.writeFilter(!allWritten);
        super.writeLoopComplete(allWritten);
    }

    final void closeTransportNow() {
        this.closeTransport(this.newPromise());
    }

    protected BufferAllocator readBufferAllocator() {
        return AbstractKQueueChannel.ioBufferAllocator(super.readBufferAllocator());
    }

    private BufferAllocator ioBufferAllocator() {
        return AbstractKQueueChannel.ioBufferAllocator(this.bufferAllocator());
    }

    private static BufferAllocator ioBufferAllocator(BufferAllocator alloc) {
        if (!alloc.getAllocationType().isDirect()) {
            return DefaultBufferAllocators.offHeapAllocator();
        }
        return alloc;
    }
}

