/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.unix;

import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.ComponentIterator;
import io.netty5.buffer.api.DefaultBufferAllocators;
import io.netty5.buffer.api.ReadableComponent;
import io.netty5.buffer.api.Resource;
import io.netty5.channel.unix.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    private final FileDescriptor fd;

    protected SocketWritableByteChannel(FileDescriptor fd) {
        this.fd = Objects.requireNonNull(fd, "fd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int write(ByteBuffer src) throws IOException {
        int written;
        int position = src.position();
        int limit = src.limit();
        if (src.isDirect()) {
            written = this.fd.write(src, position, src.limit());
        } else {
            int readableBytes = limit - position;
            BufferAllocator alloc = this.alloc();
            Buffer buffer = null;
            try {
                if (alloc.isPooling() && alloc.getAllocationType().isDirect()) {
                    buffer = alloc.allocate(readableBytes);
                } else {
                    buffer = BufferUtil.threadLocalDirectBuffer();
                    if (buffer == null) {
                        buffer = DefaultBufferAllocators.offHeapAllocator().allocate(readableBytes);
                    }
                }
                buffer.writeBytes(src.duplicate());
                try (ComponentIterator iterator = buffer.forEachReadable();){
                    ReadableComponent component = (ReadableComponent)iterator.first();
                    ByteBuffer nioBuffer = component.readableBuffer();
                    written = this.fd.write(nioBuffer, nioBuffer.position(), nioBuffer.limit());
                    assert (((ComponentIterator.Next)component).next() == null);
                }
            }
            catch (Throwable throwable) {
                Resource.dispose(buffer);
                throw throwable;
            }
            Resource.dispose((Object)buffer);
        }
        if (written > 0) {
            src.position(position + written);
        }
        return written;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.fd.close();
    }

    protected abstract BufferAllocator alloc();
}

