/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.unix;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.unix.Limits;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class UnixChannelUtil {
    private UnixChannelUtil() {
    }

    public static boolean isBufferCopyNeededForWrite(Buffer buffer) {
        return UnixChannelUtil.isBufferCopyNeededForWrite(buffer, Limits.IOV_MAX);
    }

    static boolean isBufferCopyNeededForWrite(Buffer buffer, int iovMax) {
        return !buffer.isDirect() || buffer.countReadableComponents() > iovMax;
    }

    public static InetSocketAddress computeRemoteAddr(InetSocketAddress remoteAddr, InetSocketAddress osRemoteAddr) {
        if (osRemoteAddr != null) {
            try {
                return new InetSocketAddress(InetAddress.getByAddress(remoteAddr.getHostString(), osRemoteAddr.getAddress().getAddress()), osRemoteAddr.getPort());
            }
            catch (UnknownHostException unknownHostException) {
                return osRemoteAddr;
            }
        }
        return remoteAddr;
    }
}

