/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.ServerChannelReadHandleFactory;
import io.netty5.channel.ServerChannelWriteHandleFactory;
import java.net.SocketAddress;

public abstract class AbstractServerChannel<P extends Channel, L extends SocketAddress, R extends SocketAddress>
extends AbstractChannel<P, L, R>
implements ServerChannel {
    private final EventLoopGroup childEventLoopGroup;

    protected AbstractServerChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, Class<? extends Channel> childChannelType) {
        super(null, eventLoop, false, new ServerChannelReadHandleFactory(), new ServerChannelWriteHandleFactory());
        this.childEventLoopGroup = AbstractServerChannel.validateEventLoopGroup(childEventLoopGroup, "childEventLoopGroup", childChannelType);
    }

    @Override
    public final EventLoopGroup childEventLoopGroup() {
        return this.childEventLoopGroup;
    }

    @Override
    protected final R remoteAddress0() {
        return null;
    }

    @Override
    protected final void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void doShutdown(ChannelShutdownDirection direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isActive();
    }

    @Override
    protected final void doWriteNow(AbstractChannel.WriteSink writeSink) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean doFinishConnect(R requestedRemoteAddress) {
        throw new UnsupportedOperationException();
    }
}

