/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.ChannelId;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.IoHandle;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.util.AttributeMap;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;

public interface Channel
extends AttributeMap,
ChannelOutboundInvoker,
Comparable<Channel>,
IoHandle {
    public ChannelId id();

    public EventLoop executor();

    public Channel parent();

    public <T> T getOption(ChannelOption<T> var1);

    public <T> Channel setOption(ChannelOption<T> var1, T var2);

    public boolean isOptionSupported(ChannelOption<?> var1);

    public boolean isOpen();

    public boolean isActive();

    public boolean isShutdown(ChannelShutdownDirection var1);

    public SocketAddress localAddress();

    public SocketAddress remoteAddress();

    public Future<Void> closeFuture();

    default public boolean isWritable() {
        return this.writableBytes() > 0L;
    }

    public long writableBytes();

    public ChannelPipeline pipeline();

    public BufferAllocator bufferAllocator();

    @Override
    default public Channel read(ReadBufferAllocator readBufferAllocator) {
        this.pipeline().read(readBufferAllocator);
        return this;
    }

    @Override
    default public Channel read() {
        this.pipeline().read();
        return this;
    }

    @Override
    default public Future<Void> bind(SocketAddress localAddress) {
        return this.pipeline().bind(localAddress);
    }

    @Override
    default public Future<Void> connect(SocketAddress remoteAddress) {
        return this.pipeline().connect(remoteAddress);
    }

    @Override
    default public Future<Void> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.pipeline().connect(remoteAddress, localAddress);
    }

    @Override
    default public Future<Void> disconnect() {
        return this.pipeline().disconnect();
    }

    @Override
    default public Future<Void> close() {
        return this.pipeline().close();
    }

    @Override
    default public Future<Void> shutdown(ChannelShutdownDirection direction) {
        return this.pipeline().shutdown(direction);
    }

    @Override
    default public Future<Void> register() {
        return this.pipeline().register();
    }

    @Override
    default public Future<Void> deregister() {
        return this.pipeline().deregister();
    }

    @Override
    default public Future<Void> write(Object msg) {
        return this.pipeline().write(msg);
    }

    @Override
    default public Future<Void> writeAndFlush(Object msg) {
        return this.pipeline().writeAndFlush(msg);
    }

    @Override
    default public Channel flush() {
        this.pipeline().flush();
        return this;
    }

    @Override
    default public Future<Void> sendOutboundEvent(Object event) {
        return this.pipeline().sendOutboundEvent(event);
    }
}

