/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;

public abstract class ChannelInitializer<C extends Channel>
implements ChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);

    @Override
    public boolean isSharable() {
        return true;
    }

    protected abstract void initChannel(C var1) throws Exception;

    @Override
    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (logger.isWarnEnabled()) {
            logger.warn("Failed to initialize a channel. Closing: " + ctx.channel(), cause);
        }
        ctx.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        try {
            this.initChannel(ctx.channel());
        }
        catch (Throwable cause) {
            this.channelExceptionCaught(ctx, cause);
        }
        finally {
            if (!ctx.isRemoved()) {
                ctx.pipeline().remove(this);
            }
        }
    }
}

