/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.AddressedEnvelope;
import io.netty5.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.Objects;

public class DefaultAddressedEnvelope<M, A extends SocketAddress>
implements AddressedEnvelope<M, A> {
    private final M message;
    private final A sender;
    private final A recipient;

    public DefaultAddressedEnvelope(M message, A recipient, A sender) {
        Objects.requireNonNull(message, "message");
        if (recipient == null && sender == null) {
            throw new NullPointerException("recipient and sender");
        }
        this.message = message;
        this.sender = sender;
        this.recipient = recipient;
    }

    public DefaultAddressedEnvelope(M message, A recipient) {
        this(message, recipient, null);
    }

    @Override
    public M content() {
        return this.message;
    }

    @Override
    public A sender() {
        return this.sender;
    }

    @Override
    public A recipient() {
        return this.recipient;
    }

    public String toString() {
        if (this.sender != null) {
            return StringUtil.simpleClassName((Object)this) + "(" + this.sender + " => " + this.recipient + ", " + this.message + ")";
        }
        return StringUtil.simpleClassName((Object)this) + "(=> " + this.recipient + ", " + this.message + ")";
    }
}

