/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelHandlerMask;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelPipelineException;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultChannelPipeline;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.channel.SingleThreadEventLoop;
import io.netty5.util.Resource;
import io.netty5.util.ResourceLeakHint;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectPool;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.ThrowableUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class DefaultChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelHandlerContext.class);
    private static final int INIT = 0;
    private static final int ADD_COMPLETE = 1;
    private static final int REMOVE_STARTED = 2;
    private static final int REMOVE_COMPLETE = 3;
    private final int executionMask;
    private final DefaultChannelPipeline pipeline;
    private final ChannelHandler handler;
    private final String name;
    private final DefaultChannelHandlerContextAwareEventExecutor executor;
    private long currentPendingBytes;
    private Tasks invokeTasks;
    private int handlerState = 0;
    private volatile boolean removed;
    DefaultChannelHandlerContext next;
    DefaultChannelHandlerContext prev;
    private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean((String)"io.netty5.transport.estimateSizeOnSubmit", (boolean)true);
    private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty5.transport.writeTaskSizeOverhead", (int)48);

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, String name, ChannelHandler handler) {
        this.name = Objects.requireNonNull(name, "name");
        this.pipeline = pipeline;
        this.executionMask = ChannelHandlerMask.mask(handler.getClass());
        this.handler = handler;
        this.executor = DefaultChannelHandlerContext.handlesPendingOutboundBytes(this.executionMask) ? new DefaultChannelHandlerContextAwareEventExecutor(pipeline.executor(), this) : null;
    }

    private static boolean handlesPendingOutboundBytes(int mask) {
        return (mask & 0x200000) != 0;
    }

    private static Future<Void> failRemoved(DefaultChannelHandlerContext ctx) {
        return ctx.newFailedFuture(DefaultChannelHandlerContext.newRemovedException(ctx, null));
    }

    private void notifyHandlerRemovedAlready() {
        this.notifyHandlerRemovedAlready(null);
    }

    private void notifyHandlerRemovedAlready(Throwable cause) {
        this.pipeline().fireChannelExceptionCaught(DefaultChannelHandlerContext.newRemovedException(this, cause));
    }

    private static ChannelPipelineException newRemovedException(ChannelHandlerContext ctx, Throwable cause) {
        return new ChannelPipelineException("Context " + ctx + " already removed", cause);
    }

    private Tasks invokeTasks() {
        Tasks tasks = this.invokeTasks;
        if (tasks == null) {
            this.invokeTasks = tasks = new Tasks(this);
        }
        return tasks;
    }

    @Override
    public EventExecutor executor() {
        return this.executor == null ? this.pipeline().executor() : this.executor;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public String name() {
        return this.name;
    }

    private EventExecutor originalExecutor() {
        return this.executor == null ? this.pipeline().executor() : this.executor.wrappedExecutor();
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelRegistered();
        } else {
            executor.execute(this::findAndInvokeChannelRegistered);
        }
        return this;
    }

    private void findAndInvokeChannelRegistered() {
        DefaultChannelHandlerContext ctx = this.findContextInbound(2);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelRegistered();
    }

    void invokeChannelRegistered() {
        try {
            if (!this.saveCurrentPendingBytesIfNeededInbound()) {
                return;
            }
            this.handler().channelRegistered(this);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelUnregistered();
        } else {
            executor.execute(this::findAndInvokeChannelUnregistered);
        }
        return this;
    }

    private void findAndInvokeChannelUnregistered() {
        DefaultChannelHandlerContext ctx = this.findContextInbound(4);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelUnregistered();
    }

    void invokeChannelUnregistered() {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelUnregistered(this);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelActive();
        } else {
            executor.execute(this::findAndInvokeChannelActive);
        }
        return this;
    }

    private void findAndInvokeChannelActive() {
        DefaultChannelHandlerContext ctx = this.findContextInbound(8);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelActive();
    }

    void invokeChannelActive() {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelActive(this);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelInactive();
        } else {
            executor.execute(this::findAndInvokeChannelInactive);
        }
        return this;
    }

    private void findAndInvokeChannelInactive() {
        DefaultChannelHandlerContext ctx = this.findContextInbound(16);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelInactive();
    }

    void invokeChannelInactive() {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelInactive(this);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelShutdown(ChannelShutdownDirection direction) {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelShutdown(direction);
        } else {
            executor.execute(() -> this.findAndInvokeChannelShutdown(direction));
        }
        return this;
    }

    private void findAndInvokeChannelShutdown(ChannelShutdownDirection direction) {
        DefaultChannelHandlerContext ctx = this.findContextInbound(32);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelShutdown(direction);
    }

    void invokeChannelShutdown(ChannelShutdownDirection direction) {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelShutdown(this, direction);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelExceptionCaught(Throwable cause) {
        block4: {
            Objects.requireNonNull(cause, "cause");
            EventExecutor executor = this.originalExecutor();
            if (executor.inEventLoop()) {
                this.findAndInvokeChannelExceptionCaught(cause);
            } else {
                try {
                    executor.execute(() -> this.findAndInvokeChannelExceptionCaught(cause));
                }
                catch (Throwable t) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to submit an exceptionCaught() event.", t);
                    logger.warn("The exceptionCaught() event that was failed to submit was:", cause);
                }
            }
        }
        return this;
    }

    private void findAndInvokeChannelExceptionCaught(Throwable cause) {
        DefaultChannelHandlerContext ctx = this.findContextInbound(1);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready(cause);
            return;
        }
        ctx.invokeChannelExceptionCaught(cause);
    }

    void invokeChannelExceptionCaught(Throwable cause) {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelExceptionCaught(this, cause);
        }
        catch (Throwable error) {
            if (logger.isDebugEnabled()) {
                logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString((Throwable)error), (Object)cause);
            } else if (logger.isWarnEnabled()) {
                logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)error, (Object)cause);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInboundEvent(Object event) {
        Objects.requireNonNull(event, "event");
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelInboundEvent(event);
        } else {
            executor.execute(() -> this.findAndInvokeChannelInboundEvent(event));
        }
        return this;
    }

    private void findAndInvokeChannelInboundEvent(Object event) {
        DefaultChannelHandlerContext ctx = this.findContextInbound(256);
        if (ctx == null) {
            Resource.dispose((Object)event);
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelInboundEvent(event);
    }

    void invokeChannelInboundEvent(Object event) {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            Resource.dispose((Object)event);
            return;
        }
        try {
            this.handler().channelInboundEvent(this, event);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        Objects.requireNonNull(msg, "msg");
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelRead(msg);
        } else {
            try {
                executor.execute(() -> this.findAndInvokeChannelRead(msg));
            }
            catch (Throwable cause) {
                Resource.dispose((Object)msg);
                throw cause;
            }
        }
        return this;
    }

    private void findAndInvokeChannelRead(Object msg) {
        DefaultChannelHandlerContext ctx = this.findContextInbound(64);
        if (ctx == null) {
            Resource.dispose((Object)msg);
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelRead(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeChannelRead(Object msg) {
        Object m = this.pipeline.touch(Objects.requireNonNull(msg, "msg"), this);
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            Resource.dispose((Object)m);
            return;
        }
        try {
            this.handler().channelRead(this, m);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelReadComplete();
        } else {
            Tasks tasks = this.invokeTasks();
            executor.execute(tasks.invokeChannelReadCompleteTask);
        }
        return this;
    }

    private void findAndInvokeChannelReadComplete() {
        DefaultChannelHandlerContext ctx = this.findContextInbound(128);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelReadComplete();
    }

    void invokeChannelReadComplete() {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelReadComplete(this);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeChannelWritabilityChanged();
        } else {
            Tasks tasks = this.invokeTasks();
            executor.execute(tasks.invokeChannelWritableStateChangedTask);
        }
        return this;
    }

    private void findAndInvokeChannelWritabilityChanged() {
        DefaultChannelHandlerContext ctx = this.findContextInbound(512);
        if (ctx == null) {
            this.notifyHandlerRemovedAlready();
            return;
        }
        ctx.invokeChannelWritabilityChanged();
    }

    void invokeChannelWritabilityChanged() {
        if (!this.saveCurrentPendingBytesIfNeededInbound()) {
            return;
        }
        try {
            this.handler().channelWritabilityChanged(this);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> bind(SocketAddress localAddress) {
        Objects.requireNonNull(localAddress, "localAddress");
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeBind(localAddress);
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeBind(localAddress).cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    @Override
    public Future<Void> connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, null);
    }

    @Override
    public Future<Void> deregister() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeDeregister();
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeDeregister().cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeBind(SocketAddress localAddress) {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(1024);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeBind(localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeBind(SocketAddress localAddress) {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().bind(this, localAddress);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeConnect(remoteAddress, localAddress);
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeConnect(remoteAddress, localAddress).cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeConnect(SocketAddress remoteAddress, SocketAddress localAddress) {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(2048);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeConnect(remoteAddress, localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeConnect(SocketAddress remoteAddress, SocketAddress localAddress) {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().connect(this, remoteAddress, localAddress);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> disconnect() {
        if (!this.pipeline.isTransportSupportingDisconnect()) {
            return this.close();
        }
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeDisconnect();
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeDisconnect().cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeDisconnect() {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(4096);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeDisconnect() {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().disconnect(this);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> close() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeClose();
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeClose().cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeClose() {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(8192);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeClose() {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().close(this);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, true);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> shutdown(ChannelShutdownDirection direction) {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeShutdown(direction);
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeShutdown(direction).cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeShutdown(ChannelShutdownDirection direction) {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(16384);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeShutdown(direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeShutdown(ChannelShutdownDirection direction) {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().shutdown(this, direction);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, true);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> register() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeRegister();
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeRegister().cascadeTo(promise), promise, null);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeRegister() {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(32768);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeRegister() {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().register(this);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    private Future<Void> findAndInvokeDeregister() {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(65536);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeDeregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeDeregister() {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return failed;
        }
        try {
            Future<Void> future = this.handler().deregister(this);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext read() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeRead(DefaultChannelPipeline.DEFAULT_READ_BUFFER_ALLOCATOR);
        } else {
            Tasks tasks = this.invokeTasks();
            executor.execute(tasks.invokeReadTask);
        }
        return this;
    }

    private void findAndInvokeRead() {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(131072);
        if (ctx != null) {
            ctx.invokeRead(DefaultChannelPipeline.DEFAULT_READ_BUFFER_ALLOCATOR);
        }
    }

    @Override
    public ChannelHandlerContext read(ReadBufferAllocator readBufferAllocator) {
        Objects.requireNonNull(readBufferAllocator, "");
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeRead(readBufferAllocator);
        } else {
            executor.execute(() -> this.findAndInvokeRead(readBufferAllocator));
        }
        return this;
    }

    private void findAndInvokeRead(ReadBufferAllocator allocator) {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(131072);
        if (ctx != null) {
            ctx.invokeRead(allocator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRead(ReadBufferAllocator allocator) {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return;
        }
        try {
            this.handler().read(this, allocator);
        }
        catch (Throwable t) {
            this.handleOutboundHandlerException(t, false);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> write(Object msg) {
        return this.write(msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeWrite(Object msg) {
        Object m = this.pipeline.touch(msg, this);
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            Resource.dispose((Object)m);
            return failed;
        }
        try {
            Future<Void> future = this.handler().write(this, m);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            this.findAndInvokeFlush();
        } else {
            Tasks tasks = this.invokeTasks();
            Promise promise = this.newPromise();
            promise.asFuture().addListener((Object)this.channel(), ChannelFutureListeners.FIRE_EXCEPTION_ON_FAILURE);
            DefaultChannelHandlerContext.safeExecute(executor, tasks.invokeFlushTask, promise, null);
        }
        return this;
    }

    private void findAndInvokeFlush() {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(524288);
        if (ctx != null) {
            ctx.invokeFlush();
        }
    }

    private void invokeFlush() {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            return;
        }
        try {
            this.handler().flush(this);
        }
        catch (Throwable t) {
            this.handleOutboundHandlerException(t, false);
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public Future<Void> writeAndFlush(Object msg) {
        return this.write(msg, true);
    }

    private Future<Void> invokeWriteAndFlush(Object msg) {
        Future<Void> f = this.invokeWrite(msg);
        this.invokeFlush();
        return f;
    }

    private Future<Void> write(Object msg, boolean flush) {
        Objects.requireNonNull(msg, "msg");
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            DefaultChannelHandlerContext next = this.findContextOutbound(flush ? 786432 : 262144);
            if (next == null) {
                Resource.dispose((Object)msg);
                return DefaultChannelHandlerContext.failRemoved(this);
            }
            if (flush) {
                return next.invokeWriteAndFlush(msg);
            }
            return next.invokeWrite(msg);
        }
        Promise promise = this.newPromise();
        AbstractWriteTask task = flush ? WriteAndFlushTask.newInstance(this, msg, promise) : WriteTask.newInstance(this, msg, promise);
        if (task != null && !DefaultChannelHandlerContext.safeExecute(executor, task, promise, msg)) {
            task.cancel();
        }
        return promise.asFuture();
    }

    @Override
    public Future<Void> sendOutboundEvent(Object event) {
        EventExecutor executor = this.originalExecutor();
        if (executor.inEventLoop()) {
            return this.findAndInvokeSendOutboundEvent(event);
        }
        Promise promise = this.newPromise();
        DefaultChannelHandlerContext.safeExecute(executor, () -> this.findAndInvokeSendOutboundEvent(event).cascadeTo(promise), promise, event);
        return promise.asFuture();
    }

    private Future<Void> findAndInvokeSendOutboundEvent(Object event) {
        DefaultChannelHandlerContext ctx = this.findContextOutbound(0x100000);
        if (ctx == null) {
            return DefaultChannelHandlerContext.failRemoved(this);
        }
        return ctx.invokeSendOutboundEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> invokeSendOutboundEvent(Object event) {
        Future<Void> failed = this.saveCurrentPendingBytesIfNeededOutbound();
        if (failed != null) {
            Resource.dispose((Object)event);
            return failed;
        }
        try {
            Future<Void> future = this.handler().sendOutboundEvent(this, event);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = this.handleOutboundHandlerException(t, false);
            return future;
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    private Future<Void> handleOutboundHandlerException(Throwable cause, boolean closeDidThrow) {
        String msg = this.handler() + " threw an exception while handling an outbound event. This is most likely a bug";
        logger.warn("{}. This is most likely a bug, closing the channel.", (Object)msg, (Object)cause);
        if (closeDidThrow) {
            this.close();
        } else {
            this.channel().close();
        }
        return this.newFailedFuture(new IllegalStateException(msg, cause));
    }

    private DefaultChannelHandlerContext findContextInbound(int mask) {
        DefaultChannelHandlerContext ctx = this;
        if (ctx.next == null) {
            return null;
        }
        do {
            ctx = ctx.next;
        } while ((ctx.executionMask & mask) == 0 || ctx.handlerState == 2);
        return ctx;
    }

    private DefaultChannelHandlerContext findContextOutbound(int mask) {
        DefaultChannelHandlerContext ctx = this;
        if (ctx.prev == null) {
            return null;
        }
        do {
            ctx = ctx.prev;
        } while ((ctx.executionMask & mask) == 0 || ctx.handlerState == 2);
        return ctx;
    }

    boolean setAddComplete() {
        if (this.handlerState == 0) {
            this.handlerState = 1;
            return true;
        }
        return false;
    }

    void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
            if (DefaultChannelHandlerContext.handlesPendingOutboundBytes(this.executionMask)) {
                long pending = this.pendingOutboundBytes();
                this.currentPendingBytes = -1L;
                if (pending > 0L) {
                    this.pipeline.incrementPendingOutboundBytes(pending);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandlerRemoved() throws Exception {
        block8: {
            try {
                if (this.handlerState != 1) break block8;
                this.handlerState = 2;
                try {
                    this.handler().handlerRemoved(this);
                }
                finally {
                    if (DefaultChannelHandlerContext.handlesPendingOutboundBytes(this.executionMask)) {
                        long pending = this.pendingOutboundBytes();
                        this.currentPendingBytes = -1L;
                        if (pending > 0L) {
                            this.pipeline.decrementPendingOutboundBytes(pending);
                        }
                    }
                }
            }
            finally {
                this.handlerState = 3;
                this.removed = true;
            }
        }
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    void remove(boolean relink) {
        assert (this.handlerState == 3);
        if (relink) {
            DefaultChannelHandlerContext prev = this.prev;
            DefaultChannelHandlerContext next = this.next;
            if (prev != null) {
                prev.next = next;
            }
            if (next != null) {
                next.prev = prev;
            }
        }
        this.prev = null;
        this.next = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean safeExecute(EventExecutor executor, Runnable runnable, Promise<Void> promise, Object msg) {
        try {
            executor.execute(runnable);
            return true;
        }
        catch (Throwable cause) {
            try {
                if (msg != null) {
                    Resource.dispose((Object)msg);
                }
            }
            finally {
                if (promise != null) {
                    promise.setFailure(cause);
                }
            }
            return false;
        }
    }

    public String toHintString() {
        return "'" + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + "(" + this.name + ", " + this.channel() + ")";
    }

    private boolean saveCurrentPendingBytesIfNeededInbound() {
        IllegalStateException e = this.saveCurrentPendingBytesIfNeeded();
        if (e != null) {
            logger.error((Throwable)e);
            return false;
        }
        return true;
    }

    private Future<Void> saveCurrentPendingBytesIfNeededOutbound() {
        IllegalStateException e = this.saveCurrentPendingBytesIfNeeded();
        if (e != null) {
            logger.error((Throwable)e);
            return this.newFailedFuture(e);
        }
        return null;
    }

    private IllegalStateException saveCurrentPendingBytesIfNeeded() {
        if (!DefaultChannelHandlerContext.handlesPendingOutboundBytes(this.executionMask)) {
            assert (this.currentPendingBytes == 0L);
            return null;
        }
        if (this.currentPendingBytes == -1L) {
            try {
                this.currentPendingBytes = this.pendingOutboundBytes();
            }
            catch (IllegalStateException e) {
                return e;
            }
        }
        return null;
    }

    private long pendingOutboundBytes() {
        long pending = this.handler().pendingOutboundBytes(this);
        if (pending < 0L) {
            this.pipeline.forceCloseTransport();
            String message = StringUtil.simpleClassName(this.handler.getClass()) + ".pendingOutboundBytes(ChannelHandlerContext) returned a negative value: " + pending + ". Force closed transport.";
            throw new IllegalStateException(message);
        }
        return pending;
    }

    private void updatePendingBytesIfNeeded() {
        if (!DefaultChannelHandlerContext.handlesPendingOutboundBytes(this.executionMask)) {
            assert (this.currentPendingBytes == 0L);
            return;
        }
        long current = this.currentPendingBytes;
        if (current == -1L) {
            return;
        }
        this.currentPendingBytes = -1L;
        try {
            long newPendingBytes = this.pendingOutboundBytes();
            long delta = current - newPendingBytes;
            if (delta == 0L) {
                return;
            }
            if (delta > 0L) {
                this.pipeline.decrementPendingOutboundBytes(delta);
            } else {
                this.pipeline.incrementPendingOutboundBytes(-delta);
            }
        }
        catch (IllegalStateException e) {
            logger.error((Throwable)e);
        }
    }

    private static final class DefaultChannelHandlerContextAwareEventExecutor
    implements EventExecutor {
        private final EventExecutor executor;
        private final DefaultChannelHandlerContext ctx;

        DefaultChannelHandlerContextAwareEventExecutor(EventExecutor executor, DefaultChannelHandlerContext ctx) {
            this.executor = executor;
            this.ctx = ctx;
        }

        EventExecutor wrappedExecutor() {
            return this.executor;
        }

        public boolean inEventLoop() {
            return this.executor.inEventLoop();
        }

        public boolean inEventLoop(Thread thread) {
            return this.executor.inEventLoop(thread);
        }

        public boolean isShuttingDown() {
            return this.executor.isShuttingDown();
        }

        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        public Future<Void> shutdownGracefully() {
            return this.executor.shutdownGracefully();
        }

        public Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            return this.executor.shutdownGracefully(quietPeriod, timeout, unit);
        }

        public Future<Void> terminationFuture() {
            return this.executor.terminationFuture();
        }

        public Future<Void> submit(Runnable task) {
            return this.executor.submit((Runnable)new DefaultHandlerContextRunnable(task));
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit((Runnable)new DefaultHandlerContextRunnable(task), result);
        }

        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(new DefaultHandlerContextCallable<T>(task));
        }

        public Future<Void> schedule(Runnable task, long delay, TimeUnit unit) {
            return this.executor.schedule((Runnable)new DefaultHandlerContextRunnable(task), delay, unit);
        }

        public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
            return this.executor.schedule(new DefaultHandlerContextCallable<V>(task), delay, unit);
        }

        public Future<Void> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return this.executor.scheduleAtFixedRate((Runnable)new DefaultHandlerContextRunnable(task), initialDelay, period, unit);
        }

        public Future<Void> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return this.executor.scheduleWithFixedDelay((Runnable)new DefaultHandlerContextRunnable(task), initialDelay, delay, unit);
        }

        public void execute(Runnable task) {
            this.executor.execute((Runnable)new DefaultHandlerContextRunnable(task));
        }

        private final class DefaultHandlerContextRunnable
        implements Runnable {
            private final Runnable task;

            DefaultHandlerContextRunnable(Runnable task) {
                this.task = task;
            }

            @Override
            public void run() {
                IllegalStateException e = DefaultChannelHandlerContextAwareEventExecutor.this.ctx.saveCurrentPendingBytesIfNeeded();
                try {
                    this.task.run();
                    if (e != null) {
                        logger.error((Throwable)e);
                        throw e;
                    }
                }
                finally {
                    if (e == null) {
                        DefaultChannelHandlerContextAwareEventExecutor.this.ctx.updatePendingBytesIfNeeded();
                    }
                }
            }
        }

        private final class DefaultHandlerContextCallable<V>
        implements Callable<V> {
            private final Callable<V> task;

            DefaultHandlerContextCallable(Callable<V> task) {
                this.task = task;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                IllegalStateException e = DefaultChannelHandlerContextAwareEventExecutor.this.ctx.saveCurrentPendingBytesIfNeeded();
                try {
                    V v;
                    block8: {
                        V value = null;
                        try {
                            v = value = (V)this.task.call();
                            if (e == null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (e != null) {
                                Resource.dispose(value);
                                logger.error((Throwable)e);
                                throw e;
                            }
                            throw throwable;
                        }
                        Resource.dispose(value);
                        logger.error((Throwable)e);
                        throw e;
                    }
                    return v;
                }
                finally {
                    if (e == null) {
                        DefaultChannelHandlerContextAwareEventExecutor.this.ctx.updatePendingBytesIfNeeded();
                    }
                }
            }
        }
    }

    private static final class Tasks {
        private final Runnable invokeChannelReadCompleteTask = () -> ctx.findAndInvokeChannelReadComplete();
        private final Runnable invokeReadTask = () -> ctx.findAndInvokeRead();
        private final Runnable invokeChannelWritableStateChangedTask = ctx::invokeChannelWritabilityChanged;
        private final Runnable invokeFlushTask = () -> ctx.findAndInvokeFlush();

        Tasks(DefaultChannelHandlerContext ctx) {
        }
    }

    static final class WriteAndFlushTask
    extends AbstractWriteTask {
        private static final ObjectPool<WriteAndFlushTask> RECYCLER = ObjectPool.newPool(WriteAndFlushTask::new);

        static WriteAndFlushTask newInstance(DefaultChannelHandlerContext ctx, Object msg, Promise<Void> promise) {
            WriteAndFlushTask task = (WriteAndFlushTask)RECYCLER.get();
            if (!WriteAndFlushTask.init(task, ctx, msg, promise)) {
                return null;
            }
            return task;
        }

        private WriteAndFlushTask(ObjectPool.Handle<WriteAndFlushTask> handle) {
            super(handle);
        }

        @Override
        protected DefaultChannelHandlerContext findContext(DefaultChannelHandlerContext ctx) {
            return ctx.findContextOutbound(786432);
        }

        @Override
        public void write(DefaultChannelHandlerContext ctx, Object msg, Promise<Void> promise) {
            super.write(ctx, msg, promise);
            ctx.invokeFlush();
        }
    }

    static final class WriteTask
    extends AbstractWriteTask
    implements SingleThreadEventLoop.NonWakeupRunnable {
        private static final ObjectPool<WriteTask> RECYCLER = ObjectPool.newPool(WriteTask::new);

        static WriteTask newInstance(DefaultChannelHandlerContext ctx, Object msg, Promise<Void> promise) {
            WriteTask task = (WriteTask)RECYCLER.get();
            if (!WriteTask.init(task, ctx, msg, promise)) {
                return null;
            }
            return task;
        }

        @Override
        protected DefaultChannelHandlerContext findContext(DefaultChannelHandlerContext ctx) {
            return ctx.findContextOutbound(262144);
        }

        private WriteTask(ObjectPool.Handle<WriteTask> handle) {
            super(handle);
        }
    }

    static abstract class AbstractWriteTask
    implements Runnable {
        private final ObjectPool.Handle<AbstractWriteTask> handle;
        private DefaultChannelHandlerContext ctx;
        private Object msg;
        private Promise<Void> promise;
        private int size;

        private AbstractWriteTask(ObjectPool.Handle<? extends AbstractWriteTask> handle) {
            this.handle = handle;
        }

        protected static boolean init(AbstractWriteTask task, DefaultChannelHandlerContext ctx, Object msg, Promise<Void> promise) {
            task.ctx = ctx;
            task.msg = msg;
            task.promise = promise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                task.size = ctx.pipeline.estimatorHandle().size(msg) + WRITE_TASK_OVERHEAD;
                try {
                    ctx.pipeline.incrementPendingOutboundBytes(task.size);
                }
                catch (IllegalStateException e) {
                    task.recycle();
                    Resource.dispose((Object)msg);
                    promise.setFailure((Throwable)e);
                    return false;
                }
            } else {
                task.size = 0;
            }
            return true;
        }

        protected abstract DefaultChannelHandlerContext findContext(DefaultChannelHandlerContext var1);

        @Override
        public final void run() {
            try {
                this.decrementPendingOutboundBytes();
                if (this.promise.isCancelled()) {
                    Resource.dispose((Object)this.msg);
                    return;
                }
                DefaultChannelHandlerContext next = this.findContext(this.ctx);
                if (next == null) {
                    Resource.dispose((Object)this.msg);
                    DefaultChannelHandlerContext.failRemoved(this.ctx).cascadeTo(this.promise);
                    return;
                }
                this.write(next, this.msg, this.promise);
            }
            finally {
                this.recycle();
            }
        }

        void cancel() {
            try {
                this.decrementPendingOutboundBytes();
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle((Object)this);
        }

        protected void write(DefaultChannelHandlerContext ctx, Object msg, Promise<Void> promise) {
            ctx.invokeWrite(msg).cascadeTo(promise);
        }
    }
}

