/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.EventLoop;
import io.netty5.util.internal.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class ReflectiveChannelFactory<T extends Channel>
implements ChannelFactory<T> {
    private final Constructor<? extends T> constructor;

    public ReflectiveChannelFactory(Class<? extends T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        try {
            this.constructor = clazz.getConstructor(EventLoop.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + StringUtil.simpleClassName(clazz) + " does not have a public constructor that takes an EventLoop instance", e);
        }
    }

    @Override
    public T newChannel(EventLoop eventLoop) throws Exception {
        try {
            return (T)((Channel)this.constructor.newInstance(eventLoop));
        }
        catch (Throwable t) {
            throw new ChannelException("Unable to create Channel from class " + this.constructor.getDeclaringClass(), t);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(ReflectiveChannelFactory.class) + "(" + StringUtil.simpleClassName(this.constructor.getDeclaringClass()) + ".class)";
    }
}

