/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.Resource;
import io.netty5.util.internal.TypeParameterMatcher;

public abstract class SimpleUserEventChannelHandler<I>
implements ChannelHandler {
    private final TypeParameterMatcher matcher;
    private final boolean autoRelease;

    protected SimpleUserEventChannelHandler() {
        this(true);
    }

    protected SimpleUserEventChannelHandler(boolean autoRelease) {
        this.matcher = TypeParameterMatcher.find((Object)this, SimpleUserEventChannelHandler.class, (String)"I");
        this.autoRelease = autoRelease;
    }

    protected SimpleUserEventChannelHandler(Class<? extends I> eventType) {
        this(eventType, true);
    }

    protected SimpleUserEventChannelHandler(Class<? extends I> eventType, boolean autoRelease) {
        this.matcher = TypeParameterMatcher.get(eventType);
        this.autoRelease = autoRelease;
    }

    protected boolean acceptEvent(Object evt) throws Exception {
        return this.matcher.match(evt);
    }

    @Override
    public final void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        boolean release = true;
        try {
            if (this.acceptEvent(evt)) {
                Object ievt = evt;
                this.eventReceived(ctx, ievt);
            } else {
                release = false;
                ctx.fireChannelInboundEvent(evt);
            }
        }
        finally {
            if (this.autoRelease && release) {
                Resource.dispose((Object)evt);
            }
        }
    }

    protected abstract void eventReceived(ChannelHandlerContext var1, I var2) throws Exception;
}

