/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.local;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannelRegistry;
import io.netty5.channel.local.LocalChannelUnsafe;
import io.netty5.channel.local.LocalServerChannel;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.ReferenceCounted;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LocalChannel
extends AbstractChannel<LocalServerChannel, LocalAddress, LocalAddress>
implements LocalChannelUnsafe {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalChannel.class);
    private static final AtomicReferenceFieldUpdater<LocalChannel, Future> FINISH_READ_FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LocalChannel.class, Future.class, "finishReadFuture");
    private static final int MAX_READER_STACK_DEPTH = 8;
    final Queue<Object> inboundBuffer = PlatformDependent.newSpscQueue();
    private final Runnable readNowTask = () -> {
        if (!this.inboundBuffer.isEmpty()) {
            this.readNow();
        }
    };
    private volatile State state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile boolean readInProgress;
    private volatile boolean writeInProgress;
    private volatile Future<?> finishReadFuture;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private static final FastThreadLocal<ReaderStackDepth> STACK_DEPTH = new FastThreadLocal<ReaderStackDepth>(){

        protected ReaderStackDepth initialValue() throws Exception {
            return new ReaderStackDepth();
        }
    };

    public LocalChannel(EventLoop eventLoop) {
        this(null, eventLoop, null);
    }

    protected LocalChannel(LocalServerChannel parent, EventLoop eventLoop, LocalChannel peer) {
        super(parent, eventLoop, false);
        this.peer = peer;
        if (parent != null) {
            this.localAddress = (LocalAddress)parent.localAddress();
        }
        if (peer != null) {
            this.remoteAddress = (LocalAddress)peer.localAddress();
        }
        this.setOption(ChannelOption.BUFFER_ALLOCATOR, DefaultBufferAllocators.onHeapAllocator());
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.CONNECTED;
    }

    @Override
    protected LocalAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected LocalAddress remoteAddress0() {
        return this.remoteAddress;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, localAddress);
        this.state = State.BOUND;
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) {
        switch (direction) {
            case Inbound: {
                this.inputShutdown = true;
                break;
            }
            case Outbound: {
                this.outputShutdown = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Inbound: {
                return this.inputShutdown;
            }
            case Outbound: {
                return this.outputShutdown;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        block12: {
            LocalChannel peer = this.peer;
            State oldState = this.state;
            try {
                if (oldState != State.CLOSED) {
                    if (this.localAddress != null) {
                        if (this.parent() == null) {
                            LocalChannelRegistry.unregister(this.localAddress);
                        }
                        this.localAddress = null;
                    }
                    this.state = State.CLOSED;
                    if (this.writeInProgress && peer != null) {
                        this.finishPeerRead(peer);
                    }
                }
                if (peer == null) break block12;
                this.peer = null;
                EventLoop peerEventLoop = peer.executor();
                boolean peerIsActive = peer.isActive();
                try {
                    peerEventLoop.execute(() -> peer.tryClose(peerIsActive));
                }
                catch (Throwable cause) {
                    logger.warn("Releasing Inbound Queues for channels {}-{} because exception occurred!", new Object[]{this, peer, cause});
                    if (peerEventLoop.inEventLoop()) {
                        peer.releaseInboundBuffers();
                    } else {
                        peer.close();
                    }
                    throw cause;
                }
            }
            finally {
                if (oldState != null && oldState != State.CLOSED) {
                    this.releaseInboundBuffers();
                }
            }
        }
    }

    private void tryClose(boolean isActive) {
        if (!isActive) {
            this.releaseInboundBuffers();
        }
        this.closeTransport((Promise<Void>)this.newPromise());
    }

    @Override
    protected boolean doReadNow(AbstractChannel.ReadSink readSink) {
        Object received = this.inboundBuffer.poll();
        readSink.processRead(0, 0, received);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(boolean wasReadPendingAlready) throws Exception {
        if (this.readInProgress) {
            return;
        }
        Queue<Object> inboundBuffer = this.inboundBuffer;
        if (inboundBuffer.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        ReaderStackDepth readerStackDepth = (ReaderStackDepth)STACK_DEPTH.get();
        if (readerStackDepth.incrementIfPossible()) {
            try {
                this.readNow();
            }
            finally {
                readerStackDepth.decrement();
            }
        }
        try {
            this.executor().execute(this.readNowTask);
        }
        catch (Throwable cause) {
            logger.warn("Closing Local channels {}-{} because exception occurred!", new Object[]{this, this.peer, cause});
            this.close();
            this.peer.close();
            throw cause;
        }
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        switch (this.state) {
            case OPEN: 
            case BOUND: {
                throw new NotYetConnectedException();
            }
            case CLOSED: {
                throw new ClosedChannelException();
            }
        }
        LocalChannel peer = this.peer;
        this.writeInProgress = true;
        Object msg = writeSink.currentFlushedMessage();
        if (peer.state == State.CONNECTED) {
            if (msg instanceof ReferenceCounted) {
                peer.inboundBuffer.add(ReferenceCountUtil.retain((Object)msg));
            } else if (msg instanceof ResourceSupport) {
                peer.inboundBuffer.add(InternalBufferUtils.acquire((ResourceSupport)((ResourceSupport)msg)));
            } else if (msg instanceof Resource) {
                peer.inboundBuffer.add(((Resource)msg).send().receive());
            } else {
                peer.inboundBuffer.add(msg);
            }
            writeSink.complete(0L, 0L, 1, true);
        } else {
            writeSink.complete(0L, 0L, 0, false);
        }
    }

    @Override
    protected void writeLoopComplete(boolean allWritten) {
        try {
            this.writeInProgress = false;
            this.finishPeerRead(this.peer);
        }
        finally {
            super.writeLoopComplete(allWritten);
        }
    }

    private void finishPeerRead(LocalChannel peer) {
        if (peer.executor() == this.executor() && !peer.writeInProgress) {
            this.finishPeerRead0(peer);
        } else {
            this.runFinishPeerReadTask(peer);
        }
    }

    private void runFinishPeerReadTask(LocalChannel peer) {
        Runnable finishPeerReadTask = () -> this.finishPeerRead0(peer);
        try {
            if (peer.writeInProgress) {
                peer.finishReadFuture = peer.executor().submit(finishPeerReadTask);
            } else {
                peer.executor().execute(finishPeerReadTask);
            }
        }
        catch (Throwable cause) {
            logger.warn("Closing Local channels {}-{} because exception occurred!", new Object[]{this, peer, cause});
            this.close();
            peer.close();
            throw cause;
        }
    }

    private void releaseInboundBuffers() {
        Object msg;
        assert (this.executor() == null || this.executor().inEventLoop());
        this.readInProgress = false;
        Queue<Object> inboundBuffer = this.inboundBuffer;
        while ((msg = inboundBuffer.poll()) != null) {
            Resource.dispose((Object)msg);
        }
    }

    private void finishPeerRead0(LocalChannel peer) {
        Future<?> peerFinishReadFuture = peer.finishReadFuture;
        if (peerFinishReadFuture != null) {
            if (!peerFinishReadFuture.isDone()) {
                this.runFinishPeerReadTask(peer);
                return;
            }
            FINISH_READ_FUTURE_UPDATER.compareAndSet(peer, peerFinishReadFuture, null);
        }
        if (peer.readInProgress && !peer.inboundBuffer.isEmpty()) {
            peer.readInProgress = false;
            peer.readNow();
        }
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        Channel boundChannel;
        if (this.state == State.CONNECTED) {
            throw new AlreadyConnectedException();
        }
        if (this.state != State.BOUND && localAddress == null) {
            localAddress = new LocalAddress(this);
        }
        if (localAddress != null) {
            try {
                this.doBind(localAddress);
            }
            catch (Throwable t) {
                this.closeTransport((Promise<Void>)this.newPromise());
                throw t;
            }
        }
        if (!((boundChannel = LocalChannelRegistry.get(remoteAddress)) instanceof LocalServerChannel)) {
            ConnectException cause = new ConnectException("connection refused: " + remoteAddress);
            this.closeTransport((Promise<Void>)this.newPromise());
            throw cause;
        }
        LocalServerChannel serverChannel = (LocalServerChannel)boundChannel;
        this.peer = serverChannel.serve(this);
        return false;
    }

    @Override
    protected boolean doFinishConnect(LocalAddress requestedRemoteAddress) throws Exception {
        LocalChannel peer = this.peer;
        if (peer == null) {
            return false;
        }
        this.state = State.CONNECTED;
        this.remoteAddress = (LocalAddress)((LocalServerChannel)peer.parent()).localAddress();
        peer.writeFlushedAsync();
        return true;
    }

    private void writeFlushedAsync() {
        this.executor().execute(this::writeFlushed);
    }

    private void finishConnectAsync() {
        this.executor().execute(() -> {
            if (this.isConnectPending()) {
                this.finishConnect();
            }
        });
    }

    @Override
    public void registerTransportNow() {
        LocalChannel peer = this.peer;
        if (this.parent() != null && peer != null) {
            this.state = State.CONNECTED;
            peer.finishConnectAsync();
        }
    }

    @Override
    public void deregisterTransportNow() {
    }

    @Override
    public void closeTransportNow() {
        this.closeTransport((Promise<Void>)this.newPromise());
    }

    private static final class ReaderStackDepth {
        private int stackDepth;

        private ReaderStackDepth() {
        }

        boolean incrementIfPossible() {
            if (this.stackDepth == 8) {
                return false;
            }
            ++this.stackDepth;
            return true;
        }

        void decrement() {
            --this.stackDepth;
        }
    }

    private static enum State {
        OPEN,
        BOUND,
        CONNECTED,
        CLOSED;

    }
}

