/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.nio;

import io.netty5.channel.IoHandle;
import io.netty5.channel.nio.NioProcessor;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class NioSelectableChannelHandle<S extends SelectableChannel>
implements IoHandle {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSelectableChannelHandle.class);
    private final S channel;
    private final int interestOps;
    private volatile SelectionKey selectionKey;
    private final BiConsumer<S, SelectionKey> keyProcessor;
    private final NioProcessor nioProcessor = new NioProcessor(){

        @Override
        public void register(Selector selector) throws ClosedChannelException {
            int interestOps;
            SelectionKey key = NioSelectableChannelHandle.this.selectionKey;
            if (key != null) {
                interestOps = key.interestOps();
                key.cancel();
            } else {
                interestOps = NioSelectableChannelHandle.this.interestOps;
            }
            NioSelectableChannelHandle.this.selectionKey = ((SelectableChannel)NioSelectableChannelHandle.this.channel).register(selector, interestOps, this);
        }

        @Override
        public void deregister() {
            SelectionKey key = NioSelectableChannelHandle.this.selectionKey;
            if (key != null) {
                key.cancel();
            }
        }

        @Override
        public void handle(SelectionKey key) {
            NioSelectableChannelHandle.this.keyProcessor.accept(NioSelectableChannelHandle.this.channel, key);
        }

        @Override
        public void close() {
            try {
                ((AbstractInterruptibleChannel)NioSelectableChannelHandle.this.channel).close();
            }
            catch (IOException e) {
                logger.warn("Unexpected exception while closing underlying channel", (Throwable)e);
            }
        }
    };

    public NioSelectableChannelHandle(S channel, int interestOps, BiConsumer<S, SelectionKey> keyProcessor) {
        if ((interestOps & ~((SelectableChannel)channel).validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + interestOps + "(validOps: " + ((SelectableChannel)channel).validOps() + ")");
        }
        this.channel = (SelectableChannel)Objects.requireNonNull(channel, "channel");
        this.interestOps = interestOps;
        this.keyProcessor = Objects.requireNonNull(keyProcessor, "keyProcessor");
    }

    @Override
    public boolean isRegistered() {
        return ((SelectableChannel)this.channel).isRegistered();
    }

    NioProcessor nioProcessor() {
        return this.nioProcessor;
    }
}

