/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.channel.socket.DomainSocketAddress;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Path;

final class NioChannelUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioChannelUtil.class);
    private static final MethodHandle OF_METHOD_HANDLE;
    private static final MethodHandle GET_PATH_METHOD_HANDLE;

    static boolean isDomainSocket(ProtocolFamily family) {
        if (family instanceof StandardProtocolFamily) {
            return "UNIX".equals(family.name());
        }
        if (family instanceof SocketProtocolFamily) {
            return family == SocketProtocolFamily.UNIX;
        }
        return false;
    }

    static SocketAddress toDomainSocketAddress(SocketAddress address) {
        if (GET_PATH_METHOD_HANDLE != null) {
            try {
                Path path = GET_PATH_METHOD_HANDLE.invoke(address);
                return new DomainSocketAddress(path.toFile());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable cause) {
                return null;
            }
        }
        return address;
    }

    static SocketAddress toUnixDomainSocketAddress(SocketAddress address) {
        if (OF_METHOD_HANDLE != null && address instanceof DomainSocketAddress) {
            try {
                return OF_METHOD_HANDLE.invoke(((DomainSocketAddress)address).path());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable cause) {
                return null;
            }
        }
        return address;
    }

    static Method findOpenMethod(String methodName) {
        if (PlatformDependent.javaVersion() >= 15) {
            try {
                return SelectorProvider.class.getMethod(methodName, ProtocolFamily.class);
            }
            catch (Throwable e) {
                logger.debug("SelectorProvider.{}(ProtocolFamily) not available, will use default", (Object)methodName, (Object)e);
            }
        }
        return null;
    }

    static <C extends Channel> C newChannel(Method method, SelectorProvider provider, ProtocolFamily family) throws IOException {
        if (family != null && method != null) {
            try {
                Channel channel = (Channel)method.invoke((Object)provider, family);
                return (C)channel;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    static ProtocolFamily toJdkFamily(ProtocolFamily family) {
        if (family instanceof SocketProtocolFamily) {
            return ((SocketProtocolFamily)family).toJdkFamily();
        }
        return family;
    }

    private NioChannelUtil() {
    }

    static {
        MethodHandle ofMethodHandle = null;
        MethodHandle getPathMethodHandle = null;
        if (PlatformDependent.javaVersion() >= 16) {
            try {
                Class<?> clazz = Class.forName("java.net.UnixDomainSocketAddress", false, PlatformDependent.getClassLoader(NioChannelUtil.class));
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType type = MethodType.methodType(clazz, String.class);
                ofMethodHandle = lookup.findStatic(clazz, "of", type);
                type = MethodType.methodType(Path.class);
                getPathMethodHandle = lookup.findVirtual(clazz, "getPath", type);
            }
            catch (ClassNotFoundException t) {
                ofMethodHandle = null;
                getPathMethodHandle = null;
                logger.debug("java.net.UnixDomainSocketAddress not found", (Throwable)t);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                ofMethodHandle = null;
                getPathMethodHandle = null;
                logger.debug("Could not access methods of java.net.UnixDomainSocketAddress", (Throwable)e);
            }
        }
        OF_METHOD_HANDLE = ofMethodHandle;
        GET_PATH_METHOD_HANDLE = getPathMethodHandle;
    }
}

