/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl;

import capsule.org.apache.http.HttpResponse;
import capsule.org.apache.http.HttpResponseFactory;
import capsule.org.apache.http.ReasonPhraseCatalog;
import capsule.org.apache.http.StatusLine;
import capsule.org.apache.http.impl.EnglishReasonPhraseCatalog;
import capsule.org.apache.http.message.BasicHttpResponse;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.util.Args;
import java.util.Locale;

public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

