/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.protocol;

import capsule.org.apache.http.HttpEntity;
import capsule.org.apache.http.HttpEntityEnclosingRequest;
import capsule.org.apache.http.HttpException;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.HttpRequestInterceptor;
import capsule.org.apache.http.HttpVersion;
import capsule.org.apache.http.ProtocolVersion;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.util.Args;
import java.io.IOException;

public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

