/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model;

import capsule.org.apache.maven.model.InputLocationTracker;
import capsule.org.apache.maven.model.InputSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class InputLocation
implements InputLocationTracker,
Serializable,
Cloneable {
    private int lineNumber = -1;
    private int columnNumber = -1;
    private InputSource source;
    private Map<Object, InputLocation> locations;

    public InputLocation(int lineNumber, int columnNumber, InputSource source) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source;
    }

    public InputLocation clone() {
        try {
            InputLocation copy = (InputLocation)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Map<Object, InputLocation> getLocations() {
        return this.locations;
    }

    public InputSource getSource() {
        return this.source;
    }

    public static InputLocation merge(InputLocation target, InputLocation source, boolean sourceDominant) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        InputLocation result = new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, InputLocation> sourceLocations = source.getLocations();
        Map<Object, InputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            locations.putAll(sourceDominant ? targetLocations : sourceLocations);
            locations.putAll(sourceDominant ? sourceLocations : targetLocations);
        }
        result.setLocations(locations);
        return result;
    }

    public static InputLocation merge(InputLocation target, InputLocation source, Collection<Integer> indices) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        InputLocation result = new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, InputLocation> sourceLocations = source.getLocations();
        Map<Object, InputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            for (Integer index : indices) {
                InputLocation location = index < 0 ? sourceLocations.get(~index.intValue()) : targetLocations.get(index);
                locations.put(locations.size(), location);
            }
        }
        result.setLocations(locations);
        return result;
    }

    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setLocations(Map<Object, InputLocation> locations) {
        this.locations = locations;
    }

    public String toString() {
        return this.getLineNumber() + " : " + this.getColumnNumber() + ", " + this.getSource();
    }
}

