/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import com.sun.management.OperatingSystemMXBean;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import nextflow.file.FileHelper;
import nextflow.util.Duration;
import nextflow.util.MemoryUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysHelper
implements GroovyObject {
    private static String DATE_FORMAT;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static final Closure memoizedMethodClosure$getSystemMXBean;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public SysHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String fmtDate(long dateInMillis, TimeZone tz) {
        return SysHelper.fmtDate(new Date(dateInMillis), tz);
    }

    public static String fmtDate(Date date, TimeZone tz) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        if (DefaultTypeTransformation.booleanUnbox((Object)tz)) {
            formatter.setTimeZone(tz);
        }
        return formatter.format(date);
    }

    public static String getUptimeText() throws IllegalStateException {
        Process proc = new ProcessBuilder("uptime").start();
        int status = proc.waitFor();
        if (status == 0) {
            return ProcessGroovyMethods.getText((Process)proc).trim();
        }
        throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{status}, new String[]{"Unable to run system `uptime` command: exit=", ""})));
    }

    public static Duration getUptimeDuration() {
        Object v0;
        String text = SysHelper.getUptimeText();
        Duration result = SysHelper.parseUptimeText(text);
        if (log.isTraceEnabled()) {
            log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result, text}, new String[]{"Uptime ", " -- parsed text: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return result;
    }

    public static long getBootTimeMillis() {
        return System.currentTimeMillis() - SysHelper.getUptimeDuration().toMillis();
    }

    public static String getBootTimeString() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(SysHelper.getBootTimeMillis()));
    }

    static Duration parseUptimeText(String str) throws IllegalArgumentException {
        int p = str.indexOf(" up ");
        List items = StringGroovyMethods.tokenize((CharSequence)str.substring(p + 4), (CharSequence)",");
        String uptime = ((String)DefaultGroovyMethods.getAt((List)items, (int)0)).trim().replace("mins", "min").replace("hrs", "hour");
        if (uptime.contains(":")) {
            String string;
            uptime = string = SysHelper.reformatHourAndMin(uptime);
        } else if (items.size() > 1 && ((String)DefaultGroovyMethods.getAt((List)items, (int)1)).contains(":")) {
            String string;
            uptime = string = StringGroovyMethods.plus((String)uptime, (CharSequence)new GStringImpl(new Object[]{SysHelper.reformatHourAndMin(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)items, (int)1)))}, new String[]{" ", ""}));
        }
        Duration duration = Duration.of(uptime);
        try {
            return duration;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid uptime text: `", "`"})), e);
        }
    }

    private static String reformatHourAndMin(String text) {
        List items = StringGroovyMethods.tokenize((CharSequence)text, (CharSequence)":");
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.getAt((List)items, (int)0), DefaultGroovyMethods.getAt((List)items, (int)1)}, new String[]{"", "h ", "m"}));
    }

    public static MemoryUnit getAvailDisk() {
        long free = FileHelper.getLocalTempPath().toFile().getFreeSpace();
        return new MemoryUnit(free);
    }

    private static OperatingSystemMXBean getSystemMXBean() {
        return (OperatingSystemMXBean)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$getSystemMXBean.call(), OperatingSystemMXBean.class);
    }

    public static int getAvailCpus() {
        int result = SysHelper.getSystemMXBean().getAvailableProcessors();
        return result;
    }

    public static MemoryUnit getAvailMemory() {
        return new MemoryUnit(SysHelper.getSystemMXBean().getTotalPhysicalMemorySize());
    }

    public static String getHostName() {
        String string = System.getenv("HOSTNAME");
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : InetAddress.getLocalHost().getHostName();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SysHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    private static OperatingSystemMXBean memoizedMethodPriv$getSystemMXBean() {
        return (OperatingSystemMXBean)ScriptBytecodeAdapter.castToType((Object)ManagementFactory.getOperatingSystemMXBean(), OperatingSystemMXBean.class);
    }

    @Generated
    public static String fmtDate(long dateInMillis) {
        return SysHelper.fmtDate(dateInMillis, null);
    }

    @Generated
    public static String fmtDate(Date date) {
        return SysHelper.fmtDate(date, null);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Closure closure;
        Logger logger;
        String string;
        DATE_FORMAT = string = "dd-MMM-yyyy HH:mm";
        log = logger = LoggerFactory.getLogger((String)"nextflow.util.SysHelper");
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return SysHelper.memoizedMethodPriv$getSystemMXBean();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$getSystemMXBean = closure = new __clinit__closure1(SysHelper.class, SysHelper.class).memoize();
    }
}

