/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.file.FileHolder;
import nextflow.util.Bag;
import nextflow.util.CacheFunnel;
import nextflow.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHelper {
    private static final Logger log = LoggerFactory.getLogger(CacheHelper.class);
    private static HashFunction DEFAULT_HASHING = Hashing.murmur3_128();
    private static int HASH_BITS = DEFAULT_HASHING.bits();
    private static int HASH_BYTES = HASH_BITS / 8;
    private static final Map<String, Object> FIRST_ONLY = new HashMap<String, Object>(1);

    public static HashFunction defaultHasher() {
        return DEFAULT_HASHING;
    }

    public static Hasher hasher(Object value) {
        return CacheHelper.hasher(value, HashMode.STANDARD);
    }

    public static Hasher hasher(Object value, HashMode mode) {
        return CacheHelper.hasher(DEFAULT_HASHING, value, mode);
    }

    public static Hasher hasher(HashFunction function, Object value, HashMode mode) {
        return CacheHelper.hasher(function.newHasher(), value, mode);
    }

    public static Hasher hasher(Hasher hasher, Object value, HashMode mode) {
        if (value == null) {
            return hasher;
        }
        if (value instanceof Boolean) {
            return hasher.putBoolean(((Boolean)value).booleanValue());
        }
        if (value instanceof Short) {
            return hasher.putShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return hasher.putInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return hasher.putLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return hasher.putFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return hasher.putDouble(((Double)value).doubleValue());
        }
        if (value instanceof Byte) {
            return hasher.putByte(((Byte)value).byteValue());
        }
        if (value instanceof Number) {
            return hasher.putUnencodedChars((CharSequence)value.toString());
        }
        if (value instanceof Character) {
            return hasher.putChar(((Character)value).charValue());
        }
        if (value instanceof CharSequence) {
            return hasher.putUnencodedChars((CharSequence)value);
        }
        if (value instanceof byte[]) {
            return hasher.putBytes((byte[])value);
        }
        if (value instanceof Object[]) {
            for (Object item : (Object[])value) {
                hasher = CacheHelper.hasher(hasher, item, mode);
            }
            return hasher;
        }
        if (value instanceof Map) {
            for (Object item : ((Map)value).values()) {
                hasher = CacheHelper.hasher(hasher, item, mode);
            }
            return hasher;
        }
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            hasher = CacheHelper.hasher(hasher, entry.getKey(), mode);
            hasher = CacheHelper.hasher(hasher, entry.getValue(), mode);
            return hasher;
        }
        if (value instanceof Bag || value instanceof Set) {
            return CacheHelper.hashUnorderedCollection(hasher, (Collection)value, mode);
        }
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                hasher = CacheHelper.hasher(hasher, item, mode);
            }
            return hasher;
        }
        if (value instanceof FileHolder) {
            return CacheHelper.hasher(hasher, ((FileHolder)value).getSourceObj(), mode);
        }
        if (value instanceof Path) {
            return CacheHelper.hashFile(hasher, (Path)value, mode);
        }
        if (value instanceof File) {
            return CacheHelper.hashFile(hasher, (File)value, mode);
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return hasher.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        }
        if (value instanceof VersionNumber) {
            return hasher.putInt(value.hashCode());
        }
        if (value instanceof CacheFunnel) {
            return ((CacheFunnel)value).funnel(hasher, mode);
        }
        Bolts.debug1(log, FIRST_ONLY, "[WARN] Unknown hashing type: " + value.getClass());
        return hasher.putInt(value.hashCode());
    }

    private static Hasher hashFile(Hasher hasher, File file, HashMode mode) {
        return CacheHelper.hashFile(hasher, file.toPath(), mode);
    }

    private static Hasher hashFile(Hasher hasher, Path path, HashMode mode) {
        BasicFileAttributes attrs = null;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            log.debug("Unable to get file attributes file: {} -- Cause: {}", (Object)FilesEx.toUriString(path), (Object)e.toString());
        }
        catch (ProviderMismatchException e) {
            log.warn("File system is unable to get file attributes file: {} -- Cause: {}", (Object)FilesEx.toUriString(path), (Object)e.toString());
        }
        if (mode == HashMode.DEEP && attrs != null && attrs.isRegularFile()) {
            return CacheHelper.hashFileContent(hasher, path);
        }
        return CacheHelper.hashFileMetadata(hasher, path, attrs, mode);
    }

    private static Hasher hashFileMetadata(Hasher hasher, Path file, BasicFileAttributes attrs, HashMode mode) {
        hasher = hasher.putUnencodedChars((CharSequence)file.toAbsolutePath().toString());
        if (attrs != null) {
            hasher = hasher.putLong(attrs.size());
            if (attrs.lastModifiedTime() != null && mode != HashMode.LENIENT) {
                hasher = hasher.putLong(attrs.lastModifiedTime().toMillis());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Hashing file meta: path={}; size={}, lastModified={}, mode={}", new Object[]{file.toAbsolutePath().toString(), attrs != null ? Long.valueOf(attrs.size()) : "--", attrs != null && attrs.lastModifiedTime() != null && mode != HashMode.LENIENT ? Long.valueOf(attrs.lastModifiedTime().toMillis()) : "--", mode});
        }
        return hasher;
    }

    private static Hasher hashFileContent(Hasher hasher, Path path) {
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        try {
            Files.copy(path, output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to hash content: " + path, e);
        }
        finally {
            FilesEx.closeQuietly(output);
        }
        return hasher;
    }

    static HashCode hashContent(Path file) {
        return CacheHelper.hashContent(file, null);
    }

    static HashCode hashContent(Path file, HashFunction function) {
        if (function == null) {
            function = DEFAULT_HASHING;
        }
        Hasher hasher = function.newHasher();
        return CacheHelper.hashFileContent(hasher, file).hash();
    }

    private static Hasher hashUnorderedCollection(Hasher hasher, Collection collection, HashMode mode) {
        byte[] resultBytes = new byte[HASH_BYTES];
        for (Object item : collection) {
            byte[] nextBytes = CacheHelper.hasher(item, mode).hash().asBytes();
            if (nextBytes.length != resultBytes.length) {
                throw new IllegalStateException("All hash codes must have the same bit length");
            }
            for (int i = 0; i < nextBytes.length; ++i) {
                int n = i;
                resultBytes[n] = (byte)(resultBytes[n] + nextBytes[i]);
            }
        }
        return hasher.putBytes(resultBytes);
    }

    static {
        FIRST_ONLY.put("firstOnly", Boolean.TRUE);
    }

    public static enum HashMode {
        STANDARD,
        DEEP,
        LENIENT;


        public static HashMode of(Object obj) {
            if (obj == null || obj instanceof Boolean) {
                return null;
            }
            if (obj instanceof CharSequence) {
                if ("true".equals(obj) || "false".equals(obj)) {
                    return null;
                }
                if ("standard".equals(obj)) {
                    return STANDARD;
                }
                if ("lenient".equals(obj)) {
                    return LENIENT;
                }
                if ("deep".equals(obj)) {
                    return DEEP;
                }
            }
            log.warn("Unknown cache mode: {}", (Object)obj.toString());
            return null;
        }
    }
}

