/*
 * Decompiled with CFR 0.152.
 */
package nextflow.io;

import java.io.IOException;
import java.io.InputStream;

public class SkipLinesInputStream
extends InputStream {
    private static final int LF = 10;
    private static final int CR = 13;
    private InputStream target;
    private int skip;
    private int buffer = -1;
    private int count;
    private StringBuilder header;

    public SkipLinesInputStream(InputStream inputStream, int skip) {
        this.target = inputStream;
        this.skip = skip;
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Skip operation is not supported by " + this.getClass().getName());
    }

    @Override
    public int read() throws IOException {
        while (this.count < this.skip) {
            int ch = this.read0();
            if (ch != -1) continue;
            return -1;
        }
        return this.read0();
    }

    private int read0() throws IOException {
        if (this.buffer != -1) {
            int result = this.buffer;
            this.buffer = -1;
            return result;
        }
        int ch = this.target.read();
        if (this.header != null && this.count < this.skip && ch != -1) {
            this.header.append((char)ch);
        }
        if (ch == 10) {
            ++this.count;
        } else if (ch == 13) {
            ++this.count;
            int next = this.target.read();
            if (next == 10) {
                if (this.header != null) {
                    this.header.append((char)next);
                }
            } else {
                this.buffer = next;
                if (this.header != null && this.count < this.skip && next != -1) {
                    this.header.append((char)next);
                }
            }
        }
        return ch;
    }

    public String consumeHeader() throws IOException {
        this.header = new StringBuilder();
        while (this.count < this.skip && this.read0() != -1) {
        }
        return this.header.toString();
    }

    public String getHeader() {
        return this.header != null ? this.header.toString() : null;
    }
}

