/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import com.google.common.util.concurrent.RateLimiter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.List;
import java.util.regex.Matcher;
import nextflow.util.Duration;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;

@EqualsAndHashCode(includeFields=true, includes={"rate"})
public class RateUnit
implements GroovyObject {
    private static String RATE_FORMAT;
    private double rate;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public RateUnit(double rate) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!(!(rate <= 0.0))) {
            StringBuffer stringBuffer = new StringBuffer("(rate > 0). Values: ");
            stringBuffer.append((Object)"rate = ");
            stringBuffer.append(InvokerHelper.toString((Object)rate));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Rate unit must be greater than zero");
        }
        double d = rate;
        this.rate = d;
    }

    public RateUnit(String str) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        double d = this.parse(str);
        this.rate = d;
    }

    public static RateUnit of(String str) {
        return new RateUnit(str);
    }

    public double getRate() {
        return this.rate;
    }

    public RateLimiter getRateLimiter() {
        return RateLimiter.create((double)this.rate);
    }

    protected double parse(String limit) {
        List tokens = StringGroovyMethods.tokenize((CharSequence)limit, (CharSequence)"/");
        if (tokens.size() == 2) {
            String X = ((String)DefaultGroovyMethods.getAt((List)tokens, (int)0)).trim();
            String Y = ((String)DefaultGroovyMethods.getAt((List)tokens, (int)1)).trim();
            return this.parse0(X, Y, limit);
        }
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)limit, (Object)RATE_FORMAT), Matcher.class);
        if (!matcher.matches()) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{limit}, new String[]{"Invalid submit-rate-limit value: ", " -- It must be provide using the following format `num request sec|min|hour` eg. 10 sec ie. max 10 tasks per second"})));
        }
        String string = matcher.group(1);
        String num = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "_";
        String string2 = matcher.group(2);
        String unit = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "sec";
        return this.parse0(num, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{unit}, new String[]{"1 ", ""})), limit);
    }

    private double parse0(String X, String Y, String limit) {
        if (!StringGroovyMethods.isInteger((CharSequence)X)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{limit}, new String[]{"Invalid submit-rate-limit value: ", " -- It must be provide using the following format `num request / duration` eg. 10/1s"})));
        }
        int num = Integer.parseInt(X);
        Duration duration = StringGroovyMethods.isInteger((CharSequence)Y) ? Duration.of(StringGroovyMethods.plus((String)Y, (CharSequence)"sec")) : (StringGroovyMethods.isInteger((CharSequence)StringGroovyMethods.getAt((String)Y, (int)0)) ? Duration.of(Y) : Duration.of(StringGroovyMethods.plus((String)"1", (CharSequence)Y)));
        long seconds = duration.toSeconds();
        if (!(seconds != 0L)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{limit}, new String[]{"Invalid submit-rate-limit value: ", " -- The interval must be at least 1 second"})));
        }
        return DefaultTypeTransformation.doubleUnbox((Object)ScriptBytecodeAdapter.asType((Object)NumberNumberDiv.div((Number)num, (Number)seconds), Double.TYPE));
    }

    public String toString() {
        return StringGroovyMethods.plus((String)String.format("%.2f", this.rate), (CharSequence)"/sec");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RateUnit.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.rate, (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (double)this.rate);
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof RateUnit;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RateUnit)) {
            return false;
        }
        RateUnit otherTyped = (RateUnit)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!(this.rate == otherTyped.getRate())) {
            return false;
        }
        if (!(Double.valueOf(this.rate) == Double.valueOf(otherTyped.getRate()))) {
            if (Double.valueOf(this.rate) == this && !(Double.valueOf(otherTyped.getRate()) == otherTyped) || !(Double.valueOf(this.rate) == this) && Double.valueOf(otherTyped.getRate()) == otherTyped) {
                return false;
            }
            if (!(Double.valueOf(this.rate) == this && Double.valueOf(otherTyped.getRate()) == otherTyped) && !(this.rate == otherTyped.getRate())) {
                return false;
            }
        }
        return true;
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(\\d+\\.?\\d*)\\s*([a-zA-Z]*)");
        RATE_FORMAT = ShortTypeHandling.castToString((Object)object);
    }
}

