/*
 * Decompiled with CFR 0.152.
 */
package nextflow.plugin;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nextflow.plugin.CustomPluginManager;
import nextflow.plugin.LocalPluginRepository;
import nextflow.plugin.PluginSpec;
import org.apache.groovy.nio.extensions.NioExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.pf4j.DefaultPluginLoader;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPluginManager
extends CustomPluginManager {
    private Path repository;
    private List<PluginSpec> specs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public LocalPluginManager(Path localRoot, Path repository, List<PluginSpec> specs) {
        super(localRoot);
        Path path;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)localRoot)) {
            throw (Throwable)new IllegalArgumentException("Missing Local plugins root directory");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)repository)) {
            throw (Throwable)new IllegalArgumentException("Missing plugins repository directory");
        }
        this.repository = path = repository;
        List<PluginSpec> list = specs;
        this.specs = list;
    }

    protected Path getLocalRoot() {
        return this.getPluginsRoot();
    }

    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return new ManifestPluginDescriptorFinder();
    }

    protected PluginLoader createPluginLoader() {
        return new DefaultPluginLoader((PluginManager)this);
    }

    protected PluginRepository createPluginRepository() {
        return new LocalPluginRepository(this.getLocalRoot());
    }

    public void loadPlugins() {
        PluginSpec it = null;
        Iterator<PluginSpec> iterator = this.specs.iterator();
        while (iterator.hasNext()) {
            it = (PluginSpec)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PluginSpec.class);
            this.linkPlugin(it);
        }
        super.loadPlugins();
    }

    protected void linkPlugin(PluginSpec spec) {
        if (DefaultTypeTransformation.booleanUnbox((Object)spec.getVersion())) {
            GStringImpl name = new GStringImpl(new Object[]{spec.getId(), spec.getVersion()}, new String[]{"", "-", ""});
            if (Files.exists(this.repository.resolve(ShortTypeHandling.castToString((Object)name)), new LinkOption[0]) && !Files.exists(this.getLocalRoot().resolve(ShortTypeHandling.castToString((Object)name)), new LinkOption[0])) {
                Path link = this.createLinkFromPath(this.repository.resolve(ShortTypeHandling.castToString((Object)name)));
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{spec, link}, new String[]{"Plugin ", " resolved to ", ""})));
            }
        } else {
            List<Path> avail = this.findPlugins(spec.getId(), this.repository);
            List<Path> exist = this.findPlugins(spec.getId(), this.getLocalRoot());
            if (DefaultTypeTransformation.booleanUnbox(avail) && !DefaultTypeTransformation.booleanUnbox(exist)) {
                Path link = this.createLinkFromPath((Path)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(avail, (int)0), Path.class));
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{spec, link}, new String[]{"Plugin ", " resolved to ", ""})));
            }
        }
    }

    protected List<Path> findPlugins(String name, Path repo) {
        Reference name2 = new Reference((Object)name);
        Reference result = new Reference(new ArrayList());
        public final class _findPlugins_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findPlugins_closure1(Object _outerInstance, Object _thisObject, Reference name, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.result = reference = result;
            }

            public Boolean doCall(Object it) {
                if (((Path)it).getFileName().toString().startsWith(ShortTypeHandling.castToString((Object)this.name.get()))) {
                    return ((ArrayList)this.result.get()).add(it);
                }
                return (Boolean)ScriptBytecodeAdapter.castToType(null, Boolean.class);
            }

            @Generated
            public String getName() {
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            @Generated
            public Object getResult() {
                return this.result.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findPlugins_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        NioExtensions.eachDir((Path)repo, (Closure)new _findPlugins_closure1((Object)this, (Object)this, name2, result));
        return DefaultGroovyMethods.sort((Iterable)((ArrayList)result.get()));
    }

    public String loadPlugin(Path pluginPath) {
        Path symlink = this.createLinkFromPath(pluginPath);
        return super.loadPlugin(symlink);
    }

    @Override
    public PluginWrapper loadPluginFromPath(Path pluginPath) {
        Path symlink = this.createLinkFromPath(pluginPath);
        return super.loadPluginFromPath(symlink);
    }

    private Path createLinkFromPath(Path pluginPath) {
        if (pluginPath.startsWith(this.getLocalRoot())) {
            return pluginPath;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)pluginPath)) {
            throw (Throwable)new IllegalArgumentException("Plugin path cannot be null");
        }
        if (!Files.isDirectory(pluginPath, new LinkOption[0])) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginPath}, new String[]{"Plugin path must be a directory: ", ""})));
        }
        Path symlink = this.getLocalRoot().resolve(pluginPath.getFileName());
        this.createLink0(symlink, pluginPath);
        return symlink;
    }

    private void createLink0(Path symlink, Path pluginPath) {
        try {
            log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{symlink, pluginPath}, new String[]{"Creating local plugins root link: ", " \u2192 ", ""})));
            Files.createSymbolicLink(symlink, pluginPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{symlink}, new String[]{"Deleting existing local plugins root link: ", ""})));
            if (!this.sameTarget(symlink, pluginPath)) {
                Files.delete(symlink);
                Files.createSymbolicLink(symlink, pluginPath, new FileAttribute[0]);
            }
        }
    }

    private boolean sameTarget(Path link, Path target) {
        boolean bl = ScriptBytecodeAdapter.compareEqual((Object)Files.readSymbolicLink(link), (Object)target);
        try {
            return bl;
        }
        catch (IOException e) {
            boolean bl2 = false;
            return bl2;
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LocalPluginManager.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.plugin.LocalPluginManager");
    }

    @Generated
    public List<PluginSpec> getSpecs() {
        return this.specs;
    }

    @Generated
    public void setSpecs(List<PluginSpec> list) {
        this.specs = list;
    }
}

