/*
 * Decompiled with CFR 0.152.
 */
package nextflow.plugin;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.plugin.CustomPluginManager;
import nextflow.plugin.DefaultPlugins;
import nextflow.plugin.DevPluginManager;
import nextflow.plugin.DevPluginUpdater;
import nextflow.plugin.LocalPluginManager;
import nextflow.plugin.PluginSpec;
import nextflow.plugin.PluginUpdater;
import nextflow.plugin.Plugins;
import nextflow.plugin.Priority;
import nextflow.plugin.Scoped;
import nextflow.util.CacheHelper;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginStateListener;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsFacade
implements PluginStateListener,
GroovyObject {
    private Path PLUGINS_LOCAL_ROOT;
    private static final String DEV_MODE = "dev";
    private static final String PROD_MODE = "prod";
    private Map<String, String> env;
    private String mode;
    private Path root;
    private PluginUpdater updater;
    private CustomPluginManager manager;
    private DefaultPlugins defaultPlugins;
    private String indexUrl;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private final Closure memoizedMethodClosure$defaultManager;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public PluginsFacade() {
        DefaultPlugins defaultPlugins;
        Path path;
        String string;
        Closure closure;
        MetaClass metaClass;
        String string2;
        Path path2;
        this.PLUGINS_LOCAL_ROOT = path2 = Paths.get(".nextflow/plr", new String[0]);
        HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
        this.env = hashMap;
        this.indexUrl = string2 = Plugins.DEFAULT_PLUGINS_REPO;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.memoizedMethodClosure$defaultManager = closure = new _closure1(this, this).memoize();
        this.mode = string = this.getPluginsMode();
        this.root = path = this.getPluginsDir();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.mode, (Object)DEV_MODE) && ScriptBytecodeAdapter.compareEqual((Object)this.root.toString(), (Object)"plugins")) {
            Path path3;
            this.root = path3 = this.detectDevPluginsRoot();
        }
        System.setProperty("pf4j.mode", this.mode);
        this.defaultPlugins = defaultPlugins = new DefaultPlugins();
    }

    public PluginsFacade(Path root, String mode) {
        DefaultPlugins defaultPlugins;
        Path path;
        String string;
        Closure closure;
        MetaClass metaClass;
        String string2;
        Path path2;
        this.PLUGINS_LOCAL_ROOT = path2 = Paths.get(".nextflow/plr", new String[0]);
        HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
        this.env = hashMap;
        this.indexUrl = string2 = Plugins.DEFAULT_PLUGINS_REPO;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.memoizedMethodClosure$defaultManager = closure = new _closure1(this, this).memoize();
        this.mode = string = mode;
        this.root = path = root;
        System.setProperty("pf4j.mode", mode);
        this.defaultPlugins = defaultPlugins = new DefaultPlugins();
    }

    @Generated
    public PluginsFacade(Path root) {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        this(root, PROD_MODE);
    }

    protected Path getPluginsDir() {
        String dir = ShortTypeHandling.castToString((Object)this.env.get("NXF_PLUGINS_DIR"));
        if (DefaultTypeTransformation.booleanUnbox((Object)dir)) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"Detected NXF_PLUGINS_DIR=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return Paths.get(dir, new String[0]);
        }
        if (this.env.containsKey("NXF_HOME")) {
            Object v1;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.env.get("NXF_HOME")}, new String[]{"Detected NXF_HOME - Using ", "/plugins"})));
                v1 = null;
            } else {
                v1 = null;
            }
            return Paths.get(ShortTypeHandling.castToString((Object)this.env.get("NXF_HOME")), "plugins");
        }
        log.trace("Using local plugins directory");
        return Paths.get("plugins", new String[0]);
    }

    protected Path detectDevPluginsRoot() {
        File file = new File(".").getAbsoluteFile();
        do {
            File file2;
            if (ScriptBytecodeAdapter.compareEqual((Object)file.getName(), (Object)"nextflow") && file.isDirectory() && new File(file, "settings.gradle").isFile()) {
                Object v0;
                Path root = file.toPath().resolve("plugins");
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{root}, new String[]{"Detected dev plugins root: ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                return root;
            }
            file = file2 = file.getParentFile();
        } while (file != null);
        throw (Throwable)new IllegalStateException("Unable to detect local plugins root");
    }

    protected String getPluginsMode() {
        String mode = ShortTypeHandling.castToString((Object)this.env.get("NXF_PLUGINS_MODE"));
        if (DefaultTypeTransformation.booleanUnbox((Object)mode)) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mode}, new String[]{"Detected NXF_PLUGINS_MODE=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return mode;
        }
        if (this.env.containsKey("NXF_HOME")) {
            log.trace("Detected NXF_HOME - Using plugins mode=prod");
            return PROD_MODE;
        }
        log.trace("Using dev plugins mode");
        return DEV_MODE;
    }

    protected boolean getPluginsDefault() {
        if (this.env.containsKey("NXF_PLUGINS_DEFAULT")) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.env.get("NXF_PLUGINS_DEFAULT")}, new String[]{"Detected NXF_PLUGINS_DEFAULT=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return ScriptBytecodeAdapter.compareNotEqual((Object)this.env.get("NXF_PLUGINS_DEFAULT"), (Object)"false");
        }
        if (this.env.containsKey("NXF_HOME")) {
            log.trace("Detected NXF_HOME - Using plugins defaults");
            return true;
        }
        log.trace("Disabling plugins defaults");
        return false;
    }

    protected void init(Path root, List<PluginSpec> specs) {
        PluginUpdater pluginUpdater;
        CustomPluginManager customPluginManager;
        this.manager = customPluginManager = this.createManager(root, specs);
        this.updater = pluginUpdater = this.createUpdater(root, this.manager);
    }

    protected Path localRoot(List<PluginSpec> specs) {
        Object v0;
        String unique = DefaultTypeTransformation.booleanUnbox(specs) ? CacheHelper.hasher(specs).hash().toString() : "empty";
        Path localRoot = this.PLUGINS_LOCAL_ROOT.resolve(unique);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{localRoot}, new String[]{"Plugins local root: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        FilesEx.mkdirs(localRoot, new FileAttribute[0]);
        return localRoot;
    }

    protected CustomPluginManager createManager(Path root, List<PluginSpec> specs) {
        Path localRoot = this.localRoot(specs);
        CustomPluginManager result = ScriptBytecodeAdapter.compareNotEqual((Object)this.mode, (Object)DEV_MODE) ? new LocalPluginManager(localRoot, root, specs) : new DevPluginManager(root);
        result.addPluginStateListener(this);
        return result;
    }

    protected PluginUpdater createUpdater(Path root, CustomPluginManager manager) {
        return ScriptBytecodeAdapter.compareNotEqual((Object)this.mode, (Object)DEV_MODE) ? new PluginUpdater(manager, root, new URL(this.indexUrl)) : new DevPluginUpdater(manager);
    }

    public void pluginStateChanged(PluginStateEvent ev) {
        Throwable err = ev.getPlugin().getFailedException();
        PluginDescriptor dsc = ev.getPlugin().getDescriptor();
        if (DefaultTypeTransformation.booleanUnbox((Object)err)) {
            String string;
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dsc.getPluginId(), dsc.getVersion(), DefaultTypeTransformation.booleanUnbox((Object)(string = err.getMessage())) ? string : err}, new String[]{"Unable to start plugin id=", " version=", " -- cause: ", ""})), err);
        }
    }

    public PluginManager getManager() {
        return this.manager;
    }

    public synchronized void setup(Map config) {
        Object v0;
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            throw (Throwable)new IllegalArgumentException("Plugin system was already setup");
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.mode, this.root}, new String[]{"Setting up plugin manager > mode=", "; plugins-dir=", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.mode, (Object)DEV_MODE) && !FilesEx.mkdirs(this.root, new FileAttribute[0])) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.root}, new String[]{"Unable to create plugins dir: ", ""})));
        }
        List<PluginSpec> specs = this.pluginsRequirement(config);
        this.init(this.root, specs);
        this.manager.loadPlugins();
        this.start(specs);
    }

    public synchronized void stop() {
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            this.manager.stopPlugins();
            Object var1_1 = null;
            this.manager = (CustomPluginManager)((Object)ScriptBytecodeAdapter.castToType(var1_1, CustomPluginManager.class));
        }
    }

    public <T> List<T> getExtensions(Class<T> type) {
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            return this.manager.getExtensions(type);
        }
        log.debug("Using Default plugins manager");
        return this.defaultManager().getExtensions(type);
    }

    public <T> List<T> getPriorityExtensions(Class<T> type, String group) {
        Reference group2 = new Reference((Object)group);
        List result = this.getExtensions(type);
        if (DefaultTypeTransformation.booleanUnbox((Object)((String)group2.get()))) {
            List list;
            public final class _getPriorityExtensions_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference group;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getPriorityExtensions_closure2(Object _outerInstance, Object _thisObject, Reference group) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.group = reference = group;
                }

                public Boolean doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"group0", (Object)new Object[]{it}), (Object)this.group.get());
                }

                @Generated
                public String getGroup() {
                    return ShortTypeHandling.castToString((Object)this.group.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getPriorityExtensions_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            result = list = DefaultGroovyMethods.findAll(result, (Closure)new _getPriorityExtensions_closure2(this, this, group2));
        }
        public final class _getPriorityExtensions_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getPriorityExtensions_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(Object it) {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"priority0", (Object)new Object[]{it}), Integer.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPriorityExtensions_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.sort(result, (Closure)new _getPriorityExtensions_closure3(this, this));
    }

    protected int priority0(Object it) {
        Priority annot = (Priority)ScriptBytecodeAdapter.castToType((Object)it.getClass().getAnnotation(Priority.class), Priority.class);
        return DefaultTypeTransformation.booleanUnbox((Object)annot) ? annot.value() : 0;
    }

    protected int priority1(Object it) {
        Scoped annot = (Scoped)ScriptBytecodeAdapter.castToType((Object)it.getClass().getAnnotation(Scoped.class), Scoped.class);
        return DefaultTypeTransformation.booleanUnbox((Object)annot) ? annot.priority() : 0;
    }

    public <T> Set<T> getScopedExtensions(Class<T> type, String scope) {
        public final class _getScopedExtensions_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getScopedExtensions_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(Object it) {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"priority1", (Object)new Object[]{it}), Integer.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getScopedExtensions_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List result = DefaultGroovyMethods.sort(this.getExtensions(type), (Closure)new _getScopedExtensions_closure4(this, this));
        HashMap<String, Object> groups = new HashMap<String, Object>();
        Object it2 = null;
        for (Object it2 : result) {
            Scoped annot = (Scoped)ScriptBytecodeAdapter.castToType((Object)it2.getClass().getAnnotation(Scoped.class), Scoped.class);
            if (annot == null || !DefaultTypeTransformation.booleanUnbox((Object)annot.value()) || groups.containsKey(annot.value()) || !(scope == null || ScriptBytecodeAdapter.compareEqual((Object)annot.value(), (Object)scope))) continue;
            groups.put(annot.value(), it2);
        }
        return new HashSet(groups.values());
    }

    protected String group0(Object it) {
        Priority annot = (Priority)ScriptBytecodeAdapter.castToType((Object)it.getClass().getAnnotation(Priority.class), Priority.class);
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)annot) && DefaultTypeTransformation.booleanUnbox((Object)annot.group()) ? annot.group() : null));
    }

    private PluginManager defaultManager() {
        return (PluginManager)ScriptBytecodeAdapter.castToType((Object)this.memoizedMethodClosure$defaultManager.call(), PluginManager.class);
    }

    public void start(String pluginId) {
        if (this.isSelfContained() && this.defaultPlugins.hasPlugin(pluginId)) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId}, new String[]{"Plugin 'start' is not required in self-contained mode -- ignoring it for plugin: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        this.start(this.defaultPlugins.getPlugin(pluginId));
    }

    public void start(PluginSpec plugin) {
        if (this.isSelfContained() && this.defaultPlugins.hasPlugin(plugin.getId())) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{plugin.getId()}, new String[]{"Plugin 'start' is not required in self-contained mode -- ignoring it for plugin: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        this.updater.prepareAndStart(plugin.getId(), plugin.getVersion());
    }

    public void start(List<PluginSpec> specs) {
        PluginSpec it = null;
        Iterator<PluginSpec> iterator = specs.iterator();
        while (iterator.hasNext()) {
            it = (PluginSpec)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PluginSpec.class);
            this.start(it);
        }
    }

    public boolean isStarted(String pluginId) {
        PluginWrapper pluginWrapper = this.manager.getPlugin(pluginId);
        return ScriptBytecodeAdapter.compareEqual((Object)(pluginWrapper != null ? pluginWrapper.getPluginState() : null), (Object)PluginState.STARTED);
    }

    protected boolean isSelfContained() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.env.get("NXF_PACK"), (Object)"all");
    }

    protected List<PluginSpec> pluginsRequirement(Map config) {
        List<PluginSpec> specs = this.parseConf(config);
        if (this.isSelfContained() && DefaultTypeTransformation.booleanUnbox(specs)) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join(specs, (String)",")}, new String[]{"Nextflow self-contained distribution only allows default plugins -- User config plugins will be ignored: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return Collections.emptyList();
        }
        if (DefaultTypeTransformation.booleanUnbox(specs)) {
            Object v1;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{specs}, new String[]{"Plugins declared=", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
        } else if (this.getPluginsDefault()) {
            Object v2;
            List<PluginSpec> list = this.defaultPluginsConf(config);
            specs = list;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{specs}, new String[]{"Plugins default=", ""})));
                v2 = null;
            } else {
                v2 = null;
            }
        }
        public final class _pluginsRequirement_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _pluginsRequirement_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((PluginSpec)it).getId(), (Object)"tower");
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _pluginsRequirement_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if ((config.containsKey("tower") || DefaultTypeTransformation.booleanUnbox((Object)this.env.get("TOWER_ACCESS_TOKEN"))) && !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find(specs, (Closure)new _pluginsRequirement_closure5(this, this)))) {
            DefaultGroovyMethods.leftShift(specs, (Object)this.defaultPlugins.getPlugin("nf-tower"));
        }
        return specs;
    }

    protected List<PluginSpec> defaultPluginsConf(Map config) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String commaSepList = ShortTypeHandling.castToString((Object)this.env.get("NXF_PLUGINS_DEFAULT"));
        if (DefaultTypeTransformation.booleanUnbox((Object)commaSepList) && ScriptBytecodeAdapter.isNotCase((Object)commaSepList, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"true", "false"}))) {
            public final class _defaultPluginsConf_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _defaultPluginsConf_closure6(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PluginSpec doCall(Object it) {
                    return ((PluginsFacade)this.getThisObject()).defaultPlugins.hasPlugin(ShortTypeHandling.castToString((Object)it)) ? ((PluginsFacade)this.getThisObject()).defaultPlugins.getPlugin(ShortTypeHandling.castToString((Object)it)) : PluginSpec.parse(ShortTypeHandling.castToString((Object)it));
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _defaultPluginsConf_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return DefaultGroovyMethods.collect((Iterable)StringGroovyMethods.tokenize((CharSequence)commaSepList, (CharSequence)","), (Closure)new _defaultPluginsConf_closure6(this, this));
        }
        ArrayList<PluginSpec> plugins = new ArrayList<PluginSpec>();
        String workDir = (String)ScriptBytecodeAdapter.asType(config.get("workDir"), String.class);
        String bucketDir = (String)ScriptBytecodeAdapter.asType(config.get("bucketDir"), String.class);
        Object executor = Bolts.navigate(config, "process.executor");
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"awsbatch") || DefaultTypeTransformation.booleanUnbox((string6 = workDir) != null ? Boolean.valueOf(string6.startsWith("s3://")) : null) || DefaultTypeTransformation.booleanUnbox((string5 = bucketDir) != null ? Boolean.valueOf(string5.startsWith("s3://")) : null)) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-amazon"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"google-lifesciences") || DefaultTypeTransformation.booleanUnbox((string4 = workDir) != null ? Boolean.valueOf(string4.startsWith("gs://")) : null) || DefaultTypeTransformation.booleanUnbox((string3 = bucketDir) != null ? Boolean.valueOf(string3.startsWith("gs://")) : null)) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-google"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"azurebatch") || DefaultTypeTransformation.booleanUnbox((string2 = workDir) != null ? Boolean.valueOf(string2.startsWith("az://")) : null) || DefaultTypeTransformation.booleanUnbox((string = bucketDir) != null ? Boolean.valueOf(string.startsWith("az://")) : null)) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-azure"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"ignite") || ScriptBytecodeAdapter.compareEqual((Object)System.getProperty("nxf.node.daemon"), (Object)"true")) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-ignite"));
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-amazon"));
        }
        return plugins;
    }

    protected List<PluginSpec> parseConf(Map config) {
        List pluginsConf = (List)ScriptBytecodeAdapter.asType(config.get("plugins"), List.class);
        List list = pluginsConf;
        Integer n = list != null ? Integer.valueOf(list.size()) : null;
        ArrayList<PluginSpec> result = new ArrayList<PluginSpec>(DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0));
        if (DefaultTypeTransformation.booleanUnbox((Object)pluginsConf)) {
            String it = null;
            Iterator iterator = pluginsConf.iterator();
            while (iterator.hasNext()) {
                it = ShortTypeHandling.castToString(iterator.next());
                result.add(PluginSpec.parse(it, this.defaultPlugins));
            }
        }
        return result;
    }

    public synchronized void pullPlugins(List<String> ids) {
        this.updater.pullPlugins(ids);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startIfMissing(String pluginId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.env.get("NXF_PLUGINS_DEFAULT"), (Object)"false")) {
            return false;
        }
        if (this.isStarted(pluginId)) {
            return false;
        }
        PluginsFacade pluginsFacade = this;
        synchronized (pluginsFacade) {
            if (this.isStarted(pluginId)) {
                return false;
            }
            {
                this.start(pluginId);
                return true;
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PluginsFacade.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    protected PluginManager memoizedMethodPriv$defaultManager() {
        return new DefaultPluginManager();
    }

    @Generated
    public synchronized void setup() {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        this.setup((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Collections.class), Map.class));
    }

    @Generated
    public <T> List<T> getPriorityExtensions(Class<T> type) {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getPriorityExtensions(type, null);
        }
        return this.getPriorityExtensions(type, null);
    }

    @Generated
    public <T> Set<T> getScopedExtensions(Class<T> type) {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getScopedExtensions(type, null);
        }
        return this.getScopedExtensions(type, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.plugin.PluginsFacade");
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[1];
        stringArray[0] = "emptyMap";
        return new CallSiteArray(PluginsFacade.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PluginsFacade.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public PluginManager doCall(Object it) {
            return (PluginManager)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"memoizedMethodPriv$defaultManager", (Object)new Object[0]), PluginManager.class);
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public PluginManager doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

