/*
 * Decompiled with CFR 0.152.
 */
package nextflow.plugin;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import nextflow.extension.FilesEx;
import nextflow.plugin.CustomPluginManager;
import nextflow.plugin.LocalPluginRepository;
import nextflow.plugin.PluginSpec;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.pf4j.DefaultPluginLoader;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPluginManager
extends CustomPluginManager {
    private static Path PLUGINS_LOCAL_ROOT;
    private Path repository;
    private List<PluginSpec> specs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public LocalPluginManager(Path repository, List<PluginSpec> specs) {
        super(LocalPluginManager.makeLocalRoot());
        Path path;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.getLocalRoot())) {
            throw (Throwable)new IllegalArgumentException("Missing Local plugins root directory");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)repository)) {
            throw (Throwable)new IllegalArgumentException("Missing plugins repository directory");
        }
        this.repository = path = repository;
        List<PluginSpec> list = specs;
        this.specs = list;
    }

    protected static Path makeLocalRoot() {
        Reference result = new Reference((Object)PLUGINS_LOCAL_ROOT.resolve(UUID.randomUUID().toString()));
        if (!FilesEx.mkdirs((Path)result.get(), new FileAttribute[0])) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(Path)result.get()}, new String[]{"Unable to create plugins local directory: ", " -- Make sure you have write permissions in this directory path"})));
        }
        public final class _makeLocalRoot_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _makeLocalRoot_closure1(Object _outerInstance, Object _thisObject, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.result = reference = result;
            }

            public Boolean doCall(Object it) {
                return FilesEx.deleteDir((Path)ScriptBytecodeAdapter.castToType((Object)this.result.get(), Path.class));
            }

            @Generated
            public Object getResult() {
                return this.result.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _makeLocalRoot_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.addShutdownHook(Runtime.class, (Closure)new _makeLocalRoot_closure1(LocalPluginManager.class, LocalPluginManager.class, result));
        return (Path)result.get();
    }

    protected Path getLocalRoot() {
        return this.getPluginsRoot();
    }

    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return new ManifestPluginDescriptorFinder();
    }

    protected PluginLoader createPluginLoader() {
        return new DefaultPluginLoader((PluginManager)this);
    }

    protected PluginRepository createPluginRepository() {
        return new LocalPluginRepository(this.getLocalRoot());
    }

    public String loadPlugin(Path pluginPath) {
        Path symlink = this.createLinkFromPath(pluginPath);
        return super.loadPlugin(symlink);
    }

    @Override
    public PluginWrapper loadPluginFromPath(Path pluginPath) {
        Path symlink = this.createLinkFromPath(pluginPath);
        return super.loadPluginFromPath(symlink);
    }

    private Path createLinkFromPath(Path pluginPath) {
        if (pluginPath.startsWith(this.getLocalRoot())) {
            return pluginPath;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)pluginPath)) {
            throw (Throwable)new IllegalArgumentException("Plugin path cannot be null");
        }
        if (!Files.isDirectory(pluginPath, new LinkOption[0])) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginPath}, new String[]{"Plugin path must be a directory: ", ""})));
        }
        Path symlink = this.getLocalRoot().resolve(pluginPath.getFileName());
        this.createLink0(symlink, pluginPath);
        return symlink;
    }

    private void createLink0(Path symlink, Path pluginPath) {
        try {
            log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{symlink, pluginPath}, new String[]{"Creating local plugins root link: ", " \u2192 ", ""})));
            Files.createSymbolicLink(symlink, pluginPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{symlink}, new String[]{"Deleting existing local plugins root link: ", ""})));
            if (!this.sameTarget(symlink, pluginPath)) {
                Files.delete(symlink);
                Files.createSymbolicLink(symlink, pluginPath, new FileAttribute[0]);
            }
        }
    }

    private boolean sameTarget(Path link, Path target) {
        boolean bl = ScriptBytecodeAdapter.compareEqual((Object)Files.readSymbolicLink(link), (Object)target);
        try {
            return bl;
        }
        catch (IOException e) {
            boolean bl2 = false;
            return bl2;
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LocalPluginManager.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        Path path;
        PLUGINS_LOCAL_ROOT = path = Paths.get(".nextflow/plr", new String[0]);
        log = logger = LoggerFactory.getLogger((String)"nextflow.plugin.LocalPluginManager");
    }

    @Generated
    public List<PluginSpec> getSpecs() {
        return this.specs;
    }

    @Generated
    public void setSpecs(List<PluginSpec> list) {
        this.specs = list;
    }
}

