/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import nextflow.Global;
import nextflow.ISession;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.file.FileHolder;
import nextflow.io.SerializableMarker;
import nextflow.util.Bag;
import nextflow.util.CacheFunnel;
import nextflow.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHelper {
    private static final Logger log = LoggerFactory.getLogger(CacheHelper.class);
    private static HashFunction DEFAULT_HASHING = Hashing.murmur3_128();
    private static int HASH_BITS = DEFAULT_HASHING.bits();
    private static int HASH_BYTES = HASH_BITS / 8;
    private static final Map<String, Object> FIRST_ONLY = new HashMap<String, Object>(1);
    private static LoadingCache<Path, String> sha256Cache;

    public static HashFunction defaultHasher() {
        return DEFAULT_HASHING;
    }

    public static Hasher hasher(Object value) {
        return CacheHelper.hasher(value, HashMode.STANDARD);
    }

    public static Hasher hasher(Object value, HashMode mode) {
        return CacheHelper.hasher(DEFAULT_HASHING, value, mode);
    }

    public static Hasher hasher(HashFunction function, Object value, HashMode mode) {
        return CacheHelper.hasher(function.newHasher(), value, mode);
    }

    public static Hasher hasher(Hasher hasher, Object value, HashMode mode) {
        if (value == null) {
            return hasher;
        }
        if (value instanceof Boolean) {
            return hasher.putBoolean(((Boolean)value).booleanValue());
        }
        if (value instanceof Short) {
            return hasher.putShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return hasher.putInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return hasher.putLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return hasher.putFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return hasher.putDouble(((Double)value).doubleValue());
        }
        if (value instanceof Byte) {
            return hasher.putByte(((Byte)value).byteValue());
        }
        if (value instanceof Number) {
            return hasher.putUnencodedChars((CharSequence)value.toString());
        }
        if (value instanceof Character) {
            return hasher.putChar(((Character)value).charValue());
        }
        if (value instanceof CharSequence) {
            return hasher.putUnencodedChars((CharSequence)value);
        }
        if (value instanceof byte[]) {
            return hasher.putBytes((byte[])value);
        }
        if (value instanceof Object[]) {
            for (Object item : (Object[])value) {
                hasher = CacheHelper.hasher(hasher, item, mode);
            }
            return hasher;
        }
        if (value instanceof Map) {
            for (Object item : ((Map)value).values()) {
                hasher = CacheHelper.hasher(hasher, item, mode);
            }
            return hasher;
        }
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            hasher = CacheHelper.hasher(hasher, entry.getKey(), mode);
            hasher = CacheHelper.hasher(hasher, entry.getValue(), mode);
            return hasher;
        }
        if (value instanceof Bag || value instanceof Set) {
            return CacheHelper.hashUnorderedCollection(hasher, (Collection)value, mode);
        }
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                hasher = CacheHelper.hasher(hasher, item, mode);
            }
            return hasher;
        }
        if (value instanceof FileHolder) {
            return CacheHelper.hasher(hasher, ((FileHolder)value).getSourceObj(), mode);
        }
        if (value instanceof Path) {
            return CacheHelper.hashFile(hasher, (Path)value, mode);
        }
        if (value instanceof File) {
            return CacheHelper.hashFile(hasher, (File)value, mode);
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return hasher.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        }
        if (value instanceof VersionNumber) {
            return hasher.putInt(value.hashCode());
        }
        if (value instanceof SerializableMarker) {
            return hasher.putInt(value.hashCode());
        }
        if (value instanceof CacheFunnel) {
            return ((CacheFunnel)value).funnel(hasher, mode);
        }
        Bolts.debug1(log, FIRST_ONLY, "[WARN] Unknown hashing type: " + value.getClass());
        return hasher.putInt(value.hashCode());
    }

    private static Hasher hashFile(Hasher hasher, File file, HashMode mode) {
        return CacheHelper.hashFile(hasher, file.toPath(), mode);
    }

    private static Hasher hashFile(Hasher hasher, Path path, HashMode mode) {
        BasicFileAttributes attrs = null;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            log.debug("Unable to get file attributes file: {} -- Cause: {}", (Object)FilesEx.toUriString(path), (Object)e.toString());
        }
        catch (ProviderMismatchException e) {
            log.warn("File system is unable to get file attributes file: {} -- Cause: {}", (Object)FilesEx.toUriString(path), (Object)e.toString());
        }
        catch (Exception e) {
            log.warn("Unable to get file attributes file: {} -- Cause: {}", (Object)FilesEx.toUriString(path), (Object)e.toString());
        }
        if ((mode == HashMode.STANDARD || mode == HashMode.LENIENT) && CacheHelper.isAssetFile(path)) {
            if (attrs == null) {
                log.warn("Unable to fetch attribute for file: {} - Hash is inferred from Git repository commit Id", (Object)FilesEx.toUriString(path));
                return CacheHelper.hashFileAsset(hasher, path);
            }
            Path base = Global.getSession().getBaseDir();
            if (attrs.isDirectory()) {
                return CacheHelper.hashDirSha256(hasher, path, base);
            }
            return CacheHelper.hashFileSha256(hasher, path, base);
        }
        if (mode == HashMode.DEEP && attrs != null && attrs.isRegularFile()) {
            return CacheHelper.hashFileContent(hasher, path);
        }
        if (mode == HashMode.SHA256 && attrs != null && attrs.isRegularFile()) {
            return CacheHelper.hashFileSha256(hasher, path, null);
        }
        return CacheHelper.hashFileMetadata(hasher, path, attrs, mode);
    }

    protected static Hasher hashFileSha256(Hasher hasher, Path path, Path base) {
        try {
            log.trace("Hash sha-256 file content path={} - base={}", (Object)path, (Object)base);
            if (base != null) {
                hasher.putUnencodedChars((CharSequence)base.relativize(path).toString());
            }
            String sha256 = (String)sha256Cache.get((Object)path);
            hasher.putUnencodedChars((CharSequence)sha256);
        }
        catch (ExecutionException t) {
            Throwable err = t.getCause() != null ? t.getCause() : t;
            String msg = err.getMessage() != null ? err.getMessage() : err.toString();
            log.warn("Unable to compute sha-256 hashing for file: {} - Cause: {}", (Object)FilesEx.toUriString(path), (Object)msg);
        }
        return hasher;
    }

    protected static Hasher hashDirSha256(final Hasher hasher, Path dir, final Path base) {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    log.trace("Hash sha-256 dir content [FILE] path={} - base={}", (Object)path, (Object)base);
                    try {
                        if (base != null) {
                            hasher.putUnencodedChars((CharSequence)base.relativize(path).toString());
                        }
                        String sha256 = (String)sha256Cache.get((Object)path);
                        hasher.putUnencodedChars((CharSequence)sha256);
                        return FileVisitResult.CONTINUE;
                    }
                    catch (ExecutionException t) {
                        throw new IOException(t);
                    }
                }

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                    log.trace("Hash sha-256 dir content [DIR] path={} - base={}", (Object)path, (Object)base);
                    if (base != null) {
                        hasher.putUnencodedChars((CharSequence)base.relativize(path).toString());
                    }
                    hasher.putUnencodedChars((CharSequence)base.relativize(path).toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException t) {
            Throwable err = t.getCause() != null ? t.getCause() : t;
            String msg = err.getMessage() != null ? err.getMessage() : err.toString();
            log.warn("Unable to compute sha-256 hashing for directory: {} - Cause: {}", (Object)FilesEx.toUriString(dir), (Object)msg);
        }
        return hasher;
    }

    protected static String hashFileSha256Impl0(Path path) throws IOException {
        log.debug("Hash asset file sha-256: {}", (Object)path);
        Hasher hasher = Hashing.sha256().newHasher();
        ByteStreams.copy((InputStream)Files.newInputStream(path, new OpenOption[0]), (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
        return hasher.hash().toString();
    }

    private static Hasher hashFileAsset(Hasher hasher, Path path) {
        log.debug("Hash asset file: {}", (Object)path);
        hasher.putUnencodedChars((CharSequence)Global.getSession().getCommitId());
        return hasher;
    }

    private static Hasher hashFileMetadata(Hasher hasher, Path file, BasicFileAttributes attrs, HashMode mode) {
        hasher = hasher.putUnencodedChars((CharSequence)file.toAbsolutePath().toString());
        if (attrs != null) {
            hasher = hasher.putLong(attrs.size());
            if (attrs.lastModifiedTime() != null && mode != HashMode.LENIENT) {
                hasher = hasher.putLong(attrs.lastModifiedTime().toMillis());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Hashing file meta: path={}; size={}, lastModified={}, mode={}", new Object[]{file.toAbsolutePath().toString(), attrs != null ? Long.valueOf(attrs.size()) : "--", attrs != null && attrs.lastModifiedTime() != null && mode != HashMode.LENIENT ? Long.valueOf(attrs.lastModifiedTime().toMillis()) : "--", mode});
        }
        return hasher;
    }

    private static Hasher hashFileContent(Hasher hasher, Path path) {
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        try {
            Files.copy(path, output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to hash content: " + FilesEx.toUriString(path), e);
        }
        finally {
            FilesEx.closeQuietly(output);
        }
        return hasher;
    }

    static HashCode hashContent(Path file) {
        return CacheHelper.hashContent(file, null);
    }

    static HashCode hashContent(Path file, HashFunction function) {
        if (function == null) {
            function = DEFAULT_HASHING;
        }
        Hasher hasher = function.newHasher();
        return CacheHelper.hashFileContent(hasher, file).hash();
    }

    private static Hasher hashUnorderedCollection(Hasher hasher, Collection collection, HashMode mode) {
        byte[] resultBytes = new byte[HASH_BYTES];
        for (Object item : collection) {
            byte[] nextBytes = CacheHelper.hasher(item, mode).hash().asBytes();
            if (nextBytes.length != resultBytes.length) {
                throw new IllegalStateException("All hash codes must have the same bit length");
            }
            for (int i = 0; i < nextBytes.length; ++i) {
                int n = i;
                resultBytes[n] = (byte)(resultBytes[n] + nextBytes[i]);
            }
        }
        return hasher.putBytes(resultBytes);
    }

    protected static boolean isAssetFile(Path path) {
        ISession session = Global.getSession();
        if (session == null) {
            return false;
        }
        if (session.getCommitId() == null) {
            return false;
        }
        if (session.getBaseDir().getFileSystem() != path.getFileSystem()) {
            return false;
        }
        return path.startsWith(session.getBaseDir());
    }

    static {
        FIRST_ONLY.put("firstOnly", Boolean.TRUE);
        sha256Cache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Path, String>(){

            public String load(Path key) throws Exception {
                return CacheHelper.hashFileSha256Impl0(key);
            }
        });
    }

    public static enum HashMode {
        STANDARD,
        DEEP,
        LENIENT,
        SHA256;

        private static HashMode defaultValue;

        public static HashMode DEFAULT() {
            return defaultValue != null ? defaultValue : STANDARD;
        }

        public static HashMode of(Object obj) {
            if (obj == null || obj instanceof Boolean) {
                return null;
            }
            if (obj instanceof CharSequence) {
                if ("true".equals(obj) || "false".equals(obj)) {
                    return null;
                }
                if ("standard".equals(obj)) {
                    return STANDARD;
                }
                if ("lenient".equals(obj)) {
                    return LENIENT;
                }
                if ("deep".equals(obj)) {
                    return DEEP;
                }
                if ("sha256".equals(obj)) {
                    return SHA256;
                }
            }
            LoggerFactory.getLogger(HashMode.class).warn("Unknown cache mode: {}", (Object)obj.toString());
            return null;
        }

        static {
            if (System.getenv().containsKey("NXF_CACHE_MODE")) {
                defaultValue = HashMode.valueOf(System.getenv().get("NXF_CACHE_MODE"));
            }
        }
    }
}

